/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.datatype.ValueResolver;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public final class DataSetArrayHelper {
    private static final ObjectConverter<Object> NON_CONVERTER = new ObjectConverter<Object>(){

        @Override
        public Object convert(Object value) {
            return value;
        }
    };

    private DataSetArrayHelper() {
    }

    public static Object getElementAtIndex(Object array, int index) {
        DataSetArrayHelper.checkArguments(array, index);
        ArrayType at = ArrayType.getArrayType(array);
        if (at == null) {
            throw new IllegalArgumentException("Can only index one-dimensional arrays.");
        }
        Object element = at.getElementAt(array, index);
        return element;
    }

    public static <T> void setElementAtIndex(Object array, int index, T value) {
        DataSetArrayHelper.checkArguments(array, index);
        ArrayType at = ArrayType.getArrayType(array);
        if (at == null) {
            throw new IllegalArgumentException("Can only index one-dimensional arrays.");
        }
        at.setElementAt(array, index, value);
    }

    private static void checkArguments(Object array, int index) {
        if (array == null) {
            throw new IllegalArgumentException("Must have a non-null array.");
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index.");
        }
    }

    public static boolean isOneDimensionalArray(Object array) {
        return ArrayType.getArrayType(array) != null;
    }

    public static SortedMap<Integer, Object> convertArrayToMap(Object array) {
        return DataSetArrayHelper.convertArrayToMap(array, NON_CONVERTER);
    }

    public static String convertArrayToString(Object array) {
        return DataSetArrayHelper.convertArrayToString(array, new DisplayStringConverter(null), false);
    }

    public static String convertArrayToString(Object array, DataType valueDataType) {
        return DataSetArrayHelper.convertArrayToString(array, new DisplayStringConverter(valueDataType), false);
    }

    public static String convertArrayToString(Object array, ObjectConverter<String> valueConverter, boolean includeIndices) {
        ArrayType at = ArrayType.getArrayType(array);
        if (at == null) {
            throw new IllegalArgumentException("Can not resolve array type for object");
        }
        StringBuilder sb = new StringBuilder();
        int len = at.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object e;
            if (i == 0) {
                sb.append('[');
            }
            if (includeIndices) {
                sb.append(i).append("=");
            }
            if ((e = at.getElementAt(array, i)) == array) {
                sb.append("[this array]");
            } else if (e instanceof Map) {
                sb.append(DataSetArrayHelper.convertMapToString(e, valueConverter, includeIndices));
            } else if (DataSetArrayHelper.isOneDimensionalArray(e)) {
                sb.append(DataSetArrayHelper.convertArrayToString(e, valueConverter, includeIndices));
            } else {
                sb.append(valueConverter.convert(e));
            }
            if (i < len - 1) {
                sb.append(", ");
                continue;
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public static String convertMapToString(Object map) {
        return DataSetArrayHelper.convertMapToString(map, new DisplayStringConverter(null), false);
    }

    public static String convertMapToString(Object map, DataType valueDataType) {
        return DataSetArrayHelper.convertMapToString(map, new DisplayStringConverter(valueDataType), false);
    }

    public static String convertMapToString(Object map, ObjectConverter<String> valueConverter, boolean includeArrayIndices) {
        return DataSetArrayHelper.convertMapToString(map, null, valueConverter, includeArrayIndices);
    }

    public static String convertMapToString(Object map, ObjectConverter<String> keyConverter, ObjectConverter<String> valueConverter, boolean includeArrayIndices) {
        if (!(map instanceof Map)) {
            throw new IllegalArgumentException("Cannot print non map objects");
        }
        StringBuilder builder = new StringBuilder("{");
        boolean first = true;
        for (Map.Entry entry : ((Map)map).entrySet()) {
            if (!first) {
                builder.append(", ");
            }
            first = false;
            Object key = entry.getKey();
            String keyString = keyConverter != null ? keyConverter.convert(key) : key.toString();
            builder.append(keyString);
            builder.append("=");
            Object value = entry.getValue();
            if (value == null) {
                builder.append("null");
                continue;
            }
            if (value instanceof Map) {
                builder.append(DataSetArrayHelper.convertMapToString(value, valueConverter, includeArrayIndices));
                continue;
            }
            if (DataSetArrayHelper.isOneDimensionalArray(value)) {
                builder.append(DataSetArrayHelper.convertArrayToString(value, valueConverter, includeArrayIndices));
                continue;
            }
            builder.append(valueConverter.convert(value));
        }
        builder.append("}");
        return builder.toString();
    }

    public static <T> SortedMap<Integer, T> convertArrayToMap(Object array, ObjectConverter<T> converter) {
        DataSetArrayHelper.checkArguments(array, 0);
        if (converter == null) {
            throw new IllegalArgumentException("Need a non-null converter.");
        }
        ArrayType at = ArrayType.getArrayType(array);
        if (at == null) {
            throw new IllegalArgumentException("Can only index one-dimensional arrays.");
        }
        return new ArrayBasedMap<T>(array, at, converter);
    }

    public static class FieldDisplayStringConverter
    implements ObjectConverter<String> {
        private FieldDefinition myFieldDefinition;

        public FieldDisplayStringConverter(FieldDefinition field) {
            if (field == null) {
                throw new IllegalArgumentException("Null field not permitted.");
            }
            this.myFieldDefinition = field;
        }

        public FieldDefinition getField() {
            return this.myFieldDefinition;
        }

        @Override
        public String convert(Object value) {
            ValueResolver resolver = DataType.createTypeIndependentContextBasedValueResolver().withFieldDefinition(this.myFieldDefinition).disableLazyEvaluatedValuePreference().finish();
            Object useVal = value;
            if (value instanceof String && this.myFieldDefinition.getTypedDataType() != DataType.STRING) {
                useVal = resolver.parseValueString((String)value);
            }
            String ret = null;
            if (useVal != null) {
                try {
                    ret = resolver.makeDisplayString(useVal);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ret != null ? ret : String.valueOf(value);
        }
    }

    public static class DisplayStringConverter
    implements ObjectConverter<String> {
        private DataType myDataType;

        public DisplayStringConverter(DataType dataType) {
            this.myDataType = dataType;
        }

        @Override
        public String convert(Object value) {
            try {
                return this.myDataType == null ? DataType.valueToString(value) : this.myDataType.makeDisplayString(value);
            }
            catch (IllegalArgumentException ex) {
                return String.valueOf(value);
            }
        }
    }

    private static class ArrayIndexBasedEntry<T>
    implements Map.Entry<Integer, T> {
        private Integer myKey;
        private T myValue;

        private ArrayIndexBasedEntry(int index, T value) {
            this.myKey = index;
            this.myValue = value;
        }

        @Override
        public Integer getKey() {
            return this.myKey;
        }

        @Override
        public T getValue() {
            return this.myValue;
        }

        @Override
        public T setValue(T value) {
            throw new UnsupportedOperationException("Unmodifiable entry.");
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
            result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ArrayIndexBasedEntry other = (ArrayIndexBasedEntry)obj;
            if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
                return false;
            }
            return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
        }
    }

    private static class ArrayBasedMap<T>
    extends AbstractMap<Integer, T>
    implements SortedMap<Integer, T> {
        private Object myArray;
        private ArrayBasedEntrySet myEntrySet;
        private ArrayType myArrayType;
        private ObjectConverter<T> myConverter;
        private int myStart;
        private int myEnd;

        ArrayBasedMap(Object array, ArrayType arrayType, ObjectConverter<T> converter) {
            this.myArray = array;
            this.myArrayType = arrayType;
            this.myConverter = converter;
            this.myStart = 0;
            this.myEnd = arrayType.getLength(array);
        }

        private ArrayBasedMap(Object array, ArrayType arrayType, ObjectConverter<T> converter, int start, int end) {
            this.myArray = array;
            this.myArrayType = arrayType;
            this.myConverter = converter;
            this.myStart = start;
            this.myEnd = end;
        }

        @Override
        public Set<Map.Entry<Integer, T>> entrySet() {
            if (this.myEntrySet == null) {
                this.myEntrySet = new ArrayBasedEntrySet();
            }
            return this.myEntrySet;
        }

        @Override
        public Comparator<? super Integer> comparator() {
            return null;
        }

        @Override
        public Integer firstKey() {
            return this.myStart;
        }

        @Override
        public SortedMap<Integer, T> headMap(Integer toKey) {
            return this.subMap(this.myStart, toKey);
        }

        @Override
        public Integer lastKey() {
            return this.myEnd - 1;
        }

        @Override
        public SortedMap<Integer, T> subMap(Integer fromKey, Integer toKey) {
            if (fromKey < this.myStart || toKey > this.myEnd || toKey < fromKey) {
                throw new IllegalArgumentException("Keys out of range.");
            }
            return new ArrayBasedMap<T>(this.myArray, this.myArrayType, this.myConverter, fromKey, toKey);
        }

        @Override
        public SortedMap<Integer, T> tailMap(Integer fromKey) {
            return this.subMap(fromKey, this.myEnd);
        }

        private class ArrayBasedEntryIterator
        implements Iterator<Map.Entry<Integer, T>> {
            private int myIndex;

            private ArrayBasedEntryIterator() {
                this.myIndex = ArrayBasedMap.this.myStart - 1;
            }

            @Override
            public boolean hasNext() {
                return this.myIndex + 1 < ArrayBasedMap.this.myEnd;
            }

            @Override
            public Map.Entry<Integer, T> next() {
                ++this.myIndex;
                Object element = ArrayBasedMap.this.myConverter.convert(ArrayBasedMap.this.myArrayType.getElementAt(ArrayBasedMap.this.myArray, this.myIndex));
                return new ArrayIndexBasedEntry(this.myIndex, element);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Unmodifiable iterator.");
            }
        }

        private class ArrayBasedEntrySet
        extends AbstractSet<Map.Entry<Integer, T>> {
            private ArrayBasedEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<Integer, T>> iterator() {
                return new ArrayBasedEntryIterator();
            }

            @Override
            public int size() {
                return ArrayBasedMap.this.myEnd - ArrayBasedMap.this.myStart;
            }
        }
    }

    public static interface ObjectConverter<T> {
        public T convert(Object var1);
    }

    static enum ArrayType {
        BYTE{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof byte[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return ((byte[])array)[index];
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((byte[])array)[index] = (Byte)value;
            }

            @Override
            int getLength(Object array) {
                return ((byte[])array).length;
            }
        }
        ,
        CHAR{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof char[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return Character.valueOf(((char[])array)[index]);
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((char[])array)[index] = ((Character)value).charValue();
            }

            @Override
            int getLength(Object array) {
                return ((char[])array).length;
            }
        }
        ,
        SHORT{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof short[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return ((short[])array)[index];
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((short[])array)[index] = (Short)value;
            }

            @Override
            int getLength(Object array) {
                return ((short[])array).length;
            }
        }
        ,
        INT{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof int[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return ((int[])array)[index];
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((int[])array)[index] = (Integer)value;
            }

            @Override
            int getLength(Object array) {
                return ((int[])array).length;
            }
        }
        ,
        LONG{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof long[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return ((long[])array)[index];
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((long[])array)[index] = (Long)value;
            }

            @Override
            int getLength(Object array) {
                return ((long[])array).length;
            }
        }
        ,
        FLOAT{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof float[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return Float.valueOf(((float[])array)[index]);
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((float[])array)[index] = ((Float)value).floatValue();
            }

            @Override
            int getLength(Object array) {
                return ((float[])array).length;
            }
        }
        ,
        DOUBLE{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof double[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return ((double[])array)[index];
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((double[])array)[index] = (Double)value;
            }

            @Override
            int getLength(Object array) {
                return ((double[])array).length;
            }
        }
        ,
        BOOLEAN{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof boolean[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return ((boolean[])array)[index];
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((boolean[])array)[index] = (Boolean)value;
            }

            @Override
            int getLength(Object array) {
                return ((boolean[])array).length;
            }
        }
        ,
        OBJECT{

            @Override
            boolean isArrayOf(Object array) {
                return array instanceof Object[];
            }

            @Override
            Object getElementAt(Object array, int index) {
                return ((Object[])array)[index];
            }

            @Override
            void setElementAt(Object array, int index, Object value) {
                ((Object[])array)[index] = value;
            }

            @Override
            int getLength(Object array) {
                return ((Object[])array).length;
            }
        };


        abstract int getLength(Object var1);

        abstract boolean isArrayOf(Object var1);

        abstract Object getElementAt(Object var1, int var2);

        abstract void setElementAt(Object var1, int var2, Object var3);

        static ArrayType getArrayType(Object array) {
            ArrayType result = null;
            if (array != null) {
                for (ArrayType at : ArrayType.values()) {
                    if (!at.isArrayOf(array)) continue;
                    result = at;
                    break;
                }
            }
            return result;
        }
    }
}

