/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.dataset.ComplexKey;
import com.ericsson.ere.dataset.DataDescriber;
import com.ericsson.ere.dataset.DataSetArrayHelper;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultDataDescriber
implements DataDescriber {
    protected final ClassRepository myClassRepository;

    public DefaultDataDescriber() {
        this.myClassRepository = null;
    }

    public DefaultDataDescriber(ClassRepository repository) {
        this.myClassRepository = repository;
    }

    @Override
    public String describeObject(Object object, DataType dataType) {
        return this.describeObject(object, new DataSetArrayHelper.DisplayStringConverter(dataType), false);
    }

    @Override
    public String describeObject(Object object, FieldDefinition field) {
        if (field != null) {
            boolean isArray = field.isArray();
            FieldKeyConverter keyConverter = null;
            String[] keyFields = field.getKeyFields();
            if (keyFields.length > 0 && this.myClassRepository != null) {
                ArrayList<DataSetArrayHelper.ObjectConverter<String>> converters = new ArrayList<DataSetArrayHelper.ObjectConverter<String>>();
                for (int i = 0; i < keyFields.length; ++i) {
                    FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(keyFields[i]);
                    converters.add(new DataSetArrayHelper.FieldDisplayStringConverter(fd));
                }
                keyConverter = new FieldKeyConverter(converters);
            }
            return this.describeObject(object, keyConverter, new DataSetArrayHelper.FieldDisplayStringConverter(field), isArray);
        }
        String s = "";
        if (object != null) {
            s = object.toString();
        }
        return s;
    }

    protected boolean includeArrayIndices() {
        return true;
    }

    protected String describeObject(Object object, DataSetArrayHelper.ObjectConverter<String> valueConverter, boolean treatMapAsArray) {
        return this.describeObject(object, null, valueConverter, treatMapAsArray);
    }

    protected String describeObject(Object object, DataSetArrayHelper.ObjectConverter<String> keyConverter, DataSetArrayHelper.ObjectConverter<String> valueConverter, boolean treatMapAsArray) {
        String s;
        if (object == null) {
            s = "";
        } else if (DataSetArrayHelper.isOneDimensionalArray(object)) {
            boolean includeArrayIndices = this.includeArrayIndices();
            if (valueConverter instanceof DataSetArrayHelper.FieldDisplayStringConverter && ((DataSetArrayHelper.FieldDisplayStringConverter)valueConverter).getField().isSet()) {
                includeArrayIndices = false;
            }
            s = DataSetArrayHelper.convertArrayToString(object, valueConverter, includeArrayIndices);
        } else if (object instanceof Map) {
            s = DataSetArrayHelper.convertMapToString(object, keyConverter, valueConverter, this.includeArrayIndices());
            if (treatMapAsArray) {
                String str = s.substring(1, s.length() - 1);
                s = "[" + str + "]";
            }
        } else {
            s = object instanceof Set ? DataSetArrayHelper.convertArrayToString(((Set)object).toArray(), valueConverter, false) : valueConverter.convert(object);
        }
        return s;
    }

    protected static class FieldKeyConverter
    implements DataSetArrayHelper.ObjectConverter<String> {
        private List<DataSetArrayHelper.ObjectConverter<String>> myConverters;

        protected FieldKeyConverter(DataSetArrayHelper.ObjectConverter<String>[] converters) {
            this.myConverters = Arrays.asList(converters);
        }

        protected FieldKeyConverter(List<DataSetArrayHelper.ObjectConverter<String>> converters) {
            this.myConverters = converters;
        }

        @Override
        public String convert(Object value) {
            boolean multi;
            Object[] values = this.expandValues(value);
            if (values.length != this.myConverters.size()) {
                throw new IllegalArgumentException("Value does not match converters: " + value);
            }
            StringBuilder b = new StringBuilder();
            boolean bl = multi = values.length > 1;
            if (multi) {
                b.append("(");
            }
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.myConverters.get(i).convert(values[i]));
            }
            if (multi) {
                b.append(")");
            }
            return b.toString();
        }

        private Object[] expandValues(Object value) {
            Object[] ret;
            if (value instanceof ComplexKey) {
                ComplexKey ck = (ComplexKey)value;
                ret = new Object[ck.getKeyLength()];
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = ck.getKeyObjectForIndex(i);
                }
            } else {
                ret = new Object[]{value};
            }
            return ret;
        }
    }
}

