/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.calendar.CalendarDate;
import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.DataSetArrayHelper;
import com.ericsson.ere.dataset.DataSetValueForKeyNotFoundException;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataSetPrinter;
import com.ericsson.ere.dataset.IncompatibleDataSetValueException;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.math.RatingDecimal;
import com.ericsson.ere.math.RatingDecimalUtil;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Decimal;
import ericsson.ere.datatype.MonetaryUnits;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.UnsignedInt16;
import ericsson.ere.datatype.UnsignedInt32;
import ericsson.ere.datatype.UnsignedInt8;
import ericsson.ere.management.Service;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultDataSet
extends AbstractDataSet {
    private static final DefaultDataSetPrinter DATASET_INFO_PRINTER = new DefaultDataSetPrinter();
    protected Map<Object, Object> myValues = new HashMap<Object, Object>();
    protected boolean myStopFlag = false;
    private static final long DAY_IN_MILLIS = 86400000L;

    public DefaultDataSet() {
    }

    public DefaultDataSet(Service service) {
        super(service);
    }

    @Deprecated
    public DefaultDataSet(DefaultDataSet dataSet) {
        throw new UnsupportedOperationException("Cloning via copy constructor not supported.");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultDataSet set = (DefaultDataSet)super.clone();
        set.myValues = this.recursiveCloner(this.myValues);
        return set;
    }

    private Map<Object, Object> recursiveCloner(Map<?, ?> originalMap) {
        HashMap<Object, Object> newHashMap = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> currentEntry : originalMap.entrySet()) {
            Object value = currentEntry.getValue();
            if (value instanceof Map) {
                newHashMap.put(currentEntry.getKey(), this.recursiveCloner((Map)value));
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                newHashMap.put(currentEntry.getKey(), ((Object[])value).clone());
                continue;
            }
            newHashMap.put(currentEntry.getKey(), value);
        }
        return newHashMap;
    }

    public void setValueMap(Map<Object, Object> map) {
        this.myValues = map;
    }

    @Override
    public boolean hasDataForKey(int tag, Key key) {
        this.checkForNullKey(key);
        try {
            Object mapOrArray = this.getDataAsObject(tag);
            return this.handleHasDataForKey(mapOrArray, key);
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean hasDataForKey(Object name, Key key) {
        this.checkForNullKey(key);
        try {
            Object mapOrArray = this.getDataAsObject(name);
            return this.handleHasDataForKey(mapOrArray, key);
        }
        catch (DataSetValueNotFoundException e) {
            return false;
        }
    }

    private boolean handleHasDataForKey(Object mapOrArray, Key key) {
        try {
            this.handleGetDataForKey(mapOrArray, key);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean hasData(int tag) {
        return this.myValues.containsKey(tag);
    }

    @Override
    public Object getDataAsObject(int tag) {
        Object object = this.myValues.get(tag);
        if (object == null) {
            throw new DataSetValueNotFoundException();
        }
        return object;
    }

    @Override
    public Object getDataAsObject(Object name) {
        Object retObjValue = this.myValues.get(name);
        if (retObjValue == null) {
            throw new DataSetValueNotFoundException(String.valueOf(name));
        }
        return retObjValue;
    }

    @Override
    public boolean hasData(Object name) {
        return this.myValues.containsKey(name);
    }

    @Override
    public void setDataAsObject(int tag, Object value) {
        this.myValues.put(tag, value);
    }

    @Override
    public void setDataAsObject(Object name, Object value) {
        this.myValues.put(name, value);
    }

    @Override
    public byte getDataAsByte(int tag) {
        Object value = this.getDataAsObject(tag);
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return Byte.parseByte(value.toString());
    }

    @Override
    public byte getDataAsByte(Object name) {
        Object value = this.getDataAsObject(name);
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        return Byte.parseByte(value.toString());
    }

    @Override
    public void setDataAsByte(int tag, byte value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsByte(Object name, byte value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public short getDataAsShort(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToShort(value);
    }

    @Override
    public short getDataAsShort(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToShort(value);
    }

    @Override
    public void setDataAsShort(int tag, short value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsShort(Object name, short value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public int getDataAsInt(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToInteger(value);
    }

    @Override
    public int getDataAsInt(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToInteger(value);
    }

    @Override
    public void setDataAsInt(int tag, int value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsInt(Object name, int value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public long getDataAsLong(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToLong(value);
    }

    @Override
    public long getDataAsLong(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToLong(value);
    }

    @Override
    public void setDataAsLong(int tag, long value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsLong(Object name, long value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public double getDataAsDouble(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToDouble(value);
    }

    @Override
    public double getDataAsDouble(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToDouble(value);
    }

    @Override
    public void setDataAsRatingDecimal(int tag, RatingDecimal value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsRatingDecimal(Object name, RatingDecimal value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public RatingDecimal getDataAsRatingDecimal(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToRatingDecimal(value);
    }

    @Override
    public RatingDecimal getDataAsRatingDecimal(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToRatingDecimal(value);
    }

    @Override
    public void setDataAsDouble(int tag, double value) {
        this.setDataAsObject(tag, (Object)new Double(value));
    }

    @Override
    public void setDataAsDouble(Object name, double value) {
        this.setDataAsObject(name, (Object)new Double(value));
    }

    @Override
    public String getDataAsString(int tag) {
        Object value = this.getDataAsObject(tag);
        return value.toString();
    }

    @Override
    public String getDataAsString(Object name) {
        Object value = this.getDataAsObject(name);
        return value.toString();
    }

    @Override
    public void setDataAsString(int tag, String value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsString(Object name, String value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public BigDecimal getDataAsBigDecimal(int tag) {
        Object value = this.getDataAsObject(tag);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public BigDecimal getDataAsBigDecimal(Object name) {
        Object value = this.getDataAsObject(name);
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public void setDataAsBigDecimal(int tag, BigDecimal value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsBigDecimal(Object name, BigDecimal value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public BigInteger getDataAsBigInteger(int tag) {
        Object value = this.getDataAsObject(tag);
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        return new BigInteger(value.toString());
    }

    @Override
    public BigInteger getDataAsBigInteger(Object name) {
        Object value = this.getDataAsObject(name);
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        return new BigInteger(value.toString());
    }

    @Override
    public void setDataAsBigInteger(int tag, BigInteger value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsBigInteger(Object name, BigInteger value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public Number getDataAsNumber(int tag) {
        Object value = this.getDataAsObject(tag);
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new ClassCastException("Field is not an instance of Number");
    }

    @Override
    public Number getDataAsNumber(Object name) {
        Object value = this.getDataAsObject(name);
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new ClassCastException("Field is not an instance of Number");
    }

    @Override
    public void setDataAsNumber(int tag, Number value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsNumber(Object name, Number value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public boolean shallExecutionStop() {
        return this.myStopFlag;
    }

    @Override
    public void stopExecution() {
        this.myStopFlag = true;
    }

    public void resumeExecution() {
        this.myStopFlag = false;
    }

    public String toString() {
        return DATASET_INFO_PRINTER.getInfoString(this);
    }

    @Deprecated
    protected void valuesToString(StringBuilder buf) {
        DATASET_INFO_PRINTER.valuesToString(null, this, buf);
    }

    @Deprecated
    protected void contextValuesToString(StringBuilder buf) {
        DATASET_INFO_PRINTER.contextValuesToString(null, this, buf);
    }

    @Override
    public boolean getDataAsBoolean(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToBoolean(value);
    }

    @Override
    public boolean getDataAsBoolean(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToBoolean(value);
    }

    @Override
    public void setDataAsBoolean(int tag, boolean value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsBoolean(Object name, boolean value) {
        this.setDataAsObject(name, (Object)value);
    }

    public void cancelStopExecution() {
        this.myStopFlag = false;
    }

    @Override
    public void setDataAsUnsignedInt32(Object name, UnsignedInt32 value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public UnsignedInt32 getDataAsUnsignedInt32(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToUnsignedInt32(value);
    }

    @Override
    public void setDataAsUnsignedInt32(int tag, UnsignedInt32 value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public UnsignedInt32 getDataAsUnsignedInt32(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToUnsignedInt32(value);
    }

    @Override
    public void setDataAsUnsignedInt16(Object name, UnsignedInt16 value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public UnsignedInt16 getDataAsUnsignedInt16(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToUnsignedInt16(value);
    }

    @Override
    public void setDataAsUnsignedInt16(int tag, UnsignedInt16 value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public UnsignedInt16 getDataAsUnsignedInt16(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToUnsignedInt16(value);
    }

    @Override
    public void setDataAsUnsignedInt8(Object name, UnsignedInt8 value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public UnsignedInt8 getDataAsUnsignedInt8(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToUnsignedInt8(value);
    }

    @Override
    public void setDataAsUnsignedInt8(int tag, UnsignedInt8 value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public UnsignedInt8 getDataAsUnsignedInt8(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToUnsignedInt8(value);
    }

    @Override
    public void setDataAsMonetaryUnits(Object name, MonetaryUnits value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public MonetaryUnits getDataAsMonetaryUnits(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToMonetaryUnits(value);
    }

    @Override
    public void setDataAsMonetaryUnits(int tag, MonetaryUnits value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public MonetaryUnits getDataAsMonetaryUnits(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToMonetaryUnits(value);
    }

    @Override
    public Amount getDataAsAmount(int tag) {
        return (Amount)this.getDataAsObject(tag);
    }

    @Override
    public Amount getDataAsAmount(Object name) {
        return (Amount)this.getDataAsObject(name);
    }

    @Override
    public void setDataAsAmount(int tag, Amount value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsAmount(Object name, Amount value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public void setDataAsDecimal(Object name, Decimal value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public Decimal getDataAsDecimal(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToDecimal(value);
    }

    @Override
    public void setDataAsDecimal(int tag, Decimal value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public Decimal getDataAsDecimal(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToDecimal(value);
    }

    @Override
    public void setDataAsTime(Object name, Time value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public Time getDataAsTime(Object name) {
        Object value = this.getDataAsObject(name);
        if (value instanceof Time) {
            return (Time)value;
        }
        return new Time(value.toString());
    }

    @Override
    public void setDataAsTime(int tag, Time value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public Time getDataAsTime(int tag) {
        Object value = this.getDataAsObject(tag);
        if (value instanceof Time) {
            return (Time)value;
        }
        return new Time(value.toString());
    }

    @Override
    public void setDataAsBcdString(Object name, BcdString value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public BcdString getDataAsBcdString(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToBcdString(value);
    }

    @Override
    public void setDataAsBcdString(int tag, BcdString value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public BcdString getDataAsBcdString(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToBcdString(value);
    }

    @Override
    public void setDataAsOctetString(Object name, OctetString value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public OctetString getDataAsOctetString(Object name) {
        Object value = this.getDataAsObject(name);
        return DefaultDataSet.convertToOctetString(value);
    }

    @Override
    public void setDataAsOctetString(int tag, OctetString value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public OctetString getDataAsOctetString(int tag) {
        Object value = this.getDataAsObject(tag);
        return DefaultDataSet.convertToOctetString(value);
    }

    @Override
    public void setDataAsDate(Object name, Date value) {
        this.setDataAsObject(name, (Object)value);
    }

    @Override
    public Date getDataAsDate(Object name) {
        Object value = this.getDataAsObject(name);
        if (value instanceof EREDate) {
            return ((EREDate)value).asDate();
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return new Date(value.toString());
    }

    @Override
    public void setDataAsDate(int tag, Date value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public Date getDataAsDate(int tag) {
        Object obj = this.getDataAsObject(tag);
        if (obj instanceof EREDate) {
            return ((EREDate)obj).asDate();
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        return new Date(obj.toString());
    }

    @Override
    public Long getCurrentTimeAsDaysSinceEpoch() {
        return DefaultDataSet.getDaysForDate(this.getCurrentTime());
    }

    @Override
    public Long getStartTimeAsDaysSinceEpoch() {
        return DefaultDataSet.getDaysForDate(this.getStartTime());
    }

    @Override
    public Long getDataAsDaysSinceEpoch(int tag) {
        return DefaultDataSet.getDaysForDate(this.getDataAsObject(tag));
    }

    @Override
    public Long getDataAsDaysSinceEpoch(Object name) {
        return DefaultDataSet.getDaysForDate(this.getDataAsObject(name));
    }

    private static long getDaysForDate(Object dateObject) {
        if (dateObject instanceof EREDate) {
            return ((EREDate)dateObject).getDaysSince19700101();
        }
        if (dateObject instanceof CalendarDate) {
            return ((CalendarDate)dateObject).getDaysSince19700101();
        }
        long millis = DefaultDataSet.getMillisSecondsForDate(dateObject);
        return (millis - millis % 86400000L) / 86400000L;
    }

    private static long getMillisSecondsForDate(Object dateObject) {
        Object obj = dateObject;
        if (obj instanceof Time) {
            obj = ((Time)obj).getCalendar();
        }
        if (obj instanceof Date) {
            Date date = (Date)obj;
            return date.getTime() - (long)(date.getTimezoneOffset() * 60 * 1000);
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return cal.getTimeInMillis() + (long)cal.get(15) + (long)cal.get(16);
        }
        throw new IllegalArgumentException(obj.getClass() + " NOT supported.");
    }

    @Override
    public Object getDataAsTypedObjectForKey(Object name, Key key, DataType dataType) {
        this.checkForNullKey(key);
        Object dataObject = this.getDataAsObject(name);
        Object returnObject = null;
        try {
            returnObject = this.convertToDataType(this.handleGetDataForKey(dataObject, key), dataType);
        }
        catch (IncompatibleDataSetValueException idsvex) {
            throw idsvex;
        }
        catch (RuntimeException rex) {
            throw new DataSetValueForKeyNotFoundException(name.toString(), key, (Throwable)rex);
        }
        return returnObject;
    }

    @Override
    public Object getDataAsTypedObjectForKey(int tag, Key key, DataType dataType) {
        this.checkForNullKey(key);
        Object dataObject = this.getDataAsObject(tag);
        Object returnObject = null;
        try {
            returnObject = this.convertToDataType(this.handleGetDataForKey(dataObject, key), dataType);
        }
        catch (IncompatibleDataSetValueException idsvex) {
            throw idsvex;
        }
        catch (RuntimeException rex) {
            throw new DataSetValueForKeyNotFoundException(tag, key, (Throwable)rex);
        }
        return returnObject;
    }

    public static Object convertValue(Object value, DataType targetType) {
        Object ret = value;
        try {
            switch (targetType) {
                case BCDSTRING: {
                    ret = DefaultDataSet.convertToBcdString(value);
                    break;
                }
                case BOOLEAN: {
                    ret = DefaultDataSet.convertToBoolean(value);
                    break;
                }
                case DATE: {
                    ret = DefaultDataSet.convertToEREDate(value);
                    break;
                }
                case DECIMAL: {
                    ret = DefaultDataSet.convertToDecimal(value);
                    break;
                }
                case DOUBLE: {
                    ret = DefaultDataSet.convertToDouble(value);
                    break;
                }
                case INTEGER: 
                case UNSIGNEDINT: {
                    ret = DefaultDataSet.convertToInteger(value);
                    break;
                }
                case LONG: 
                case UNSIGNEDLONG: {
                    ret = DefaultDataSet.convertToLong(value);
                    break;
                }
                case MONETARYUNITS: {
                    ret = DefaultDataSet.convertToMonetaryUnits(value);
                    break;
                }
                case OCTETSTRING: {
                    ret = DefaultDataSet.convertToOctetString(value);
                    break;
                }
                case RATINGDECIMAL: {
                    ret = DefaultDataSet.convertToRatingDecimal(value);
                    break;
                }
                case SHORT: 
                case UNSIGNEDSHORT: {
                    ret = DefaultDataSet.convertToShort(value);
                    break;
                }
                case STRING: {
                    ret = value.toString();
                    break;
                }
                case TIME: {
                    ret = DefaultDataSet.convertToERETime(value);
                    break;
                }
                case UNSIGNEDINT16: {
                    ret = DefaultDataSet.convertToUnsignedInt16(value);
                    break;
                }
                case UNSIGNEDINT32: {
                    ret = DefaultDataSet.convertToUnsignedInt32(value);
                    break;
                }
                case UNSIGNEDINT8: {
                    ret = DefaultDataSet.convertToUnsignedInt8(value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    protected Object convertToDataType(Object value, DataType dt) {
        return DefaultDataSet.convertValue(value, dt);
    }

    private static RatingDecimal convertToRatingDecimal(Object value) {
        return RatingDecimalUtil.createRatingDecimalFromNumericValue(value);
    }

    private static UnsignedInt8 convertToUnsignedInt8(Object obj) {
        UnsignedInt8 ret = obj instanceof UnsignedInt8 ? (UnsignedInt8)obj : new UnsignedInt8(obj.toString());
        return ret;
    }

    private static UnsignedInt32 convertToUnsignedInt32(Object obj) {
        UnsignedInt32 ret = obj instanceof UnsignedInt32 ? (UnsignedInt32)obj : new UnsignedInt32(obj.toString());
        return ret;
    }

    private static UnsignedInt16 convertToUnsignedInt16(Object obj) {
        UnsignedInt16 ret = obj instanceof UnsignedInt16 ? (UnsignedInt16)obj : new UnsignedInt16(obj.toString());
        return ret;
    }

    private static short convertToShort(Object obj) {
        short ret = obj instanceof Number ? ((Number)obj).shortValue() : Short.parseShort(obj.toString());
        return ret;
    }

    private static OctetString convertToOctetString(Object obj) {
        OctetString ret = obj instanceof OctetString ? (OctetString)obj : new OctetString(obj.toString());
        return ret;
    }

    private static MonetaryUnits convertToMonetaryUnits(Object obj) {
        MonetaryUnits ret = obj instanceof MonetaryUnits ? (MonetaryUnits)obj : new MonetaryUnits(obj.toString());
        return ret;
    }

    private static long convertToLong(Object obj) {
        long ret = obj instanceof Number ? ((Number)obj).longValue() : Long.parseLong(obj.toString());
        return ret;
    }

    private static int convertToInteger(Object obj) {
        int ret = obj instanceof Number ? ((Number)obj).intValue() : Integer.parseInt(obj.toString());
        return ret;
    }

    private static double convertToDouble(Object obj) {
        double ret = obj instanceof Number ? ((Number)obj).doubleValue() : Double.parseDouble(obj.toString());
        return ret;
    }

    private static Decimal convertToDecimal(Object obj) {
        Decimal ret = obj instanceof Decimal ? (Decimal)obj : new Decimal(obj.toString());
        return ret;
    }

    private static boolean convertToBoolean(Object obj) {
        boolean ret = obj instanceof Boolean ? (Boolean)obj : Boolean.parseBoolean(obj.toString());
        return ret;
    }

    private static BcdString convertToBcdString(Object obj) {
        BcdString ret = obj instanceof BcdString ? (BcdString)obj : new BcdString(obj.toString());
        return ret;
    }

    private void checkForNullKey(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("The key cannot be null");
        }
    }

    public Map getDataAsMap(int tag, DataType valueDataType) {
        Object dataObject = this.getDataAsObject(tag);
        return this.handleGetAsMap(tag, dataObject);
    }

    public Map getDataAsMap(Object name, DataType valueDataType) {
        Object dataObject = this.getDataAsObject(name);
        return this.handleGetAsMap(name, dataObject);
    }

    private Map handleGetAsMap(Object key, Object dataObject) {
        if (dataObject instanceof Map) {
            return (Map)dataObject;
        }
        if (DataSetArrayHelper.isOneDimensionalArray(dataObject)) {
            return DataSetArrayHelper.convertArrayToMap(dataObject);
        }
        return Collections.singletonMap(key, dataObject);
    }

    @Override
    public void setDataAsObjectForKey(int tag, Key key, Object value) {
        this.checkForNullKey(key);
        Object dataObject = this.hasData(tag) ? this.getDataAsObject(tag) : null;
        Object toPut = this.handleSetDataForKey(dataObject, key, value);
        if (dataObject == null || dataObject != toPut) {
            this.setDataAsObject(tag, toPut);
        }
    }

    @Override
    public void setDataAsObjectForKey(Object name, Key key, Object value) {
        this.checkForNullKey(key);
        Object dataObject = this.hasData(name) ? this.getDataAsObject(name) : null;
        Object toPut = this.handleSetDataForKey(dataObject, key, value);
        if (dataObject == null || dataObject != toPut) {
            this.setDataAsObject(name, toPut);
        }
    }

    private Object handleSetDataForKey(Object dataObject, Key key, Object value) {
        Object toPut = dataObject;
        if (dataObject == null || dataObject instanceof Map) {
            AbstractMap map;
            if (dataObject == null) {
                map = key.containsIndex() ? new TreeMap() : new HashMap();
            } else {
                map = (TreeMap)dataObject;
                if (map instanceof TreeMap && key.containsKey()) {
                    throw new IncompatibleDataSetValueException("Must use an index for array data.");
                }
            }
            map.put(this.getKeyObject(key), value);
            toPut = map;
        } else if (DataSetArrayHelper.isOneDimensionalArray(dataObject)) {
            if (!key.containsIndex()) {
                throw new IncompatibleDataSetValueException("Must use an index for array data.");
            }
            int index = key.getIndex();
            DataSetArrayHelper.setElementAtIndex(dataObject, index, value);
        } else {
            throw new IncompatibleDataSetValueException("Cannot set data, unsupported data object type: " + dataObject.getClass());
        }
        return toPut;
    }

    private Object handleGetDataForKey(Object dataObject, Key key) {
        Object result;
        if (dataObject instanceof Map) {
            Map map = (Map)dataObject;
            Object keyObject = this.getKeyObject(key);
            if (!map.containsKey(keyObject)) {
                throw new ArrayIndexOutOfBoundsException("Key/index not found in map: " + keyObject);
            }
            result = map.get(keyObject);
        } else if (DataSetArrayHelper.isOneDimensionalArray(dataObject)) {
            if (!key.containsIndex()) {
                throw new IncompatibleDataSetValueException("Must use an index for array data.");
            }
            int index = key.getIndex();
            result = DataSetArrayHelper.getElementAtIndex(dataObject, index);
        } else {
            throw new IncompatibleDataSetValueException("Cannot get data, unsupported data object type: " + dataObject.getClass());
        }
        return result;
    }

    private Object getKeyObject(Key k) {
        return k.containsIndex() ? Integer.valueOf(k.getIndex()) : k.getKey();
    }

    @Override
    public void clearDataForKey(int tag, Key key) {
        if (key.containsIndex()) {
            throw new IllegalArgumentException("Array data is not supported for clearing.");
        }
        Object value = this.myValues.get(tag);
        if (!(value instanceof Map)) {
            throw new IncompatibleDataSetValueException("Cannot clear data, unsupported data object type: " + value.getClass());
        }
        Map map = (Map)value;
        map.remove(key.getKey());
    }

    @Override
    public void clearDataForKey(Object name, Key key) {
        if (key.containsIndex()) {
            throw new IllegalArgumentException("Array data is not supported for clearing.");
        }
        Object value = this.myValues.get(name);
        if (value instanceof Map) {
            Map map = (Map)value;
            map.remove(key.getKey());
        } else if (value != null) {
            throw new IncompatibleDataSetValueException("Cannot clear data, unsupported data object type: " + value.getClass());
        }
    }

    @Override
    public void clearData(int tag) {
        this.myValues.remove(tag);
    }

    @Override
    public void clearData(Object name) {
        this.myValues.remove(name);
    }

    @Override
    public EREDate getDataAsEREDate(Object name) {
        Object obj = this.getDataAsObject(name);
        return DefaultDataSet.convertToEREDate(obj);
    }

    @Override
    public EREDate getDataAsEREDate(int tag) {
        Object obj = this.getDataAsObject(tag);
        return DefaultDataSet.convertToEREDate(obj);
    }

    @Override
    public ERETime getDataAsERETime(Object name) {
        Object obj = this.getDataAsObject(name);
        return DefaultDataSet.convertToERETime(obj);
    }

    @Override
    public ERETime getDataAsERETime(int tag) {
        Object obj = this.getDataAsObject(tag);
        return DefaultDataSet.convertToERETime(obj);
    }

    private static EREDate convertToEREDate(Object obj) {
        try {
            return EREDateUtil.convertToEREDate(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IncompatibleDataSetValueException("Value cannot be converted to EREDate: " + obj.getClass());
        }
    }

    private static ERETime convertToERETime(Object obj) {
        try {
            return ERETimeUtil.convertToERETime(obj);
        }
        catch (IllegalArgumentException e) {
            throw new IncompatibleDataSetValueException("Value cannot be converted to ERETime: " + obj.getClass());
        }
    }

    @Override
    public void setDataAsEREDate(Object name, EREDate date) {
        this.setDataAsObject(name, (Object)date);
    }

    @Override
    public void setDataAsEREDate(int tag, EREDate date) {
        this.setDataAsObject(tag, (Object)date);
    }

    @Override
    public void setDataAsERETime(Object name, ERETime time) {
        this.setDataAsObject(name, (Object)time);
    }

    @Override
    public void setDataAsERETime(int tag, ERETime time) {
        this.setDataAsObject(tag, (Object)time);
    }

    @Override
    public Set<?> getDataAsSet(int tag, DataType desiredDataType) {
        Object obj = this.getDataAsObject(tag);
        if (!(obj instanceof Set)) {
            throw new IncompatibleDataSetValueException("Value is not a set: " + obj.getClass());
        }
        return (Set)obj;
    }

    @Override
    public Set<?> getDataAsSet(Object name, DataType desiredDataType) {
        Object obj = this.getDataAsObject(name);
        if (!(obj instanceof Set)) {
            throw new IncompatibleDataSetValueException("Value is not a set: " + obj.getClass());
        }
        return (Set)obj;
    }

    @Override
    public void setDataAsSet(int tag, Set<?> value) {
        this.setDataAsObject(tag, (Object)value);
    }

    @Override
    public void setDataAsSet(Object name, Set<?> value) {
        this.setDataAsObject(name, value);
    }
}

