/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset;

import com.ericsson.ere.dataset.AbstractDataSet;
import com.ericsson.ere.dataset.ComplexKey;
import com.ericsson.ere.dataset.DataSetAccessor;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueForKeyNotFoundException;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.DefaultDataSet;
import com.ericsson.ere.dataset.DefaultValueContainer;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.dataset.ValueContainer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.interfaces.FieldHierarchyNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultDataSetAccessor
implements DataSetAccessor {
    protected AbstractDataSet myDataSet;
    private ValueContainer myRoot;

    public DefaultDataSetAccessor(AbstractDataSet aSet) {
        this.myDataSet = aSet;
        this.myRoot = this.createContainer(aSet);
    }

    protected ValueContainer createContainer(AbstractDataSet dataSet) {
        DefaultValueContainer ret = dataSet != null ? new DefaultValueContainer(dataSet) : new DefaultValueContainer();
        return ret;
    }

    @Override
    public <T> T getValue(FieldHierarchyNode field, List<Key> keys, DataType type) {
        Object retVal;
        if (this.isOldStyleField(field)) {
            retVal = this.getOldStyleValue(field, keys, type);
        } else {
            List<Key> keyListCopy = this.copyKeyList(keys);
            this.checkSet(field);
            ValueContainer cont = this.locateContainerFor(field, keyListCopy, null, false);
            retVal = field.isLeaf() || !this.pointsToValueContainer(field, keys) ? cont.getData(field, type) : cont;
        }
        return retVal;
    }

    @Override
    public <T> void setValue(FieldHierarchyNode field, List<Key> keys, DataType type, T value) {
        Object convertedValue = value;
        DefaultDataSetAccessor.check(value != null, "Setting null values not allowed. If you intended to remove a value, use removeValue() instead.");
        if (type != null && field.isLeaf()) {
            convertedValue = DefaultDataSet.convertValue(value, type);
        }
        if (this.isOldStyleField(field)) {
            this.setOldStyleValue(field, keys, type, convertedValue);
        } else {
            List<Key> keyListCopy = this.copyKeyList(keys);
            this.checkSet(field);
            convertedValue = this.checkAndConvertValueAgainstTargetField(field, keyListCopy, convertedValue);
            ValueContainer cont = this.locateContainerFor(field, keyListCopy, convertedValue, true);
            if (cont != convertedValue) {
                cont.setData(field, convertedValue, type);
            }
        }
    }

    @Override
    public boolean hasValue(FieldHierarchyNode field, List<Key> keys) {
        boolean has = false;
        try {
            this.getValue(field, keys, null);
            has = true;
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return has;
    }

    @Override
    public <T> T removeValue(FieldHierarchyNode field, List<Key> keys, DataType type) {
        Object retVal = null;
        try {
            if (this.isOldStyleField(field)) {
                retVal = this.removeOldStyleValue(field, keys);
            } else {
                List<Key> keyListCopy = this.copyKeyList(keys);
                this.checkSet(field);
                if (!this.pointsToValueContainer(field, keys)) {
                    ValueContainer cont = this.locateContainerFor(field, keyListCopy, null, false);
                    retVal = cont.removeData(field, type);
                } else {
                    ValueContainer parentCont = field.getParent() != null ? this.locateContainerFor(field.getParent(), keyListCopy, null, false) : this.myRoot;
                    switch (field.getComplexType()) {
                        default: {
                            retVal = parentCont.removeData(field, null);
                            break;
                        }
                        case MAP: 
                        case ARRAY: {
                            Key key = keyListCopy.get(keyListCopy.size() - 1);
                            Map map = (Map)parentCont.getData(field, null);
                            retVal = map.remove(key);
                            break;
                        }
                        case SET: {
                            Key key2 = keyListCopy.get(keyListCopy.size() - 1);
                            Set set = (Set)parentCont.getData(field, null);
                            ValueContainer entry = this.keyToContainer(field, key2);
                            retVal = set.remove(entry) ? entry : null;
                        }
                    }
                }
            }
        }
        catch (DataSetValueNotFoundException e) {
            retVal = null;
        }
        return (T)retVal;
    }

    @Override
    public ValueContainer entryOf(FieldStructure parent, Object[] values) {
        List<FieldHierarchyNode> children;
        ValueContainer cont = this.createContainer(null);
        List<FieldHierarchyNode> valueChildren = children = parent.getChildren();
        int numValues = children.size();
        if (parent.getComplexType() == FieldHierarchyNode.ComplexType.MAP) {
            valueChildren = new ArrayList<FieldHierarchyNode>();
            numValues = 0;
            for (FieldHierarchyNode child : children) {
                if (child.isKey()) continue;
                ++numValues;
                valueChildren.add(child);
            }
        }
        DefaultDataSetAccessor.check(numValues == values.length, "Number of value fields must match number of values");
        for (int i = 0; i < numValues; ++i) {
            FieldHierarchyNode child;
            child = valueChildren.get(i);
            if (values[i] == null) continue;
            cont.setData(child, values[i], null);
        }
        return cont;
    }

    private List<Key> copyKeyList(List<Key> original) {
        return original == null ? new ArrayList<Key>(0) : new ArrayList<Key>(original);
    }

    private <T> ValueContainer locateContainerFor(FieldHierarchyNode field, List<Key> keys, T value, boolean createIfNeeded) {
        ValueContainer parentCont = null;
        parentCont = field.getParent() != null ? this.locateContainerFor(field.getParent(), keys, null, createIfNeeded) : this.myRoot;
        return this.getOrCreateContainerForFieldIn(parentCont, field, keys, value, createIfNeeded);
    }

    private <T> ValueContainer getOrCreateContainerForFieldIn(ValueContainer parentCont, FieldHierarchyNode field, List<Key> keys, T value, boolean createIfNeeded) {
        ValueContainer cont;
        if (field.getComplexType() == FieldHierarchyNode.ComplexType.NONE) {
            if (field.isLeaf()) {
                cont = parentCont;
            } else {
                if (value instanceof ValueContainer) {
                    parentCont.setData(field, value, null);
                }
                if (!parentCont.hasData(field)) {
                    if (!createIfNeeded) {
                        throw new DataSetValueNotFoundException(field.getCanonicalName());
                    }
                    cont = this.createContainer(null);
                    parentCont.setData(field, cont, null);
                } else {
                    cont = (ValueContainer)parentCont.getData(field, null);
                }
            }
        } else {
            cont = !field.isLeaf() && !keys.isEmpty() ? this.getOrCreateContainerForEntryIn(parentCont, field, keys, value, createIfNeeded) : parentCont;
        }
        return cont;
    }

    private <T> ValueContainer getOrCreateContainerForEntryIn(ValueContainer parentCont, FieldHierarchyNode field, List<Key> keys, T value, boolean createIfNeeded) {
        ValueContainer cont = null;
        if (!parentCont.hasData(field) && !createIfNeeded) {
            throw new DataSetValueNotFoundException(field.getCanonicalName());
        }
        Key key = keys.remove(0);
        switch (field.getComplexType()) {
            case MAP: 
            case ARRAY: {
                cont = this.getOrCreateContainerForEntryInMapOrArray(parentCont, field, value, createIfNeeded, key);
                break;
            }
            case SET: {
                cont = this.getOrCreateContainerForEntryInSet(parentCont, field, value, createIfNeeded, key);
                break;
            }
            default: {
                throw new AssertionError((Object)"Should never get here.");
            }
        }
        return cont;
    }

    private <T> ValueContainer getOrCreateContainerForEntryInSet(ValueContainer parentCont, FieldHierarchyNode field, T value, boolean createIfNeeded, Key key) {
        Set<ValueContainer> set;
        if (parentCont.hasData(field)) {
            set = (Set)parentCont.getData(field, null);
        } else {
            set = new HashSet();
            parentCont.setData(field, set, null);
        }
        ValueContainer cont = this.keyToContainer(field, key);
        if (value != null) {
            DefaultDataSetAccessor.check(cont.equals(value), "Key does not match value when accessing entry for field " + field.getCanonicalName() + ".");
            cont = (ValueContainer)value;
        }
        if (!set.contains(cont)) {
            if (!createIfNeeded) {
                throw new DataSetValueForKeyNotFoundException(field.getCanonicalName(), key);
            }
            set.add(cont);
        }
        return cont;
    }

    private <T> ValueContainer getOrCreateContainerForEntryInMapOrArray(ValueContainer parentCont, FieldHierarchyNode field, T value, boolean createIfNeeded, Key key) {
        ValueContainer cont;
        Map<Key, ValueContainer> map;
        if (parentCont.hasData(field)) {
            map = (Map)parentCont.getData(field, null);
        } else {
            map = new HashMap();
            parentCont.setData(field, map, null);
        }
        if (value != null) {
            map.put(key, (ValueContainer)value);
        }
        if ((cont = (ValueContainer)map.get(key)) == null) {
            if (!createIfNeeded) {
                throw new DataSetValueForKeyNotFoundException(field.getCanonicalName(), key);
            }
            cont = this.createContainer(null);
            map.put(key, cont);
        }
        return cont;
    }

    private boolean pointsToValueContainer(FieldHierarchyNode field, List<Key> keys) {
        boolean result = false;
        if (!field.isLeaf()) {
            int keysSupplied;
            int keysNeeded = 0;
            int n = keysSupplied = keys == null ? 0 : keys.size();
            for (FieldHierarchyNode current = field; current != null; current = current.getParent()) {
                if (current.getComplexType() == FieldHierarchyNode.ComplexType.NONE) continue;
                ++keysNeeded;
            }
            result = keysNeeded == keysSupplied;
        }
        return result;
    }

    private <T> T getOldStyleValue(FieldHierarchyNode field, List<Key> keys, DataType type) {
        DataSetField dsf = new DataSetField((FieldDefinition)field, type);
        Object retVal = keys != null && keys.size() > 0 ? dsf.getValueFromDataSet(this.myDataSet, keys.get(0)) : dsf.getValueFromDataSet(this.myDataSet);
        return (T)retVal;
    }

    private <T> void setOldStyleValue(FieldHierarchyNode field, List<Key> keys, DataType type, T value) {
        DataSetField dsf = new DataSetField((FieldDefinition)field, type);
        if (keys != null && keys.size() > 0) {
            dsf.setValueInDataSet(this.myDataSet, keys.get(0), value);
        } else {
            dsf.setValueInDataSet(this.myDataSet, value);
        }
    }

    private boolean isOldStyleField(FieldHierarchyNode field) {
        return field.isLeaf() && field.getParent() == null;
    }

    private void checkSet(FieldHierarchyNode field) {
        DefaultDataSetAccessor.check(field.getParent() == null || field.getParent().getComplexType() != FieldHierarchyNode.ComplexType.SET, "Cannot access single values within a SET.");
    }

    private Object checkAndConvertValueAgainstTargetField(FieldHierarchyNode field, List<Key> keys, Object value) {
        HashMap<Key, ValueContainer> retVal = value;
        if (field.isLeaf()) {
            switch (field.getComplexType()) {
                case MAP: {
                    DefaultDataSetAccessor.check(value instanceof Map, "Target field is a Map, but the supplied value is not a map.");
                    break;
                }
                case SET: {
                    DefaultDataSetAccessor.check(value instanceof Set, "Target field is a Set, but the supplied value is not a set.");
                    break;
                }
                case ARRAY: {
                    DefaultDataSetAccessor.check(value.getClass().isArray(), "Target field is an Array, but the supplied value is not an array.");
                    break;
                }
            }
        } else {
            switch (field.getComplexType()) {
                case MAP: {
                    if (this.pointsToValueContainer(field, keys)) {
                        DefaultDataSetAccessor.check(value instanceof ValueContainer, "Target field is an indexed entry in a Map collection, but the supplied value is not a ValueContainer.");
                        break;
                    }
                    DefaultDataSetAccessor.check(value instanceof Map, "Target field is a Map, but the supplied value is not a Map");
                    break;
                }
                case ARRAY: {
                    if (this.pointsToValueContainer(field, keys)) {
                        DefaultDataSetAccessor.check(value instanceof ValueContainer, "Target field is an indexed entry in an Array collection, but the supplied value is not a ValueContainer.");
                        break;
                    }
                    if (value instanceof Map) break;
                    DefaultDataSetAccessor.check(value instanceof ValueContainer[], "Target field is a Map, but the supplied value is neither a Map nor an array of ValueContainers");
                    ValueContainer[] arr = (ValueContainer[])value;
                    HashMap<Key, ValueContainer> map = new HashMap<Key, ValueContainer>();
                    for (int i = 0; i < arr.length; ++i) {
                        map.put(Key.asIndex(i), arr[i]);
                    }
                    retVal = map;
                    break;
                }
                case SET: {
                    if (this.pointsToValueContainer(field, keys)) {
                        DefaultDataSetAccessor.check(value instanceof ValueContainer, "Target field is an indexed entry in a Set collection, but the supplied value is not a ValueContainer.");
                        break;
                    }
                    DefaultDataSetAccessor.check(value instanceof Set, "Target field is a Set, but the supplied value is not a Set.");
                    break;
                }
                default: {
                    DefaultDataSetAccessor.check(field.isLeaf() || value instanceof ValueContainer, "Target field is a struct, but the supplied value is not a ValueContainer.");
                }
            }
        }
        return retVal;
    }

    private <T> T removeOldStyleValue(FieldHierarchyNode field, List<Key> keys) {
        Object retVal;
        int tag = field.getTagNumber();
        boolean useTag = tag > -1;
        AbstractDataSet set = this.myDataSet;
        if (useTag) {
            if (keys != null) {
                retVal = set.getDataAsTypedObjectForKey(tag, keys.get(0), (DataType)null);
                set.clearDataForKey(tag, keys.get(0));
            } else {
                retVal = set.getDataAsObject(tag);
                set.clearData(tag);
            }
        } else if (keys != null) {
            retVal = set.getDataAsTypedObjectForKey(field.getCanonicalName(), keys.get(0), null);
            set.clearDataForKey(field.getCanonicalName(), keys.get(0));
        } else {
            retVal = set.getDataAsObject(field.getCanonicalName());
            set.clearData(field.getCanonicalName());
        }
        return (T)retVal;
    }

    private static void check(boolean condition, String exceptionStringIfFalse) {
        if (!condition) {
            throw new IllegalArgumentException(exceptionStringIfFalse);
        }
    }

    public ValueContainer keyToContainer(FieldHierarchyNode field, Key key) {
        ValueContainer cont = this.createContainer(null);
        DefaultDataSetAccessor.check(field != null, "Field cannot be null.");
        List<FieldHierarchyNode> children = field.getChildren();
        int numChildren = children.size();
        DefaultDataSetAccessor.check(field.getComplexType() == FieldHierarchyNode.ComplexType.SET, "Field " + field.getCanonicalName() + " must be a set.");
        DefaultDataSetAccessor.check(key != null, "Key cannot be null.");
        int numKeys = key.getKey() instanceof ComplexKey ? ((ComplexKey)key.getKey()).getKeyLength() : 1;
        DefaultDataSetAccessor.check(numKeys == numChildren, "Invalid number of keys given for accessing " + field.getCanonicalName() + ", expected " + numChildren + " keys but got " + numKeys + ".");
        if (numChildren > 1) {
            ComplexKey complexKey = (ComplexKey)key.getKey();
            for (int i = 0; i < numChildren; ++i) {
                cont.setData(children.get(i), complexKey.getKeyObjectForIndex(i), null);
            }
        } else {
            cont.setData(field.getChildren().get(0), key.getKey(), null);
        }
        return cont;
    }
}

