/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.dataset.task;

import com.ericsson.ere.dataset.task.AbstractTreeTask;
import com.ericsson.ere.dataset.task.TimeBasedTask;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import java.util.Stack;

public abstract class AbstractTimeBasedTreeTask
extends AbstractTreeTask
implements TimeBasedTask {
    protected final long myTotalDuration;
    protected long myAllocatedDuration;
    protected long myRemainingDuration;
    protected long myDurationToTimeSwitch;
    protected long myAccumulatedDuration;
    protected Stack<State> myStates = new Stack();

    protected AbstractTimeBasedTreeTask(long duration) {
        this.myTotalDuration = duration;
        this.myRemainingDuration = duration;
        this.myDurationToTimeSwitch = -1L;
        this.myAllocatedDuration = 0L;
        this.myAccumulatedDuration = 0L;
    }

    @Override
    public boolean isModified() {
        if (this.myStates.isEmpty()) {
            throw new TreeExecutionException("No previous tree task state exists, which makes modification check impossible.");
        }
        State previousState = this.myStates.pop();
        return previousState.myAllocatedDurationState != this.myAllocatedDuration;
    }

    @Override
    public void resetModified() {
        this.myStates.push(new State(this.myAllocatedDuration, this.myDurationToTimeSwitch, true));
    }

    @Override
    public void saveState() {
    }

    @Override
    public void restoreState() {
    }

    @Override
    public boolean isDone() {
        return this.myAllocatedDuration >= this.myTotalDuration;
    }

    @Override
    public long getRemainingDuration() {
        return this.myRemainingDuration;
    }

    @Override
    public void setDurationToNextTimeSwitch(long duration) {
        this.myDurationToTimeSwitch = this.myDurationToTimeSwitch < 0L ? duration : Math.min(duration, this.myDurationToTimeSwitch);
    }

    @Override
    public long getTotalDuration() {
        return this.myTotalDuration;
    }

    @Override
    public long getAllocatedDuration() {
        return this.myAllocatedDuration;
    }

    @Override
    public long getCurrentDuration() {
        return this.myAllocatedDuration + this.myAccumulatedDuration;
    }

    @Override
    public void setMaxAllocatableDuration(long units) {
        long newMaxUnits = units - this.myAllocatedDuration;
        if (newMaxUnits > 0L) {
            this.myRemainingDuration = Math.min(this.myRemainingDuration, newMaxUnits);
        }
    }

    public void setAccumulatedDuration(long accumulated) {
        this.myAccumulatedDuration = accumulated;
    }

    @Override
    public abstract long allocateTime(long var1);

    protected static class State {
        protected final long myAllocatedDurationState;
        protected long myDurationToTimeSwitchState;
        protected final boolean myIsModificationCheckState;

        protected State(long allocatedDuration, long timeSwitch, boolean modificationCheckState) {
            this.myAllocatedDurationState = allocatedDuration;
            this.myDurationToTimeSwitchState = timeSwitch;
            this.myIsModificationCheckState = modificationCheckState;
        }
    }
}

