/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.ere.dataset.OperationNotApplicableException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

abstract class EREDateConstants
implements ERETime,
Serializable {
    private static EREDateConstants myBeginningOfTime = null;
    private static EREDateConstants myEndOfTime = null;

    EREDateConstants() {
    }

    static synchronized EREDateConstants createBeginningOfTime() {
        if (myBeginningOfTime == null) {
            myBeginningOfTime = new BeginningOfTime();
        }
        return myBeginningOfTime;
    }

    static synchronized EREDateConstants createEndOfTime() {
        if (myEndOfTime == null) {
            myEndOfTime = new EndOfTime();
        }
        return myEndOfTime;
    }

    @Override
    public Calendar asCalendar() {
        throw new UnsupportedOperationException("The EREDate boundary date constants does not support Calendar format.");
    }

    @Override
    public Date asDate() {
        throw new UnsupportedOperationException("The EREDate boundary date constants does not support Date format.");
    }

    @Override
    public int daysUntil(EREDate other) {
        throw new OperationNotApplicableException("EREDateConstants does not support the daysUntil method.");
    }

    @Override
    public int getDayOfMonth() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getDayOfMonth method.");
    }

    @Override
    public EREDate.WeekDay getDayOfWeek() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getDayOfWeek method.");
    }

    @Override
    public int getDaysSince19700101() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getDaysSince19700101 method.");
    }

    @Override
    public int getFullYear() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getFullYear method.");
    }

    @Override
    public int getMonthOfYear() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getMonthOfYear method.");
    }

    @Override
    public EREDate plusDays(int days) {
        return this;
    }

    @Override
    public EREDate plusMonths(int months) {
        return this;
    }

    @Override
    public EREDate plusYears(int years) {
        return this;
    }

    @Override
    public int getHours() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getHours method.");
    }

    @Override
    public ERETime plusHours(int hours) {
        return this;
    }

    @Override
    public int getMinutes() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getMinutes method.");
    }

    @Override
    public ERETime plusMinutes(int minutes) {
        return this;
    }

    @Override
    public int getSeconds() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getSeconds method.");
    }

    @Override
    public ERETime plusSeconds(int seconds) {
        return this;
    }

    @Override
    public int getMilliseconds() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getMilliseconds method.");
    }

    @Override
    public ERETime plusMilliseconds(int milliseconds) {
        return this;
    }

    @Override
    public long getMillisecondsSinceEpoch() {
        throw new OperationNotApplicableException("EREDateConstants does not support the getMillisecondsSinceEpoch method.");
    }

    private static class EndOfTime
    extends EREDateConstants {
        private final String END_OF_TIME = "EOT";

        private EndOfTime() {
        }

        @Override
        public int compareTo(EREDate other) {
            return this == other ? 0 : 1;
        }

        @Override
        public int compareTo(ERETime other) {
            return this == other ? 0 : 1;
        }

        @Override
        public int compareTo(Calendar other) {
            return 1;
        }

        @Override
        public int compareTo(Date other) {
            return 1;
        }

        @Override
        public boolean isAfter(EREDate other) {
            return this != other;
        }

        @Override
        public boolean isBefore(EREDate other) {
            return false;
        }

        public String toString() {
            return "EOT";
        }
    }

    private static class BeginningOfTime
    extends EREDateConstants {
        private final String BEGINNING_OF_TIME = "BOT";

        private BeginningOfTime() {
        }

        @Override
        public int compareTo(EREDate other) {
            return this == other ? 0 : -1;
        }

        @Override
        public int compareTo(ERETime other) {
            return this == other ? 0 : -1;
        }

        @Override
        public int compareTo(Calendar other) {
            return -1;
        }

        @Override
        public int compareTo(Date other) {
            return -1;
        }

        @Override
        public boolean isAfter(EREDate other) {
            return false;
        }

        @Override
        public boolean isBefore(EREDate other) {
            return this != other;
        }

        public String toString() {
            return "BOT";
        }
    }
}

