/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.ere.datatype.CalendarDateBasedEREDate;
import com.ericsson.ere.datatype.DefaultEREDate;
import com.ericsson.ere.datatype.EREDate;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class EREDateFactory {
    private static Pattern DATE_PATTERN = Pattern.compile("(\\d{4})-?(\\d{2})-?(\\d{2})(T\\d{9})?");
    private static EREDateFactory myFactory = new DefaultEREDateFactory();

    protected abstract EREDate _today();

    protected abstract EREDate _createFromYearMonthDay(int var1, int var2, int var3);

    protected abstract EREDate _createFromDaysSinceEpoch(int var1);

    protected EREDate _createFromCalendar(Calendar cal) {
        return this._createFromYearMonthDay(cal.get(1), 1 + cal.get(2), cal.get(5));
    }

    protected EREDate _createFromDate(Date date) {
        return this._createFromYearMonthDay(1900 + date.getYear(), 1 + date.getMonth(), date.getDate());
    }

    protected EREDate _copyIfNecessary(EREDate date) {
        return this._createFromYearMonthDay(date.getFullYear(), date.getMonthOfYear(), date.getDayOfMonth());
    }

    public static EREDate today() {
        return myFactory._today();
    }

    public static EREDate createFromYearMonthDay(int year, int month, int day) {
        return myFactory._createFromYearMonthDay(year, month, day);
    }

    public static EREDate createFromCalendar(Calendar cal) {
        return myFactory._createFromCalendar(cal);
    }

    public static EREDate createFromDate(Date date) {
        return myFactory._createFromDate(date);
    }

    public static EREDate copyIfNecessary(EREDate date) {
        return myFactory._copyIfNecessary(date);
    }

    public static EREDate createFromDaysSinceEpoch(int days) {
        return myFactory._createFromDaysSinceEpoch(days);
    }

    public static EREDate parseDateString(String dateString) {
        EREDate generatedDate;
        Matcher m = DATE_PATTERN.matcher(dateString);
        if (m.matches()) {
            int year = Integer.parseInt(m.group(1));
            int month = Integer.parseInt(m.group(2));
            int day = Integer.parseInt(m.group(3));
            generatedDate = EREDateFactory.createFromYearMonthDay(year, month, day);
        } else if (EREDate.BEGINNING_OF_TIME.toString().equals(dateString)) {
            generatedDate = EREDate.BEGINNING_OF_TIME;
        } else if (EREDate.END_OF_TIME.toString().equals(dateString)) {
            generatedDate = EREDate.END_OF_TIME;
        } else {
            throw new IllegalArgumentException("Unparseable date string, must be YYYY-MM-DD, YYYYMMDD, YYYYMMDD'T'000000000, or a boundary date constant: " + dateString);
        }
        return generatedDate;
    }

    public static synchronized void install(EREDateFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Factory must be non-null.");
        }
        myFactory = factory;
    }

    public static class CalendarDateBasedEREDateFactory
    extends EREDateFactory {
        @Override
        protected EREDate _today() {
            return CalendarDateBasedEREDate.today();
        }

        @Override
        protected EREDate _createFromYearMonthDay(int year, int month, int day) {
            return CalendarDateBasedEREDate.forDate(year, month, day);
        }

        @Override
        protected EREDate _copyIfNecessary(EREDate date) {
            if (date instanceof CalendarDateBasedEREDate) {
                return date;
            }
            return super._copyIfNecessary(date);
        }

        @Override
        protected EREDate _createFromDaysSinceEpoch(int days) {
            return CalendarDateBasedEREDate.forDaysSinceEpoch(days);
        }
    }

    public static class DefaultEREDateFactory
    extends EREDateFactory {
        @Override
        protected EREDate _today() {
            return DefaultEREDate.today();
        }

        @Override
        protected EREDate _createFromYearMonthDay(int year, int month, int day) {
            return DefaultEREDate.forDate(year, month, day);
        }

        @Override
        protected EREDate _createFromDaysSinceEpoch(int days) {
            return DefaultEREDate.forDaysSinceEpoch(days);
        }
    }
}

