/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.calendar.CalendarDate;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.ERETime;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.FieldDefinition;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public final class EREDateUtil {
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getDefault();
    public static final long MSECS_PER_DAY = 86400000L;
    public static final String END_OF_TIME_TAG = "EndOfTimeLabel";
    public static final String BEGINNING_OF_TIME_TAG = "BeginningOfTimeLabel";

    private EREDateUtil() {
    }

    public static EREDate convertToEREDate(Object dateValue) {
        if (dateValue == null) {
            return null;
        }
        if (dateValue instanceof ERETime) {
            if (EREDateUtil.isBoundaryDate(dateValue)) {
                return (EREDate)dateValue;
            }
            return EREDateFactory.createFromDate(((ERETime)dateValue).asDate());
        }
        if (dateValue instanceof EREDate) {
            return (EREDate)dateValue;
        }
        if (dateValue instanceof Date) {
            return EREDateFactory.createFromDate((Date)dateValue);
        }
        if (dateValue instanceof Calendar) {
            return EREDateFactory.createFromCalendar((Calendar)dateValue);
        }
        if (dateValue instanceof CalendarDate) {
            CalendarDate cd = (CalendarDate)dateValue;
            return EREDateFactory.createFromYearMonthDay(cd.getYear(), cd.getMonth(), cd.getDayOfMonth());
        }
        if (dateValue instanceof Time) {
            return EREDateFactory.createFromCalendar(((Time)dateValue).getCalendar());
        }
        throw new IllegalArgumentException("Unrecognized value class: " + dateValue.getClass());
    }

    public static EREDate getDataAsEREDate(DataSet ds, Object name, Key key) {
        return key == null ? ds.getDataAsEREDate(name) : EREDateUtil.convertToEREDate(ds.getDataAsTypedObjectForKey(name, key, DataType.DATE));
    }

    public static EREDate getDataAsEREDate(DataSet ds, int tag, Key key) {
        return key == null ? ds.getDataAsEREDate(tag) : EREDateUtil.convertToEREDate(ds.getDataAsTypedObjectForKey(tag, key, DataType.DATE));
    }

    public static long getDaysSinceEpoch(DataSet ds, Object name, Key key) {
        return key == null ? ds.getDataAsDaysSinceEpoch(name) : (long)EREDateUtil.getDataAsEREDate(ds, name, key).getDaysSince19700101();
    }

    public static long getDaysSinceEpoch(DataSet ds, int tag, Key key) {
        return key == null ? ds.getDataAsDaysSinceEpoch(tag) : (long)EREDateUtil.getDataAsEREDate(ds, tag, key).getDaysSince19700101();
    }

    public static int convertLocalMillisSinceEpochToDays(long utc) {
        long local = utc + (long)DEFAULT_TIMEZONE.getOffset(utc);
        int days = (int)(local / 86400000L);
        return days;
    }

    @Deprecated
    public static long convertDaysSinceEpochToLocalMillis(int days) {
        long utc = (long)days * 86400000L;
        return EREDateUtil.getWholeDayTimeInMillis(utc, DEFAULT_TIMEZONE);
    }

    public static boolean isBoundaryDate(Object obj) {
        return obj == EREDate.BEGINNING_OF_TIME || obj == EREDate.END_OF_TIME;
    }

    public static boolean isBoundaryDateDefaultLabel(String label) {
        return EREDate.BEGINNING_OF_TIME.toString().equals(label) || EREDate.END_OF_TIME.toString().equals(label);
    }

    public static String getDisplayableStringForBoundaryDateValue(Object valueObject, FieldDefinition fd) {
        String result = "";
        if (fd != null) {
            if (EREDate.BEGINNING_OF_TIME == valueObject || EREDate.BEGINNING_OF_TIME.toString().equals(valueObject)) {
                result = fd.getFieldSettings().get(BEGINNING_OF_TIME_TAG);
            } else if (EREDate.END_OF_TIME == valueObject || EREDate.END_OF_TIME.toString().equals(valueObject)) {
                result = fd.getFieldSettings().get(END_OF_TIME_TAG);
            }
            result = result == null ? "" : result;
        }
        return result;
    }

    public static String getDisplayableStringForEREDateConstant(EREDate dateConstant, FieldDefinition fd) {
        String result = "";
        if (fd != null && EREDateUtil.isBoundaryDate(dateConstant)) {
            result = EREDateUtil.getEREDateConstantLabel(dateConstant, fd);
            result = result == null ? "" : result;
        }
        return result;
    }

    private static String getEREDateConstantLabel(EREDate constant, FieldDefinition fd) {
        String tag;
        String result = "";
        if (EREDate.BEGINNING_OF_TIME == constant) {
            tag = BEGINNING_OF_TIME_TAG;
        } else if (EREDate.END_OF_TIME == constant) {
            tag = END_OF_TIME_TAG;
        } else {
            throw new IllegalArgumentException("Unsupported EREDate constant: " + constant);
        }
        result = fd.getFieldSettings().get(tag);
        return result == null ? constant.toString() : result;
    }

    public static EREDatesDiff calculateEREDateDifference(EREDate date1, EREDate date2) {
        if (date1 == null || date2 == null) {
            throw new IllegalArgumentException("The EREDate objects to compare may not be null.");
        }
        boolean isPositiveInfinity = date1 == EREDate.END_OF_TIME || date2 == EREDate.BEGINNING_OF_TIME;
        boolean isNegativeInfinity = date1 == EREDate.BEGINNING_OF_TIME || date2 == EREDate.END_OF_TIME;
        long diff = 0L;
        boolean hasDiff = false;
        if (date1 == date2 || date1.equals(date2)) {
            diff = 0L;
            hasDiff = true;
            isPositiveInfinity = false;
            isNegativeInfinity = false;
        } else if (!isNegativeInfinity && !isPositiveInfinity) {
            diff = date1.getDaysSince19700101() - date2.getDaysSince19700101();
            hasDiff = true;
        }
        return new EREDatesDiff(diff, hasDiff, isPositiveInfinity, isNegativeInfinity);
    }

    public static long getWholeDayTimeInMillis(long utc, TimeZone timeZone) {
        long time = utc;
        int offset = timeZone != null ? timeZone.getOffset(time - time % 86400000L) : 0;
        time += (long)offset;
        time -= time % 86400000L;
        return time -= (long)offset;
    }

    public static class EREDatesDiff {
        private final long myDiff;
        private final boolean myIsPositiveInfinity;
        private final boolean myIsNegativeInfinity;
        private final boolean myHasDiff;

        protected EREDatesDiff(long diff, boolean hasDiff, boolean isPositiveInfinity, boolean isNegativeInfinity) {
            this.myDiff = diff;
            this.myHasDiff = hasDiff;
            this.myIsPositiveInfinity = isPositiveInfinity;
            this.myIsNegativeInfinity = isNegativeInfinity;
        }

        public long getDifference() {
            return this.myDiff;
        }

        public boolean hasDifference() {
            return this.myHasDiff;
        }

        public boolean isPositiveInfinity() {
            return this.myIsPositiveInfinity;
        }

        public boolean isNegativeInfinity() {
            return this.myIsNegativeInfinity;
        }
    }
}

