/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.datatype;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.math.RatingDecimal;

@Immutable
public class MultiplierNumber
implements Comparable<MultiplierNumber> {
    private final RatingDecimal myValue;
    private final long myMultiplier;
    private final boolean myIsLong;

    public MultiplierNumber(RatingDecimal value, long multiplier) {
        this(value, multiplier, false);
    }

    public MultiplierNumber(long value, long multiplier) {
        this(new RatingDecimal(value, 1L), multiplier, true);
    }

    private MultiplierNumber(RatingDecimal value, long multiplier, boolean isLong) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.myValue = value;
        this.myMultiplier = multiplier;
        this.myIsLong = isLong;
    }

    public boolean hasFloatingPointValue() {
        return !this.myIsLong;
    }

    public RatingDecimal getValue() {
        return this.myValue;
    }

    public long getMultiplier() {
        return this.myMultiplier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.myMultiplier ^ this.myMultiplier >>> 32);
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiplierNumber other = (MultiplierNumber)obj;
        if (this.myMultiplier != other.myMultiplier) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    @Override
    public int compareTo(MultiplierNumber o) {
        RatingDecimal mine = this.myValue.divide(new RatingDecimal(this.myMultiplier, 1L));
        RatingDecimal other = o.myValue.divide(new RatingDecimal(o.myMultiplier, 1L));
        return mine.compareTo(other);
    }

    public String toString() {
        return String.format("%s/%d", this.valueToString(), this.myMultiplier);
    }

    private String valueToString() {
        return this.hasFloatingPointValue() ? this.myValue.toString() : Long.toString(this.myValue.longValue());
    }
}

