/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.dag.BaseDAGNode;
import com.ericsson.ere.defs.ServiceFieldStructureBuilder;
import com.ericsson.ere.defs.ServiceFieldStructureVisitor;
import com.ericsson.ere.defs.StructureBuilderException;
import com.ericsson.ere.interfaces.Acceptable;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.FieldHierarchyNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class ServiceFieldStructure {
    public static final String COMMON_FIELDS = "Common fields";
    private final Stack<StructureElement> myStack = new Stack();
    private final RootElement myRoot;

    ServiceFieldStructure(ClassRepository repository) {
        this.myRoot = new RootElement(repository);
        this.myStack.push(this.myRoot);
    }

    public static ServiceFieldStructure build(ClassRepository repository, boolean throwOnError) {
        return new ServiceFieldStructureBuilder(repository).throwOnError(throwOnError).build();
    }

    void leave() {
        if (this.myStack.isEmpty()) {
            throw new StructureBuilderException("Mismatch in enter/leave calls.");
        }
        this.myStack.pop();
    }

    void enterContext(String contextName, ClassRepository classRepository) {
        ContextElement context = new ContextElement(contextName, classRepository);
        this.enterParentElement(context);
    }

    void enterServiceProviderContext(String contextName, ClassRepository classRepository) {
        ServiceProviderContextElement context = new ServiceProviderContextElement(contextName, classRepository);
        this.enterParentElement(context);
    }

    void enterRatingPlanContext(String contextName, ClassRepository classRepository) {
        RatingPlanContextElement context = new RatingPlanContextElement(contextName, classRepository);
        this.enterParentElement(context);
    }

    void addField(FieldDefinition field, ClassRepository classRepository) {
        this.myStack.peek().addChild(new FieldElement(field.getFieldName(), classRepository));
    }

    void enterGroup(String groupName, ClassRepository classRepository) {
        GroupElement group = new GroupElement(groupName, classRepository);
        this.enterParentElement(group);
    }

    void addHierarchicalStructure(FieldHierarchyNode fieldHierarchyNode, ClassRepository classRepository) {
        if (fieldHierarchyNode.getComplexType() == FieldHierarchyNode.ComplexType.NONE) {
            this.myStack.peek().addChild(new HierarchicalStructureElement(fieldHierarchyNode, classRepository));
        } else {
            this.myStack.peek().addChild(new HierarchicalComplexStructureElement(fieldHierarchyNode, classRepository));
        }
    }

    void enterArrayGroup(String groupName, ClassRepository classRepository) {
        ArrayGroupElement group = new ArrayGroupElement(groupName, classRepository);
        this.enterParentElement(group);
    }

    void enterMapGroup(String groupName, String keyFields, ClassRepository classRepository) {
        MapGroupElement group = new MapGroupElement(groupName, keyFields, classRepository);
        this.enterParentElement(group);
    }

    void enterCommonFieldsRoot(ClassRepository classRepository) {
        CommonFieldsElement cfroot = new CommonFieldsElement(classRepository);
        this.enterParentElement(cfroot);
    }

    void enterParentElement(StructureElement parent) {
        this.myStack.peek().addChild(parent);
        this.myStack.push(parent);
    }

    public RootElement getRoot() {
        return this.myRoot;
    }

    public static StructureElement findElement(StructureElement start, String ... names) {
        StructureElement e;
        int idx = 0;
        for (e = start; e != null && idx < names.length; e = e.getNamedChild(names[idx++])) {
        }
        return e;
    }

    public class HierarchicalComplexStructureElement
    extends FieldGroupElement {
        private FieldHierarchyNode myField;

        HierarchicalComplexStructureElement(FieldHierarchyNode fieldHierarchyNode, ClassRepository repository) {
            super(fieldHierarchyNode.getFieldName(), repository);
            this.myField = fieldHierarchyNode;
            for (FieldHierarchyNode child : fieldHierarchyNode.getChildren()) {
                if (!child.isLeaf()) continue;
                this.addChild(new HierarchicalFieldElement((FieldDefinition)child, repository));
            }
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }

        public FieldHierarchyNode getFieldHierarcyNode() {
            return this.myField;
        }

        public List<FieldElement> getKeyFieldElements() {
            ArrayList<FieldElement> list = new ArrayList<FieldElement>();
            for (int i = 0; i < this.getChildCount(); ++i) {
                HierarchicalFieldElement hf;
                DAGNode child = this.getChildAt(i);
                if (!(child instanceof HierarchicalFieldElement) || !(hf = (HierarchicalFieldElement)child).getField().isKey()) continue;
                list.add(hf);
            }
            return list;
        }
    }

    public class HierarchicalStructureElement
    extends StructureElement {
        private FieldHierarchyNode myFieldStructure;

        HierarchicalStructureElement(FieldHierarchyNode fieldHierarchyNode, ClassRepository repository) {
            super(fieldHierarchyNode.getFieldName(), repository);
            this.myFieldStructure = fieldHierarchyNode;
            for (FieldHierarchyNode child : fieldHierarchyNode.getChildren()) {
                if (child.isLeaf()) {
                    HierarchicalFieldElement node = new HierarchicalFieldElement((FieldDefinition)child, repository);
                    this.addChild(node);
                    continue;
                }
                this.addChild(new HierarchicalStructureElement(child, repository));
            }
        }

        public FieldHierarchyNode getFieldHierarcyNode() {
            return this.myFieldStructure;
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class HierarchicalFieldElement
    extends FieldElement {
        private FieldDefinition myField;

        public HierarchicalFieldElement(FieldDefinition field, ClassRepository repository) {
            super(field.getFieldName(), repository);
            this.myField = field;
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public FieldDefinition getField() {
            return this.myField;
        }

        public String getFieldPath() {
            return this.myField.getCanonicalName();
        }
    }

    public class MapGroupElement
    extends FieldGroupElement {
        private final List<String> myKeyFields;

        MapGroupElement(String groupName, String keyFields, ClassRepository repository) {
            super(groupName, repository);
            this.myKeyFields = "".equals(keyFields) ? Collections.emptyList() : Arrays.asList(keyFields.split(";"));
        }

        public FieldElement[] getKeyFieldElements() {
            List<String> keyFields = this.getKeyFields();
            FieldElement[] list = new FieldElement[keyFields.size()];
            int idx = 0;
            int cc = this.getChildCount();
            for (int i = 0; i < cc; ++i) {
                FieldElement child = (FieldElement)this.getChildAt(i);
                if (!keyFields.contains(child.getName())) continue;
                list[idx++] = child;
            }
            return list;
        }

        private List<String> getKeyFields() {
            List<String> keyFields;
            if (!this.myKeyFields.isEmpty()) {
                keyFields = this.myKeyFields;
            } else if (this.getChildCount() > 0) {
                FieldElement child = (FieldElement)this.getChildAt(0);
                keyFields = Arrays.asList(child.getField().getKeyFields());
            } else {
                keyFields = Collections.emptyList();
            }
            return keyFields;
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.myKeyFields == null ? 0 : this.myKeyFields.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapGroupElement other = (MapGroupElement)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.myKeyFields == null ? other.myKeyFields != null : !this.myKeyFields.equals(other.myKeyFields));
        }

        private ServiceFieldStructure getOuterType() {
            return ServiceFieldStructure.this;
        }
    }

    public class ArrayGroupElement
    extends FieldGroupElement {
        ArrayGroupElement(String groupName, ClassRepository repository) {
            super(groupName, repository);
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public abstract class FieldGroupElement
    extends StructureElement {
        FieldGroupElement(String groupName, ClassRepository repository) {
            super(groupName, repository);
        }
    }

    public class GroupElement
    extends StructureElement {
        GroupElement(String groupName, ClassRepository repository) {
            super(groupName, repository);
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class FieldElement
    extends StructureElement {
        FieldElement(String fieldName, ClassRepository repository) {
            super(fieldName, repository);
        }

        public FieldDefinition getField() {
            return this.myRepository.getFieldDefinitionByName(this.getName());
        }

        @Override
        public void insertChildAt(int index, DAGNode node) {
            throw new UnsupportedOperationException("A field cannot have children.");
        }

        @Override
        public void insertLinkAt(int index, DAGNode node) {
            throw new UnsupportedOperationException("A field cannot have children.");
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class RatingPlanContextElement
    extends StructureElement {
        RatingPlanContextElement(String name, ClassRepository repository) {
            super(name, repository);
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class ServiceProviderContextElement
    extends StructureElement {
        ServiceProviderContextElement(String name, ClassRepository repository) {
            super(name, repository);
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class ContextElement
    extends StructureElement {
        ContextElement(String contextName, ClassRepository repository) {
            super(contextName, repository);
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class CommonFieldsElement
    extends StructureElement {
        CommonFieldsElement(ClassRepository repository) {
            super(ServiceFieldStructure.COMMON_FIELDS, repository);
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }
    }

    public class RootElement
    extends StructureElement {
        RootElement(ClassRepository repository) {
            super("root", repository);
        }

        @Override
        public void accept(ServiceFieldStructureVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public int getDistanceFromRoot() {
            return 0;
        }
    }

    public abstract class StructureElement
    extends BaseDAGNode
    implements Acceptable<ServiceFieldStructureVisitor> {
        protected final ClassRepository myRepository;
        private final String myName;

        protected StructureElement(String name, ClassRepository repository) {
            this.myName = name;
            this.myRepository = repository;
        }

        public ClassRepository getClassRepository() {
            return this.myRepository;
        }

        public String getName() {
            return this.myName;
        }

        public int getDistanceFromRoot() {
            return 1 + ((StructureElement)this.getParent()).getDistanceFromRoot();
        }

        public StructureElement getNamedChild(String name) {
            StructureElement found = null;
            for (int i = 0; found == null && i < this.getChildCount(); ++i) {
                StructureElement child = (StructureElement)this.getChildAt(i);
                if (!child.getName().equals(name)) continue;
                found = child;
            }
            return found;
        }

        @Override
        public abstract void accept(ServiceFieldStructureVisitor var1);

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StructureElement other = (StructureElement)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.myName == null ? other.myName != null : !this.myName.equals(other.myName));
        }

        private ServiceFieldStructure getOuterType() {
            return ServiceFieldStructure.this;
        }
    }
}

