/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.defs.StructureBuilderException;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.ElementAndContext;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.FieldContext;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.XMLUtil;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ServiceFieldStructureBuilder {
    private static final String TAG_FIELD_STRUCTURE = "FieldStructure";
    private static final String TAG_FIELD = "Field";
    private static final String TAG_GROUP = "Group";
    private static final String ATTR_GROUPTYPE = "Type";
    private static final String ATTR_NAME = "Name";
    private static final String ATTR_GROUPKEYFIELDS = "keyField";
    private final ClassRepository myRepository;
    private boolean myDoThrowOnError;

    ServiceFieldStructureBuilder(ClassRepository repository) {
        this.myRepository = repository;
    }

    ServiceFieldStructureBuilder throwOnError(boolean doThrow) {
        this.myDoThrowOnError = doThrow;
        return this;
    }

    ServiceFieldStructure build() {
        ServiceFieldStructure structure = new ServiceFieldStructure(this.myRepository);
        Element fieldsRoot = this.myRepository.getFieldsRootElement();
        if (fieldsRoot != null) {
            this.traverseCommonFields(structure, fieldsRoot, this.myRepository);
        }
        Set<Map.Entry<String, ElementAndContext>> serviceProviderContextFields = this.myRepository.getAllServiceProviderContextFields();
        for (Map.Entry<String, ElementAndContext> entry : serviceProviderContextFields) {
            FieldContext fieldContext = entry.getValue().getFieldContext();
            ClassRepository repositoryWithContext = this.myRepository.getClassRepositoryWithContext(fieldContext);
            this.traverseServiceProviderFields(structure, fieldContext.getServiceProviderStringKey(), entry.getValue().getElement(), repositoryWithContext);
        }
        Set<Map.Entry<String, ElementAndContext>> ratingPlanContextFields = this.myRepository.getAllRatingPlanContextFields();
        for (Map.Entry<String, ElementAndContext> entry : ratingPlanContextFields) {
            FieldContext fieldContext = entry.getValue().getFieldContext();
            ClassRepository repositoryWithContext = this.myRepository.getClassRepositoryWithContext(fieldContext);
            this.traverseRatingPlanFields(structure, fieldContext.getRatingPlanStringKey(), entry.getValue().getElement(), repositoryWithContext);
        }
        Set<Map.Entry<String, Element>> set = this.myRepository.getAllContexts();
        if (set != null) {
            for (Map.Entry<String, Element> context : set) {
                this.traverseContext(structure, context.getKey(), context.getValue(), this.myRepository);
            }
        }
        return structure;
    }

    private void traverseCommonFields(ServiceFieldStructure structure, Element fieldsRoot, ClassRepository repository) {
        structure.enterCommonFieldsRoot(repository);
        this.traverse(structure, fieldsRoot, this.myRepository);
        structure.leave();
    }

    private void traverseContext(ServiceFieldStructure structure, String contextName, Element contextRoot, ClassRepository repository) {
        structure.enterContext(contextName, repository);
        this.traverse(structure, contextRoot, this.myRepository);
        structure.leave();
    }

    private void traverseServiceProviderFields(ServiceFieldStructure structure, String name, Element root, ClassRepository repositoryWithContext) {
        structure.enterServiceProviderContext(name, repositoryWithContext);
        this.traverse(structure, root, repositoryWithContext);
        structure.leave();
    }

    private void traverseRatingPlanFields(ServiceFieldStructure structure, String name, Element root, ClassRepository repositoryWithContext) {
        structure.enterRatingPlanContext(name, repositoryWithContext);
        this.traverse(structure, root, repositoryWithContext);
        structure.leave();
    }

    private void traverse(ServiceFieldStructure structure, Element element, ClassRepository repository) {
        NodeList children = element.getChildNodes();
        for (Node child : new NodeListIterable(children, 1)) {
            Element childElement = (Element)child;
            String elementName = childElement.getNodeName();
            if (TAG_FIELD.equals(elementName)) {
                this.processField(structure, childElement, repository);
                continue;
            }
            if (TAG_GROUP.equals(elementName)) {
                this.processGroup(structure, childElement, repository);
                continue;
            }
            if (TAG_FIELD_STRUCTURE.equals(elementName)) {
                this.processHierarchicalStructure(structure, childElement, repository);
                continue;
            }
            this.maybeThrow("Unrecognized element: " + elementName);
        }
    }

    private void maybeThrow(String msg) {
        if (this.myDoThrowOnError) {
            throw new StructureBuilderException(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processGroup(ServiceFieldStructure structure, Element childElement, ClassRepository repository) {
        String groupType = XMLUtil.getAttributeFromElement(childElement, ATTR_GROUPTYPE, TAG_GROUP);
        String groupName = childElement.getAttribute(ATTR_NAME);
        if (TAG_GROUP.equals(groupType)) {
            structure.enterGroup(groupName, repository);
        } else if ("Array group".equals(groupType)) {
            structure.enterArrayGroup(groupName, repository);
        } else {
            if (!"Map group".equals(groupType)) {
                this.maybeThrow("Unrecognized group type: " + groupType);
                return;
            }
            String keyFields = childElement.getAttribute(ATTR_GROUPKEYFIELDS);
            structure.enterMapGroup(groupName, keyFields, repository);
        }
        this.traverse(structure, childElement, repository);
        structure.leave();
    }

    private void processHierarchicalStructure(ServiceFieldStructure structure, Element childElement, ClassRepository repository) {
        String name = childElement.getAttribute(ATTR_NAME);
        FieldHierarchyNode fieldHierarchyNode = this.myRepository.getFieldRepository().getFieldByName(name);
        if (fieldHierarchyNode == null) {
            this.maybeThrow("FieldStructure not found: " + name);
        } else {
            structure.addHierarchicalStructure(fieldHierarchyNode, repository);
        }
    }

    private void processField(ServiceFieldStructure structure, Element childElement, ClassRepository repository) {
        String name = childElement.getAttribute(ATTR_NAME);
        FieldDefinition fd = repository.getFieldDefinitionByName(name);
        if (fd == null) {
            this.maybeThrow("Field not found: " + name);
        } else {
            structure.addField(fd, repository);
        }
    }
}

