/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.dag.DAGVisit;
import com.ericsson.ere.defs.ServiceFieldStructure;
import com.ericsson.ere.defs.ServiceFieldStructureVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceFieldValidator
extends ServiceFieldStructureVisitor {
    private Map<Class<? extends ServiceFieldStructure.StructureElement>, List<FieldValidator<? extends ServiceFieldStructure.StructureElement>>> myValidators = new HashMap<Class<? extends ServiceFieldStructure.StructureElement>, List<FieldValidator<? extends ServiceFieldStructure.StructureElement>>>();

    public <T extends ServiceFieldStructure.StructureElement> void addValidator(Class<T> elementType, FieldValidator<? super T> validator) {
        if (elementType == null || validator == null) {
            throw new IllegalArgumentException("Null argument not permitted.");
        }
        List<FieldValidator<? extends ServiceFieldStructure.StructureElement>> list = this.myValidators.get(elementType);
        if (list == null) {
            list = new ArrayList<FieldValidator<? extends ServiceFieldStructure.StructureElement>>();
            this.myValidators.put(elementType, list);
        }
        list.add(validator);
    }

    public List<FieldValidatorError> validateFieldStructure(ServiceFieldStructure.StructureElement entryPoint) {
        DAGVisit.visitPreOrder(entryPoint, this);
        ArrayList<FieldValidatorError> errors = new ArrayList<FieldValidatorError>();
        for (List<FieldValidator<? extends ServiceFieldStructure.StructureElement>> validators : this.myValidators.values()) {
            for (FieldValidator<? extends ServiceFieldStructure.StructureElement> v : validators) {
                errors.addAll(v.getErrors());
            }
        }
        return errors;
    }

    @Override
    public void visit(ServiceFieldStructure.RootElement element) {
        this.callValidators(ServiceFieldStructure.RootElement.class, element);
    }

    @Override
    public void visit(ServiceFieldStructure.ContextElement element) {
        this.callValidators(ServiceFieldStructure.ContextElement.class, element);
    }

    @Override
    public void visit(ServiceFieldStructure.ServiceProviderContextElement element) {
        this.callValidators(ServiceFieldStructure.ServiceProviderContextElement.class, element);
    }

    @Override
    public void visit(ServiceFieldStructure.RatingPlanContextElement element) {
        this.callValidators(ServiceFieldStructure.RatingPlanContextElement.class, element);
    }

    @Override
    public void visit(ServiceFieldStructure.FieldElement element) {
        this.callValidators(ServiceFieldStructure.FieldElement.class, element);
    }

    @Override
    public void visit(ServiceFieldStructure.GroupElement element) {
        this.callValidators(ServiceFieldStructure.GroupElement.class, element);
    }

    @Override
    public void visit(ServiceFieldStructure.ArrayGroupElement element) {
        this.callValidators(ServiceFieldStructure.ArrayGroupElement.class, element);
    }

    @Override
    public void visit(ServiceFieldStructure.MapGroupElement element) {
        this.callValidators(ServiceFieldStructure.MapGroupElement.class, element);
    }

    private <T extends ServiceFieldStructure.StructureElement> void callValidators(Class<T> clazz, T element) {
        List<FieldValidator<? extends ServiceFieldStructure.StructureElement>> validators = this.myValidators.get(clazz);
        if (validators != null && !validators.isEmpty()) {
            for (FieldValidator<? extends ServiceFieldStructure.StructureElement> v : validators) {
                v.validate(element);
            }
        }
    }

    public static class FieldValidatorError {
        private final ServiceFieldStructure.StructureElement myElement;
        private final String myReason;

        public FieldValidatorError(ServiceFieldStructure.StructureElement element, String reason) {
            this.myReason = reason;
            this.myElement = element;
        }

        public ServiceFieldStructure.StructureElement getElement() {
            return this.myElement;
        }

        public String getReason() {
            return this.myReason;
        }
    }

    public static abstract class AbstractFieldValidator<T extends ServiceFieldStructure.StructureElement>
    implements FieldValidator<T> {
        private List<FieldValidatorError> myErrors = new ArrayList<FieldValidatorError>();

        protected void registerError(FieldValidatorError error) {
            this.myErrors.add(error);
        }

        @Override
        public List<FieldValidatorError> getErrors() {
            return this.myErrors;
        }
    }

    public static interface FieldValidator<T extends ServiceFieldStructure.StructureElement> {
        public void validate(T var1);

        public List<FieldValidatorError> getErrors();
    }
}

