/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import java.util.HashMap;
import java.util.Map;

public final class SettingsRepository {
    private final Map<Setting<?>, Object> myValues = new HashMap();

    public <T> void setValue(Setting<T> setting, T value) {
        if (value != null) {
            setting.setValue(this.myValues, value);
        } else {
            setting.clearValue(this.myValues);
        }
    }

    public boolean hasValue(Setting<?> setting) {
        return setting.hasValue(this.myValues);
    }

    public <T> T getValue(Setting<T> setting) {
        return setting.getValue(this.myValues);
    }

    private static class SystemPropertyBasedSetting
    extends Setting<String> {
        SystemPropertyBasedSetting(String name, String defaultValue) {
            super(name, defaultValue);
        }

        @Override
        protected String clearValue(Map<Setting<?>, Object> repository) {
            return System.clearProperty(this.getName());
        }

        @Override
        protected String getValueImpl(Map<Setting<?>, Object> repository) {
            return System.getProperty(this.getName());
        }

        @Override
        protected boolean hasValue(Map<Setting<?>, Object> repository) {
            return System.getProperty(this.getName()) != null;
        }

        @Override
        protected String setValue(Map<Setting<?>, Object> repository, String value) {
            return System.setProperty(this.getName(), value);
        }
    }

    private static class RegularSetting<T>
    extends Setting<T> {
        RegularSetting(String name, T defaultValue) {
            super(name, defaultValue);
        }

        @Override
        protected T clearValue(Map<Setting<?>, Object> repository) {
            return (T)repository.remove(this);
        }

        @Override
        protected T getValueImpl(Map<Setting<?>, Object> repository) {
            return (T)repository.get(this);
        }

        @Override
        protected boolean hasValue(Map<Setting<?>, Object> repository) {
            return repository.containsKey(this);
        }

        @Override
        protected T setValue(Map<Setting<?>, Object> repository, T value) {
            return (T)repository.put(this, value);
        }
    }

    public static abstract class Setting<T> {
        private final String myName;
        private final T myDefaultValue;

        protected Setting(String name, T defaultValue) {
            this.myName = name;
            this.myDefaultValue = defaultValue;
        }

        public static <T> Setting<T> create(String name, T defaultValue) {
            assert (name != null && !"".equals(name));
            return new RegularSetting<T>(name, defaultValue);
        }

        public static Setting<String> createSystemPropertyBased(String name, String defaultValue) {
            assert (name != null && !"".equals(name));
            return new SystemPropertyBasedSetting(name, defaultValue);
        }

        T getValue(Map<Setting<?>, Object> repository) {
            T value = this.getValueImpl(repository);
            if (value == null) {
                value = this.getDefaultValue();
            }
            return value;
        }

        protected abstract T getValueImpl(Map<Setting<?>, Object> var1);

        protected abstract boolean hasValue(Map<Setting<?>, Object> var1);

        protected abstract T setValue(Map<Setting<?>, Object> var1, T var2);

        protected abstract T clearValue(Map<Setting<?>, Object> var1);

        String getName() {
            return this.myName;
        }

        T getDefaultValue() {
            return this.myDefaultValue;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Setting other = (Setting)obj;
            return !(this.myName == null ? other.myName != null : !this.myName.equals(other.myName));
        }
    }
}

