/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.defs;

import com.ericsson.ere.defs.AbstractValueType;
import com.ericsson.ere.defs.ClassRepositoryUser;
import com.ericsson.ere.exception.ServiceDataException;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;

public final class ValueClassBasedValueType
extends AbstractValueType {
    private final Class<?> myValueClass;

    private ValueClassBasedValueType(ValueClassFactory factory, Class<?> valueClass) {
        super(factory);
        this.myValueClass = valueClass;
    }

    public static ValueClassBasedValueType createValueType(Class<?> valueClassFactoryClass, Class<?> valueClass, ClassRepository classRepository) throws ServiceDataException, IllegalArgumentException {
        if (valueClassFactoryClass == null) {
            throw new IllegalArgumentException("Parameter value class factory cannot be null.");
        }
        if (valueClass == null) {
            throw new IllegalArgumentException("Parameter value class cannot be null.");
        }
        if (classRepository == null) {
            throw new IllegalArgumentException("Parameter class repository cannot be null.");
        }
        try {
            Object factoryObject = valueClassFactoryClass.newInstance();
            if (factoryObject instanceof ValueClassFactory) {
                ValueClassFactory factory = (ValueClassFactory)factoryObject;
                if (!valueClass.isAssignableFrom(factory.createDefaultInstance().getClass())) {
                    throw new ServiceDataException("Could not create value class: " + valueClass.getName() + ", from value class factory: " + valueClassFactoryClass.getName());
                }
                if (factoryObject instanceof ClassRepositoryUser) {
                    ((ClassRepositoryUser)factoryObject).setClassRepository(classRepository);
                }
                return new ValueClassBasedValueType(factory, valueClass);
            }
            throw new ServiceDataException("Could not create value class factory from: " + valueClassFactoryClass.getName());
        }
        catch (InstantiationException e) {
            throw new ServiceDataException("Could not create value class factory from: " + valueClassFactoryClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceDataException("Could not create value class factory from: " + valueClassFactoryClass.getName(), e);
        }
    }

    public static ValueClassBasedValueType createValueType(String valueClassFactoryString, String valueClassString, ClassRepository classRepository) throws ServiceDataException, IllegalArgumentException {
        Class<?> valueClass;
        Class<?> valueClassFactoryClass;
        if (valueClassFactoryString == null) {
            throw new IllegalArgumentException("Parameter value class factory cannot be null.");
        }
        if (valueClassString == null) {
            throw new IllegalArgumentException("Parameter value class cannot be null.");
        }
        try {
            valueClassFactoryClass = EreClassLoader.getClass(valueClassFactoryString);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceDataException("Could not find value class factory: " + valueClassFactoryString);
        }
        try {
            valueClass = EreClassLoader.getClass(valueClassString);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceDataException("Could not find value class: " + valueClassString);
        }
        return ValueClassBasedValueType.createValueType(valueClassFactoryClass, valueClass, classRepository);
    }

    @Override
    public Class<?> getValueClass() {
        return this.myValueClass;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValueType[ValueClassFactory: ").append(this.myValueClassFactory.getClass().getName()).append(", ValueClass: ").append(this.myValueClass.getName()).append("]");
        return sb.toString();
    }

    @Override
    public boolean containsDataType() {
        return false;
    }
}

