/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.executor;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.STQStack;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.executor.TreeExecutorDelegate;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeQualifierUser;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import java.util.EmptyStackException;

public class STQTreeExecutor
extends TreeExecutorDelegate {
    public STQTreeExecutor() {
        super(new DefaultTreeExecutor());
    }

    public STQTreeExecutor(TreeExecutor delegee) {
        super(delegee);
    }

    @Override
    public void execute(TariffStructure tariffStructure, DataSet dataSet) {
        super.execute(tariffStructure, dataSet);
    }

    @Override
    public void execute(ExecutableNode executableNode, DataSet dataSet) {
        SelectionTreeQualifierUser stqUser;
        STQStack stqStack = this.extractSTQStackIfPossible(dataSet);
        boolean pushAndPopSTQ = this.shouldHandleSTQ(stqStack, stqUser = this.extractSTQUserIfPossible(executableNode));
        if (pushAndPopSTQ) {
            stqStack.pushQualifier(stqUser.getSelectionTreeQualifier());
        }
        super.execute(executableNode, dataSet);
        if (pushAndPopSTQ) {
            try {
                stqStack.popQualifier();
            }
            catch (EmptyStackException ese) {
                throw new TreeExecutionException(ese);
            }
        }
    }

    private STQStack extractSTQStackIfPossible(DataSet dataSet) {
        STQStack stqStack = null;
        if (dataSet instanceof STQStack) {
            stqStack = (STQStack)((Object)dataSet);
        }
        return stqStack;
    }

    private SelectionTreeQualifierUser extractSTQUserIfPossible(ExecutableNode executableNode) {
        SelectionTreeQualifierUser stqUser = null;
        if (executableNode instanceof SelectionTreeQualifierUser) {
            SelectionTreeQualifierUser tempUser = (SelectionTreeQualifierUser)((Object)executableNode);
            stqUser = tempUser.hasSelectionTreeQualifier() ? tempUser : null;
        }
        return stqUser;
    }

    private boolean shouldHandleSTQ(STQStack stqStack, SelectionTreeQualifierUser stqUser) {
        return stqStack != null && stqUser != null;
    }
}

