/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.executor;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.task.TreeTask;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.executor.TreeExecutorDelegate;
import com.ericsson.ere.selectiontree.interfaces.Conditionality;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.Performable;

public class TimeSwitchTreeExecutor
extends TreeExecutorDelegate {
    private State myState = State.EXECUTING_CHILDREN;

    public TimeSwitchTreeExecutor() {
        this(new DefaultTreeExecutor());
    }

    public TimeSwitchTreeExecutor(TreeExecutor executor) {
        super(executor);
    }

    @Override
    public void execute(ExecutableNode executableNode, DataSet dataSet) {
        this.myState = State.EXECUTING_CHILDREN;
        super.execute(executableNode, dataSet);
        this.myState = State.EXECUTING_CHILDREN;
    }

    @Override
    public boolean testCondition(Conditionality condition, DataSet dataSet) {
        long durationToTimeSwitch;
        this.resetTimeSwitchIfNecessary(dataSet);
        this.myState = State.TESTING_CONDITIONS;
        boolean result = super.testCondition(condition, dataSet);
        long l = durationToTimeSwitch = result ? this.getSatisfiedDurationForCondition(condition, dataSet) : this.getUnsatisfiedDurationForCondition(condition, dataSet);
        if (durationToTimeSwitch != Long.MAX_VALUE) {
            dataSet.getTreeTask().setDurationToNextTimeSwitch(durationToTimeSwitch);
        }
        return result;
    }

    protected long getSatisfiedDurationForCondition(Conditionality condition, DataSet dataSet) {
        return condition.getConditionSatisfiedDuration(dataSet);
    }

    protected long getUnsatisfiedDurationForCondition(Conditionality condition, DataSet dataSet) {
        return condition.getConditionUnsatisfiedDuration(dataSet);
    }

    @Override
    public void execute(Performable performable, DataSet dataSet) {
        this.myState = State.EXECUTING_CHILDREN;
        super.execute(performable, dataSet);
    }

    private void resetTimeSwitchIfNecessary(DataSet dataSet) {
        if (this.myState != State.TESTING_CONDITIONS) {
            dataSet.getTreeTask().setDurationToNextTimeSwitch(TreeTask.TIME_SWITCH_RESET);
        }
    }

    private static enum State {
        TESTING_CONDITIONS,
        EXECUTING_CHILDREN;

    }
}

