/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.BinaryAmountOperator;
import com.ericsson.ere.expression.BinaryDateOperator;
import com.ericsson.ere.expression.BinaryTimeOperator;
import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.math.RatingDecimal;

public final class Add
extends GenericBinaryOperator {
    public static final Add INSTANCE = new Add();

    private Add() {
    }

    @Override
    protected Object performImpl(Object left, Object right) {
        Object ret;
        if (BinaryTimeOperator.canHandle(left, right)) {
            ret = BinaryTimeOperator.ADD.perform(left, right);
        } else if (BinaryDateOperator.canHandle(left, right)) {
            ret = BinaryDateOperator.ADD.perform(left, right);
        } else if (BinaryAmountOperator.canHandle(left, right)) {
            ret = BinaryAmountOperator.ADD.perform(left, right);
        } else {
            RatingDecimal rd1 = Add.convertToRatingDecimal(left, "left");
            RatingDecimal rd2 = Add.convertToRatingDecimal(right, "right");
            ret = rd1.add(rd2);
        }
        return ret;
    }

    public String toString() {
        return "+";
    }
}

