/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.datatype.LazyEvaluatedValue;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.ExpressionConverter;
import com.ericsson.ere.expression.ExpressionEvaluator;
import com.ericsson.ere.expression.ExpressionFormatter;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FieldContainerOperand;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.PlainExpressionFormatter;
import com.ericsson.ere.expression.PostfixEvaluator;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import ericsson.ere.interfaces.UsedFieldLister;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Immutable
public class Expression
implements Operand,
LazyEvaluatedValue<Object>,
UsedFieldLister {
    private List<ExpressionToken> myTokens;
    private ExpressionNotation myNotation;

    public Expression(List<? extends ExpressionToken> tokens, ExpressionNotation notation) {
        if (tokens == null || notation == null) {
            throw new IllegalArgumentException("Requires non-null arguments.");
        }
        this.myTokens = Collections.unmodifiableList(tokens);
        this.myNotation = notation;
    }

    public ExpressionNotation getNotation() {
        return this.myNotation;
    }

    public List<ExpressionToken> getExpressionTokens() {
        return this.myTokens;
    }

    public Operand evaluate(EvaluationContext context) {
        ExpressionEvaluator evaluator = context.getEvaluator();
        return evaluator.evaluate(this, context);
    }

    public Expression convert(ExpressionConverter converter) {
        return converter.convert(this);
    }

    public String format(ExpressionFormatter formatter) {
        return formatter.format(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myNotation == null ? 0 : this.myNotation.hashCode());
        result = 31 * result + (this.myTokens == null ? 0 : this.myTokens.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Expression other = (Expression)obj;
        if (this.myNotation == null ? other.myNotation != null : !this.myNotation.equals((Object)other.myNotation)) {
            return false;
        }
        return !(this.myTokens == null ? other.myTokens != null : !this.myTokens.equals(other.myTokens));
    }

    public String toString() {
        return this.format(new PlainExpressionFormatter());
    }

    @Override
    public Object getValue(EvaluationContext context) {
        Operand result = this.evaluate(context);
        return result.getValue(context);
    }

    @Override
    public Object evaluate(final DataSet dataset) {
        return this.getValue(new DataSetEvaluationContext(){
            private ExpressionEvaluator myEvaluator = new PostfixEvaluator();

            @Override
            public ExpressionEvaluator getEvaluator() {
                return this.myEvaluator;
            }

            @Override
            public DataSet getDataSet() {
                return dataset;
            }
        });
    }

    @Override
    public Set<String> getUsedFields() {
        HashSet<String> set = new HashSet<String>();
        for (ExpressionToken token : this.myTokens) {
            if (!(token instanceof FieldContainerOperand)) continue;
            FieldContainerOperand operand = (FieldContainerOperand)((Object)token);
            for (FieldContainerOperand.FieldContainer container : operand.getContainedFields()) {
                set.add(container.getFieldName());
            }
        }
        return set;
    }

    public static enum ExpressionNotation {
        INFIX,
        POSTFIX;

    }
}

