/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.FieldContainerOperand;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.selectiontree.modifiers.DataSetValueReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.DataSetEvaluationContext;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import ericsson.ere.datatype.DataType;
import java.util.ArrayList;
import java.util.Collection;

@Immutable
public class FieldValueOperand
implements Operand,
FieldContainerOperand {
    private final DataSetField myField;
    private final FieldIndexKeyContainer myKey;
    private final DataSetValueReader myReader;

    public FieldValueOperand(DataSetField field, DataSetValueReader reader) {
        this(field, null, reader);
    }

    public FieldValueOperand(DataSetField field, FieldIndexKeyContainer key, DataSetValueReader reader) {
        this.myField = field;
        this.myKey = key;
        this.myReader = reader;
    }

    @Override
    public Object getValue(EvaluationContext context) {
        DataSetEvaluationContext ctx = (DataSetEvaluationContext)context;
        DataSet ds = ctx.getDataSet();
        return this.getFieldValue(ds);
    }

    private Object getFieldValue(DataSet ds) {
        Object value;
        if (this.myKey == null) {
            value = this.myReader.getValueFromDataSet(ds, this.myField, null);
        } else {
            Key[] keys = this.myReader.getKeysFromDataSet(ds, this.myKey);
            assert (keys.length == 1) : "Only supports single key.";
            value = this.myReader.getValueFromDataSet(ds, this.myField, keys[0]);
        }
        value = this.convertIfNecessary(value);
        return value;
    }

    private Object convertIfNecessary(Object value) {
        Object ret = value;
        DataType dt = this.myField.getDataType();
        if (dt != null && value instanceof Number) {
            ret = DataType.convertSignedToUnsigned(value, dt);
        }
        return ret;
    }

    public FieldIndexKeyContainer getKeyContainer() {
        return this.myKey;
    }

    public String getFieldName() {
        return this.myField.getFieldName();
    }

    public String toString() {
        String s;
        String fn = this.myField.getFieldName();
        if (this.myKey != null) {
            String idx = this.myKey.getKeyFieldName();
            if (idx == null) {
                Key[] keys = this.myKey.getKeySet(null);
                if (keys.length >= 1) {
                    Key k = keys[0];
                    Object keyObject = k.containsKey() ? k.getKey() : Integer.valueOf(k.getIndex());
                    idx = ValueOperand.createFor(keyObject).toStringSingleQuotes();
                } else {
                    idx = "";
                }
            }
            s = String.format("%s[%s]", fn, idx);
        } else {
            s = fn;
        }
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myField == null ? 0 : this.myField.hashCode());
        result = 31 * result + (this.myKey == null ? 0 : this.myKey.hashCode());
        result = 31 * result + (this.myReader == null ? 0 : this.myReader.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!FieldValueOperand.class.isInstance(obj)) {
            return false;
        }
        FieldValueOperand other = (FieldValueOperand)obj;
        if (this.myField == null ? other.myField != null : !this.myField.equals(other.myField)) {
            return false;
        }
        if (this.myKey == null ? other.myKey != null : !this.myKey.equals(other.myKey)) {
            return false;
        }
        return !(this.myReader == null ? other.myReader != null : !this.myReader.equals(other.myReader));
    }

    @Override
    public Collection<FieldContainerOperand.FieldContainer> getContainedFields() {
        ArrayList<FieldContainerOperand.FieldContainer> names = new ArrayList<FieldContainerOperand.FieldContainer>();
        names.add(new FieldContainerOperand.FieldContainer(this.myField, (Object)this.myKey));
        if (this.myKey != null) {
            Object[] rawKeys;
            for (Object rawKey : rawKeys = this.myKey.getRawKeys()) {
                if (!FieldIndexKeyContainer.rawKeyRepresentsField(rawKey)) continue;
                DataSetField field = FieldIndexKeyContainer.getFieldFromRawKey(rawKey);
                names.add(new FieldContainerOperand.FieldContainer(field, null));
            }
        }
        return names;
    }
}

