/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.FunctionParameterInfo;
import com.ericsson.ere.expression.Operand;
import ericsson.ere.datatype.DataType;
import java.util.Stack;

public class IdentityFunction
extends Function {
    private final Function myFunction;

    public IdentityFunction(Function f) {
        if (f == null) {
            throw new IllegalArgumentException("Cannot wrap a null function.");
        }
        this.myFunction = f;
    }

    @Override
    public String getFunctionDescription() {
        return this.myFunction.getFunctionDescription();
    }

    @Override
    public String getFunctionName() {
        if (this.myFunction == null) {
            return "temp";
        }
        return this.myFunction.getFunctionName();
    }

    @Override
    public FunctionParameterInfo[] getParameters() {
        return this.myFunction.getParameters();
    }

    @Override
    public void perform(Stack<Operand> operandStack, EvaluationContext context) {
        this.myFunction.perform(operandStack, context);
    }

    @Override
    protected Object perform(Object[] args) {
        throw new AssertionError((Object)"Should not be called since the main perform is overridden.");
    }

    @Override
    public DataType getReturnType() {
        return this.myFunction.getReturnType();
    }

    public Function getFunction() {
        return this.myFunction;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.myFunction.equals(other)) {
            return true;
        }
        if (other instanceof IdentityFunction) {
            return this.myFunction.equals(((IdentityFunction)other).myFunction);
        }
        return false;
    }

    public int hashCode() {
        return this.myFunction.hashCode();
    }
}

