/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.Divide;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;

public final class IntegerDivide
extends Divide {
    public static final IntegerDivide INSTANCE = new IntegerDivide();

    private IntegerDivide() {
    }

    @Override
    protected Object performImpl(Object left, Object right) {
        Object result = super.performImpl(left, right);
        if (result instanceof Amount) {
            Amount amount = (Amount)result;
            RatingDecimal balance = amount.getBalance();
            balance = this.round(balance);
            result = amount.getAmountFactory().create(balance, amount.getCurrency());
        } else if (result instanceof RatingDecimal) {
            result = this.round((RatingDecimal)result);
        } else {
            throw new ExpressionException("Unknown value type for integer division: " + result.getClass().getSimpleName());
        }
        return result;
    }

    private RatingDecimal round(RatingDecimal rd) {
        return rd.round(0, 3);
    }

    @Override
    public String toString() {
        return "\\";
    }
}

