/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.expression.GenericUnaryOperator;
import com.ericsson.ere.math.RatingDecimal;
import ericsson.ere.datatype.Amount;

public class Negate
extends GenericUnaryOperator {
    public static final Negate INSTANCE = new Negate();

    private Negate() {
    }

    @Override
    protected Object performImpl(Object value) {
        Comparable<RatingDecimal> ret;
        if (value instanceof Amount) {
            Amount a = (Amount)value;
            RatingDecimal balance = a.getBalance();
            String currency = a.getCurrency();
            ret = a.getAmountFactory().create(balance.negate(), currency);
        } else {
            RatingDecimal rd = GenericBinaryOperator.convertToRatingDecimal(value, "value");
            ret = rd.negate();
        }
        return ret;
    }

    public String toString() {
        return "-";
    }
}

