/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.Add;
import com.ericsson.ere.expression.Append;
import com.ericsson.ere.expression.Assign;
import com.ericsson.ere.expression.Divide;
import com.ericsson.ere.expression.IntegerDivide;
import com.ericsson.ere.expression.Modulus;
import com.ericsson.ere.expression.Multiply;
import com.ericsson.ere.expression.Negate;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Power;
import com.ericsson.ere.expression.Prefix;
import com.ericsson.ere.expression.Subtract;
import java.util.HashMap;
import java.util.Map;

public final class Operators {
    public static final Operator ADD = Add.INSTANCE;
    public static final Operator SUBTRACT = Subtract.INSTANCE;
    public static final Operator MULTIPLY = Multiply.INSTANCE;
    public static final Operator DIVIDE = Divide.INSTANCE;
    public static final Operator INT_DIVIDE = IntegerDivide.INSTANCE;
    public static final Operator MODULUS = Modulus.INSTANCE;
    public static final Operator POWER = Power.INSTANCE;
    public static final Operator NEGATE = Negate.INSTANCE;
    public static final Operator APPEND = Append.INSTANCE;
    public static final Operator PREFIX = Prefix.INSTANCE;
    public static final Operator ASSIGN = Assign.INSTANCE;
    private static Map<String, Operator> myNamedOperators = new HashMap<String, Operator>();

    private Operators() {
    }

    public static String getOperatorName(Operator o) {
        String name = null;
        for (Map.Entry<String, Operator> entry : myNamedOperators.entrySet()) {
            if (!o.equals(entry.getValue())) continue;
            name = entry.getKey();
            break;
        }
        return name;
    }

    public static Operator getOperatorByName(String name) {
        return myNamedOperators.get(name);
    }

    static {
        myNamedOperators.put("add", ADD);
        myNamedOperators.put("sub", SUBTRACT);
        myNamedOperators.put("mul", MULTIPLY);
        myNamedOperators.put("div", DIVIDE);
        myNamedOperators.put("idiv", INT_DIVIDE);
        myNamedOperators.put("mod", MODULUS);
        myNamedOperators.put("pow", POWER);
        myNamedOperators.put("app", APPEND);
        myNamedOperators.put("pre", PREFIX);
        myNamedOperators.put("assign", ASSIGN);
        myNamedOperators.put("neg", NEGATE);
    }
}

