/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.EvaluationContext;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionEvaluator;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import java.util.EmptyStackException;
import java.util.List;
import java.util.Stack;

public class PostfixEvaluator
implements ExpressionEvaluator {
    @Override
    public Operand evaluate(Expression expression, EvaluationContext context) {
        if (expression.getNotation() != Expression.ExpressionNotation.POSTFIX) {
            throw new IllegalArgumentException("Can only evaulate postfix expressions.");
        }
        assert (context.getEvaluator() == this);
        List<ExpressionToken> tokens = expression.getExpressionTokens();
        Stack<Operand> stack = new Stack<Operand>();
        for (ExpressionToken token : tokens) {
            if (token instanceof Operator) {
                try {
                    this.performOperator((Operator)token, stack, context);
                    continue;
                }
                catch (EmptyStackException e) {
                    throw new ExpressionException("Error, ran out of operands for operator.", token);
                }
            }
            if (token instanceof Operand) {
                stack.push((Operand)token);
                continue;
            }
            throw new ExpressionException("Postfix expression must contain operators and operands only.", token);
        }
        int operands = stack.size();
        if (operands == 1) {
            return (Operand)stack.pop();
        }
        throw new ExpressionException(String.format("Error, expected single expression result but has %d operands left.", operands), stack.toArray(new ExpressionToken[operands]));
    }

    protected void performOperator(Operator o, Stack<Operand> operands, EvaluationContext context) {
        o.perform(operands, context);
    }
}

