/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression;

import com.ericsson.ere.expression.GenericBinaryOperator;
import com.ericsson.ere.math.RatingDecimal;

public final class Power
extends GenericBinaryOperator {
    private static final RatingDecimal RD_ONE = new RatingDecimal(1L, 1L);
    public static final Power INSTANCE = new Power();

    private Power() {
    }

    @Override
    protected Object performImpl(Object base, Object exp) {
        RatingDecimal rdbase = Power.convertToRatingDecimal(base, "left");
        RatingDecimal rdexp = Power.convertToRatingDecimal(exp, "right");
        return Power.power(rdbase, rdexp);
    }

    public String toString() {
        return "^";
    }

    public static RatingDecimal power(RatingDecimal base, RatingDecimal exp) {
        if (exp.isZero()) {
            return RD_ONE;
        }
        if (exp.equals(RD_ONE) || base.isZero()) {
            return base;
        }
        if (exp.isLessThanZero()) {
            return Power.power(RD_ONE.divide(base), exp.negate());
        }
        if (exp.isWholeNumber()) {
            RatingDecimal res = base;
            long num = exp.longValue();
            for (long i = 1L; i < num; ++i) {
                res = res.multiply(base);
            }
            return res;
        }
        return new RatingDecimal(Math.pow(base.doubleValue(), exp.doubleValue()));
    }
}

