/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression.parser;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionToken;
import com.ericsson.ere.expression.FieldValueOperand;
import com.ericsson.ere.expression.Function;
import com.ericsson.ere.expression.Functions;
import com.ericsson.ere.expression.Operand;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.expression.Unit;
import com.ericsson.ere.expression.Units;
import com.ericsson.ere.expression.ValueOperand;
import com.ericsson.ere.expression.parser.DefaultExpressionParserOptions;
import com.ericsson.ere.expression.parser.ExpressionParser;
import com.ericsson.ere.expression.parser.ExpressionParserHandler;
import com.ericsson.ere.expression.parser.ParseException;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.FieldDefinitionUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Immutable
public abstract class AbstractExpressionParserHandler
implements ExpressionParserHandler {
    public static final char VALUE_MARKER = '$';
    public static final char FIELD_MARKER = '#';
    protected final Map<String, Function> myCustomFunctions;
    protected final ClassRepository myRepository;

    protected AbstractExpressionParserHandler(ClassRepository repository, Map<String, Function> customFunctions) {
        this.myRepository = repository;
        this.myCustomFunctions = customFunctions != null ? Collections.unmodifiableMap(new HashMap<String, Function>(customFunctions)) : null;
    }

    @Override
    public Function lookupFunction(String funcName) throws ParseException {
        Function f = funcName.startsWith("$") ? this.findCustomFunctionByName(funcName.substring(1)) : this.findFunctionByName(funcName);
        if (f == null) {
            throw new ParseException("Unknown function: " + funcName);
        }
        return f;
    }

    protected Function findFunctionByName(String name) {
        return Functions.getFunctionByName(name);
    }

    protected Function findCustomFunctionByName(String name) {
        if (this.myCustomFunctions != null) {
            return this.myCustomFunctions.get(name);
        }
        return null;
    }

    @Override
    public Operator lookupOperator(String operator) throws ParseException {
        Operator o = this.findOperatorByName(operator);
        if (o == null) {
            throw new ParseException("Unknown operator: " + operator);
        }
        return o;
    }

    protected Operator findOperatorByName(String name) {
        return Operators.getOperatorByName(name);
    }

    @Override
    public Unit lookupUnit(String unit) throws ParseException {
        Unit u = this.findUnitByName(unit);
        if (u == null) {
            throw new ParseException("Unknown unit: " + unit);
        }
        return u;
    }

    protected Unit findUnitByName(String name) {
        return Units.getUnitByName(name);
    }

    @Override
    public Operand createFieldOperand(String fieldName, String indexSpec) throws ParseException {
        FieldDefinition parentField = this.findFieldByName(fieldName);
        if (parentField == null) {
            throw new ParseException("Unknown field name: " + fieldName);
        }
        if (parentField.isComplexType() ^ indexSpec != null) {
            String msg = String.format("Found index specification for plain field, or missing index specification for complex field (%s).", parentField.getFieldName());
            throw new ParseException(msg);
        }
        ValueFieldCompositeObject indexObject = null;
        if (indexSpec != null) {
            String[] keyFields = parentField.getKeyFields();
            if (keyFields.length > 0) {
                String[] keySpecs = indexSpec.split("(?<!\\\\);");
                if (keySpecs.length != keyFields.length) {
                    throw new ParseException(String.format("Number of key values (%d) does not equal number of key fields (%d) for index on field %s", keySpecs.length, keyFields.length, fieldName));
                }
                ArrayList<ValueFieldCompositeObject> theIndexValueFields = new ArrayList<ValueFieldCompositeObject>();
                for (int i = 0; i < keySpecs.length; ++i) {
                    FieldDefinition keyFieldDef = this.findFieldByName(keyFields[i]);
                    String keySpec = keySpecs[i].replace("\\;", ";");
                    ValueFieldCompositeObject theKeyObj = this.createValueFieldObjectForKey(parentField, keySpec, keyFieldDef);
                    theIndexValueFields.add(theKeyObj);
                }
                indexObject = theIndexValueFields.size() == 1 ? (ValueFieldCompositeObject)theIndexValueFields.get(0) : new MultipleValueFieldCompositeObject(theIndexValueFields);
            } else {
                indexObject = this.createValueFieldObjectForKey(parentField, indexSpec, null);
            }
        }
        return this.createFieldOperand(parentField, indexObject);
    }

    protected ValueFieldCompositeObject createValueFieldObjectForKey(FieldDefinition parentField, String aKey, FieldDefinition keyField) throws ParseException {
        ValueFieldCompositeObject result;
        char ch = aKey.charAt(0);
        if (ch == '$') {
            String keyValue = aKey.substring(1);
            ValueResolver resolver = keyField == null ? (parentField.isArray() ? DataType.INTEGER : DataType.STRING) : FieldDefinitionUtil.createValueResolver(null, keyField);
            result = ValueFieldCompositeObject.createForValue(keyValue, resolver);
        } else if (ch == '#') {
            String fieldName = aKey.substring(1);
            this.verifyThatFieldExists(fieldName);
            result = ValueFieldCompositeObject.createForField(fieldName);
        } else {
            result = this.parseKeyAsExpression(parentField, aKey, keyField);
        }
        return result;
    }

    private void verifyThatFieldExists(String fieldName) throws ParseException {
        if (this.findFieldByName(fieldName) == null) {
            throw new ParseException("Unknown field: " + fieldName);
        }
    }

    protected ValueFieldCompositeObject parseKeyAsExpression(FieldDefinition parentField, String aKey, FieldDefinition keyField) throws ParseException {
        ValueFieldCompositeObject result;
        ExpressionParser parser = new ExpressionParser(new DefaultExpressionParserOptions(), this);
        Expression expr = parser.parse(aKey);
        List<ExpressionToken> tokens = expr.getExpressionTokens();
        ValueResolver keyFieldResolver = this.createResolverForKeyField(parentField, keyField);
        int count = tokens.size();
        ExpressionToken token1 = tokens.get(0);
        if (count == 1 && token1 instanceof FieldValueOperand && ((FieldValueOperand)token1).getKeyContainer() == null) {
            FieldValueOperand fieldOp = (FieldValueOperand)token1;
            String fieldName = fieldOp.getFieldName();
            this.verifyThatFieldExists(fieldName);
            result = ValueFieldCompositeObject.createForField(fieldName);
        } else if (parentField.isArray() || parentField.isMap() && keyField == null) {
            String valueString;
            ValueOperand<?> operand = this.getSingleValueOperand(count, token1, parentField.getFieldName(), aKey);
            Object value = this.getValueFromOperand(operand);
            if (value == null) {
                valueString = aKey;
            } else {
                Class expectedClass;
                Class clazz = expectedClass = parentField.isArray() ? Number.class : String.class;
                if (!expectedClass.isInstance(value)) {
                    String msg = String.format("Unexpected key/index type for field %s: %s", parentField.getFieldName(), aKey);
                    throw new ParseException(msg);
                }
                valueString = parentField.isArray() ? Integer.toString(((Number)value).intValue()) : (String)value;
            }
            result = ValueFieldCompositeObject.createForValue(valueString, keyFieldResolver.getDataType());
        } else {
            assert (keyField != null) : "Should have a key field at this point!";
            if (count > 1) {
                result = ValueFieldCompositeObject.createForValue(aKey, keyFieldResolver);
            } else {
                ValueOperand<?> operand = this.getSingleValueOperand(count, token1, parentField.getFieldName(), aKey);
                Object value = this.getValueFromOperand(operand);
                if (value == null) {
                    result = ValueFieldCompositeObject.createForValue(aKey, keyFieldResolver);
                } else {
                    String valueString = keyFieldResolver.makeValueString(value);
                    result = ValueFieldCompositeObject.createForValue(valueString, keyFieldResolver);
                }
            }
        }
        return result;
    }

    private Object getValueFromOperand(ValueOperand<?> operand) {
        Object value;
        try {
            value = operand.getValue(null);
        }
        catch (IllegalArgumentException ex) {
            value = null;
        }
        return value;
    }

    private ValueOperand<?> getSingleValueOperand(int count, ExpressionToken token1, String fieldName, String aKey) throws ParseException {
        if (count != 1 || !(token1 instanceof ValueOperand)) {
            String msg = String.format("Invalid expression-based key/index for field %s: %s", fieldName, aKey);
            throw new ParseException(msg);
        }
        return (ValueOperand)token1;
    }

    private ValueResolver createResolverForKeyField(FieldDefinition parentField, FieldDefinition keyField) {
        ValueResolver keyFieldResolver = keyField != null ? FieldDefinitionUtil.createValueResolver(null, keyField) : (parentField.isArray() ? DataType.INTEGER : DataType.STRING);
        return keyFieldResolver;
    }

    protected FieldDefinition findFieldByName(String fieldName) {
        if (this.myRepository == null) {
            throw new IllegalStateException("Cannot lookup fields, the ClassRepository is not set");
        }
        return this.myRepository.getFieldDefinitionByName(fieldName);
    }

    protected abstract Operand createFieldOperand(FieldDefinition var1, ValueFieldCompositeObject var2);
}

