/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.expression.parser;

import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionException;
import com.ericsson.ere.expression.parser.DefaultExpressionParserHandler;
import com.ericsson.ere.expression.parser.DefaultExpressionParserOptions;
import com.ericsson.ere.expression.parser.ExpressionParserHandler;
import com.ericsson.ere.expression.parser.ExpressionParserOptions;
import com.ericsson.ere.expression.parser.ParseException;
import com.ericsson.ere.expression.parser.PrivExpressionParser;
import com.ericsson.ere.selectiontree.modifiers.mfo.ResolvingInfixExpressionFormatter;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import java.io.StringReader;
import java.util.Map;

public class ExpressionParser {
    public static final String BOE_MARKER = ":::";
    private final ExpressionParserOptions myParserOptions;
    private final ExpressionParserHandler myHandler;

    public ExpressionParser(ExpressionParserOptions options, ExpressionParserHandler handler) {
        if (options == null || handler == null) {
            throw new IllegalArgumentException("Null argument not permitted.");
        }
        this.myParserOptions = options;
        this.myHandler = handler;
    }

    public static String escapeString(String str) {
        return PrivExpressionParser.escapeString(str);
    }

    public static String escapeFieldName(String str) {
        return PrivExpressionParser.escapeFieldName(str);
    }

    public static String escapeIndexSpec(String str) {
        return PrivExpressionParser.escapeIndexSpec(str);
    }

    public Expression parse(String expr) {
        if (expr == null) {
            throw new IllegalArgumentException("Null expression not permitted.");
        }
        String estr = expr;
        if (estr.startsWith(BOE_MARKER)) {
            estr = estr.substring(BOE_MARKER.length());
        }
        PrivExpressionParser parser = new PrivExpressionParser(new StringReader(estr));
        parser.configure(this.myParserOptions, this.myHandler);
        try {
            return parser.parse();
        }
        catch (ParseException ex) {
            throw (ExpressionException)new ExpressionException("Failed to parse expression (" + ex.getMessage() + ").").initCause(ex);
        }
    }

    public static String replaceDateConstants(FieldDefinition field, String expressionString) {
        String ret = expressionString;
        if (field != null && (field.getTypedDataType() == DataType.DATE || field.getTypedDataType() == DataType.TIME)) {
            Map<String, String> settings = field.getFieldSettings();
            String bot = settings.get("BeginningOfTimeLabel");
            String eot = settings.get("EndOfTimeLabel");
            if (bot != null) {
                ret = ret.replace("BOT", bot);
            }
            if (eot != null) {
                ret = ret.replace("EOT", eot);
            }
        }
        return ret;
    }

    public static String convertExpressionToDisplayableString(String anExpression, ClassRepository aRep) {
        String ret;
        if (anExpression == null || anExpression.length() == 0) {
            ret = "";
        } else {
            ExpressionParser parser = new ExpressionParser(new DefaultExpressionParserOptions(), new DefaultExpressionParserHandler(aRep, null));
            try {
                Expression expr = parser.parse(anExpression);
                ret = ResolvingInfixExpressionFormatter.format(expr, aRep.getDataSetFactory().createDataSet(), ResolvingInfixExpressionFormatter.ResolutionLevel.NONE);
            }
            catch (Exception ex) {
                ret = "<Error in expression: " + ex.getMessage() + ">";
            }
        }
        return ret;
    }
}

