/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.functioncontrol;

import com.ericsson.ere.proxy.AbstractEreProxy;

public final class FunctionContext {
    private final AbstractEreProxy myProxy;
    private final int myAmountThreshold;
    private final String mySelectionTreePath;

    public static Builder build() {
        return new Builder();
    }

    public static FunctionContext createEmptyContext() {
        return FunctionContext.build().get();
    }

    @Deprecated
    public static FunctionContext createFunctionCtxFromProxy(AbstractEreProxy proxy) throws IllegalArgumentException {
        return FunctionContext.build().withProxy(proxy).get();
    }

    @Deprecated
    public static FunctionContext createFunctionCtxFromAmountProxyAndTree(int amountThreshold, AbstractEreProxy proxy, String pathInSelectionTree) throws IllegalArgumentException {
        return FunctionContext.build().withAmount(amountThreshold).withProxy(proxy).withSelectionTreePath(pathInSelectionTree).get();
    }

    private FunctionContext(int amountThreshold, AbstractEreProxy proxy, String pathInSelectionTree) {
        this.myAmountThreshold = amountThreshold;
        this.myProxy = proxy;
        this.mySelectionTreePath = pathInSelectionTree;
    }

    public AbstractEreProxy getProxy() {
        return this.myProxy;
    }

    public int getAmountThreshold() {
        return this.myAmountThreshold;
    }

    public String getSelectionTreePath() {
        return this.mySelectionTreePath;
    }

    public static class Builder {
        private AbstractEreProxy proxy;
        private int amount;
        private String path;

        private Builder() {
        }

        public Builder withProxy(AbstractEreProxy proxy) {
            if (proxy == null) {
                throw new IllegalArgumentException("Proxy must be non-null.");
            }
            this.proxy = proxy;
            return this;
        }

        public Builder withAmount(int amount) {
            this.amount = amount;
            return this;
        }

        public Builder withSelectionTreePath(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Path must be non-null.");
            }
            this.path = path;
            return this;
        }

        public FunctionContext get() {
            return new FunctionContext(this.amount, this.proxy, this.path);
        }
    }
}

