/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.functioncontrol;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionController;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.functioncontrol.LegacyFunctionController;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.util.ResourceUtil;
import ericsson.ere.integration.connector.EreConnector;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class FunctionManagerImpl
implements FunctionManager {
    private static FunctionManager INSTANCE = new FunctionManagerImpl();
    private Map<Integer, FunctionController> myFunctionControllers = new HashMap<Integer, FunctionController>();
    private Properties myDefaultFunctionStates = null;
    private static final String DEFAULT_PROPERTY_FILE = "/config/functioncontroll.default.properties";
    private FunctionController myLegacyFunctionController = new LegacyFunctionController();

    public static FunctionManager getInstance() {
        return INSTANCE;
    }

    private FunctionManagerImpl() {
    }

    private void verifyDefaultStateForAllFunctions() throws IllegalStateException {
        for (FunctionToken token : FunctionToken.values()) {
            if (this.myDefaultFunctionStates.getProperty(token.getName()) != null) continue;
            String msg = String.format("The token %s matched by property '%s' could not be located in the %s file.", new Object[]{token, token.getName(), DEFAULT_PROPERTY_FILE});
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void registerFunctionController(EreConnector connector, FunctionController controller) {
        int connectorIdentity = System.identityHashCode(connector);
        this.myFunctionControllers.put(connectorIdentity, controller);
    }

    @Override
    public FunctionState getStateForFunction(FunctionToken token, FunctionContext ctx) {
        int connectorIdentity = ctx.getProxy().getEreProxy().getConnectorIdentity();
        FunctionController ctrl = this.myFunctionControllers.get(connectorIdentity);
        FunctionState state = null;
        if (ctrl != null) {
            state = ctrl.getStateForFunction(token, ctx);
        }
        if (state == null) {
            state = this.myLegacyFunctionController.getStateForFunction(token, ctx);
        }
        if (state == null) {
            state = FunctionState.createFunctionState(this.getDefaultState(token, ctx));
        }
        return state;
    }

    private FunctionState.State getDefaultState(FunctionToken token, FunctionContext ctx) {
        if (this.myDefaultFunctionStates == null) {
            this.loadDefaultFunctionStates();
            this.verifyDefaultStateForAllFunctions();
        }
        FunctionState.State state = null;
        String propertyValue = this.myDefaultFunctionStates.getProperty(token.getName());
        state = "on".equalsIgnoreCase(propertyValue) ? FunctionState.State.ON : FunctionState.State.OFF;
        return state;
    }

    private void loadDefaultFunctionStates() {
        try {
            this.myDefaultFunctionStates = new Properties();
            URL resourceURL = ResourceUtil.getResourceFromClassCodeSource(this.getClass(), DEFAULT_PROPERTY_FILE);
            InputStream is = resourceURL.openStream();
            this.myDefaultFunctionStates.load(is);
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "functioncontrol", 1, "Failed to read /config/functioncontroll.default.properties", false);
        }
    }
}

