/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffTree;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.awt.Color;
import java.util.List;
import javax.swing.tree.TreePath;

public abstract class DiffPoint
implements Comparable<DiffPoint> {
    public static final int ACTION_USE_NONE = 0;
    public static final int ACTION_USE_LOCAL = 1;
    public static final int ACTION_USE_REMOTE = 2;
    public static final int ACTION_USE_BOTH = 3;
    protected TreePath myLocalPath;
    protected TreePath myRemotePath;
    protected int myAction;

    public DiffPoint(TreePath localPath, TreePath remotePath) {
        this.myLocalPath = localPath;
        this.myRemotePath = remotePath;
    }

    public TreePath getLocalPath() {
        return this.myLocalPath;
    }

    public TreePath getRemotePath() {
        return this.myRemotePath;
    }

    public void setAction(int action) {
        this.myAction = action;
    }

    public int getAction() {
        return this.myAction;
    }

    public static void initActions(List<DiffPoint> diffPoints, int action) {
        for (int i = 0; i < diffPoints.size(); ++i) {
            diffPoints.get(i).setAction(action);
        }
    }

    public abstract String getDiffDescription(boolean var1);

    public abstract String getDiffActionDescription(boolean var1);

    public abstract String getLocalActionDescription(boolean var1);

    public abstract String getRemoteActionDescription(boolean var1);

    public abstract boolean isBothActionsAllowed();

    public abstract boolean isNoActionsAllowed();

    public String toString() {
        return this.getDiffDescription(false);
    }

    public abstract int getDiffPriority();

    public abstract Color getDiffColor();

    public static String getNodeTypeString(TariffDAGNode node) {
        switch (DiffTree.getNodeType(node)) {
            case 0: {
                return "Tariff Structure";
            }
            case 1: {
                return "Node";
            }
            case 2: {
                return "Condition";
            }
            case 3: {
                return "Modifier";
            }
            case 4: {
                return "Link";
            }
            case 5: {
                return "Defs Node";
            }
        }
        return null;
    }

    @Override
    public int compareTo(DiffPoint diff2) {
        TreePath local1 = this.getLocalPath();
        TreePath local2 = diff2.getLocalPath();
        int pathCount1 = local1.getPathCount();
        int pathCount2 = local2.getPathCount();
        if (pathCount1 != 1 && pathCount2 != 1) {
            for (int i = 0; i < pathCount1 && i < pathCount2; ++i) {
                if (local1.getPathComponent(i) == local2.getPathComponent(i)) continue;
                TariffDAGNode node1 = (TariffDAGNode)local1.getPathComponent(i);
                TariffDAGNode node2 = (TariffDAGNode)local2.getPathComponent(i);
                TariffDAGNode parent1 = (TariffDAGNode)node1.getParent();
                TariffDAGNode parent2 = (TariffDAGNode)node2.getParent();
                Integer index1 = new Integer(parent1.getIndexOfChild(node1));
                Integer index2 = new Integer(parent2.getIndexOfChild(node2));
                return index1.compareTo(index2);
            }
        }
        return new Integer(pathCount1).compareTo(new Integer(pathCount2));
    }
}

