/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffPoint;
import com.ericsson.ere.gui.diff.Match;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.awt.Color;
import java.util.List;
import javax.swing.tree.TreePath;

public class DiffPointChildOrder
extends DiffPoint {
    private List<Match> myChildMatches;
    public static final Color MY_COLOR = new Color(186, 162, 103);

    public DiffPointChildOrder(TreePath localPath, TreePath remotePath, List<Match> matches) {
        super(localPath, remotePath);
        this.myChildMatches = matches;
    }

    @Override
    public String getDiffDescription(boolean useLocalAndRemoteNames) {
        String firstName = useLocalAndRemoteNames ? "local" : "first";
        String secondName = useLocalAndRemoteNames ? "remote" : "second";
        String description = "There is a difference between";
        TariffDAGNode n1 = (TariffDAGNode)this.myLocalPath.getLastPathComponent();
        TariffDAGNode n2 = (TariffDAGNode)this.myRemotePath.getLastPathComponent();
        description = description + " the " + firstName + " " + DiffPointChildOrder.getNodeTypeString(n1) + " \"" + n1.getNodeName() + "\" and the " + secondName + " " + DiffPointChildOrder.getNodeTypeString(n2) + " \"" + n2.getNodeName() + "\".";
        description = description + "\n\n- The order of their children differs.";
        return description;
    }

    @Override
    public String getDiffActionDescription(boolean useLocalAndRemoteNames) {
        TariffDAGNode n1 = (TariffDAGNode)this.myLocalPath.getLastPathComponent();
        return "\n\nWhich " + DiffPointChildOrder.getNodeTypeString(n1) + "s child order shall be used in the Result Tree?";
    }

    @Override
    public String getLocalActionDescription(boolean useLocalAndRemoteNames) {
        String firstName = useLocalAndRemoteNames ? "local" : "first";
        return "The " + firstName;
    }

    @Override
    public String getRemoteActionDescription(boolean useLocalAndRemoteNames) {
        String secondName = useLocalAndRemoteNames ? "remote" : "second";
        return "The " + secondName;
    }

    @Override
    public boolean isBothActionsAllowed() {
        return false;
    }

    @Override
    public boolean isNoActionsAllowed() {
        return false;
    }

    @Override
    public int getDiffPriority() {
        return 2;
    }

    @Override
    public Color getDiffColor() {
        return MY_COLOR;
    }

    public List<Match> getMatches() {
        return this.myChildMatches;
    }
}

