/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.exportmanager.ExportFailedException;
import com.ericsson.ere.gui.diff.DiffProgressDialog;
import com.ericsson.ere.gui.diff.DiffTree;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.Version;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.FileFilterImpl;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiffSave
extends JDialog {
    public static final int DIALOG_WIDTH = 480;
    public static final int DIALOG_HEIGHT = 300;
    private static final String BACKUP_PREFIX = "Backup_RMA_RatingPeriod_";
    private int myResult = 1;
    private DiffTree myResultTree;
    private RatingPeriodProxy myFirstPeriod;
    private RatingPeriodProxy mySecondPeriod;
    private DiffTree myFirstTree;
    private DiffTree mySecondTree;
    private JFileChooser exportFileChooser = new JFileChooser();
    private File exportDestination = null;
    private JFileChooser backupFileChooser = new JFileChooser();
    private File backupDestination = null;
    private JRadioButton exportButton;
    private JRadioButton overwriteButton;
    private JCheckBox firstBox;
    private JCheckBox secondBox;
    private JCheckBox backupBox;
    private boolean[] mySaveDestinationTrees = null;
    public static final int SAVE_SUCCESS = 0;
    public static final int SAVE_FAILED = 1;
    public static final int SAVE_CONFLICT = 2;

    public DiffSave(Point location, DiffTree resultTree, RatingPeriodProxy firstPeriod, DiffTree firstTree, RatingPeriodProxy secondPeriod, DiffTree secondTree, boolean[] saveDestinationTrees) {
        super((Frame)null, "Selection Tree Difference Detection Tool", true);
        this.setLocation(location);
        this.myResultTree = resultTree;
        this.myFirstPeriod = firstPeriod;
        this.myFirstTree = firstTree;
        this.mySecondPeriod = secondPeriod;
        this.mySecondTree = secondTree;
        this.mySaveDestinationTrees = saveDestinationTrees;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        JLabel iconLabel = new JLabel(RmaDefs.getImageIcon("dialog_question.gif"));
        JLabel saveLabel = new JLabel("Do you want to export the result tree to file or,");
        JLabel saveLabel2 = new JLabel("overwrite one/both of the input Rating Periods?");
        this.exportButton = new JRadioButton("Export the result tree");
        this.exportButton.setName("DiffSave.JRadioButton.Export");
        final JButton exportBrowseButton = new JButton("Browse...");
        exportBrowseButton.setName("DiffSave.JButton.Export.Browse");
        this.overwriteButton = new JRadioButton("Overwrite the given rating periods");
        this.overwriteButton.setName("DiffSave.JRadioButton.Overwrite");
        this.firstBox = new JCheckBox("Overwrite the first Rating period (" + this.myFirstPeriod.getName() + ")");
        this.firstBox.setName("DiffSave.JCheckBox.First");
        this.secondBox = new JCheckBox("Overwrite the second Rating period (" + this.mySecondPeriod.getName() + ")");
        this.secondBox.setName("DiffSave.JCheckBox.Second");
        this.backupBox = new JCheckBox("Select a backup folder for the overwritten period(s)");
        this.backupBox.setName("DiffSave.JCheckBox.Backup");
        final JButton backupBrowseButton = new JButton("Browse...");
        backupBrowseButton.setName("DiffSave.JButton.BackupBrowse");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("DiffSave.JButton.Cancel");
        JButton saveButton = new JButton("Save");
        saveButton.setName("DiffSave.JButton.Save");
        saveButton.setIcon(RmaDefs.getImageIcon("disk_blue16.png"));
        FileNameExtensionFilter filter = new FileNameExtensionFilter("XML Files", "xml");
        this.exportFileChooser.setFileFilter(filter);
        this.exportFileChooser.setName("DiffSave.JFileChooser.ExportFile");
        this.exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DiffSave.this.exportButton.isSelected()) {
                    DiffSave.this.overwriteButton.setSelected(!DiffSave.this.exportButton.isSelected());
                    exportBrowseButton.setEnabled(DiffSave.this.exportButton.isSelected());
                    DiffSave.this.firstBox.setEnabled(!DiffSave.this.exportButton.isSelected());
                    DiffSave.this.secondBox.setEnabled(!DiffSave.this.exportButton.isSelected());
                    DiffSave.this.backupBox.setEnabled(!DiffSave.this.exportButton.isSelected());
                    backupBrowseButton.setEnabled(!DiffSave.this.exportButton.isSelected());
                } else {
                    DiffSave.this.exportButton.setSelected(true);
                }
            }
        });
        this.overwriteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DiffSave.this.overwriteButton.isSelected()) {
                    DiffSave.this.exportButton.setSelected(!DiffSave.this.overwriteButton.isSelected());
                    exportBrowseButton.setEnabled(DiffSave.this.exportButton.isSelected());
                    DiffSave.this.firstBox.setEnabled(!DiffSave.this.exportButton.isSelected());
                    DiffSave.this.secondBox.setEnabled(!DiffSave.this.exportButton.isSelected());
                    DiffSave.this.backupBox.setEnabled(!DiffSave.this.exportButton.isSelected());
                    backupBrowseButton.setEnabled(!DiffSave.this.exportButton.isSelected() && DiffSave.this.backupBox.isSelected());
                } else {
                    DiffSave.this.overwriteButton.setSelected(true);
                }
            }
        });
        exportBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (DiffSave.this.exportFileChooser.showSaveDialog(DiffSave.this.getThis()) == 0) {
                    if (!DiffSave.this.exportFileChooser.getFileFilter().accept(DiffSave.this.exportFileChooser.getSelectedFile())) {
                        DiffSave.this.exportDestination = new File(DiffSave.this.exportFileChooser.getSelectedFile().getAbsoluteFile() + ".xml");
                    } else {
                        DiffSave.this.exportDestination = DiffSave.this.exportFileChooser.getSelectedFile();
                    }
                    String fileName = DiffSave.this.exportDestination.getPath().substring(DiffSave.this.exportDestination.getPath().lastIndexOf(File.separator) + 1, DiffSave.this.exportDestination.getPath().length());
                    DiffSave.this.exportButton.setText("Export the result tree to " + fileName);
                }
            }
        });
        this.backupBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                backupBrowseButton.setEnabled(DiffSave.this.backupBox.isSelected());
            }
        });
        backupBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DiffSave.this.backupFileChooser.setFileSelectionMode(1);
                if (DiffSave.this.backupFileChooser.showSaveDialog(DiffSave.this.getThis()) == 0) {
                    DiffSave.this.backupDestination = DiffSave.this.backupFileChooser.getSelectedFile();
                    if (!DiffSave.this.backupDestination.canRead()) {
                        DialogFactory.getErrorDialog("RMA", "The destination of the backup period(s) must be a folder.");
                        DiffSave.this.backupDestination = null;
                    }
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DiffSave.this.myResult = 1;
                DiffSave.this.dispose();
            }
        });
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DiffSave.this.myResult = 0;
                ((DiffSave)DiffSave.this).mySaveDestinationTrees[0] = DiffSave.this.firstBox.isSelected();
                ((DiffSave)DiffSave.this).mySaveDestinationTrees[1] = DiffSave.this.secondBox.isSelected();
                if (DiffSave.this.overwriteButton.isSelected() && !DiffSave.this.firstBox.isSelected() && !DiffSave.this.secondBox.isSelected()) {
                    DialogFactory.getInformationDialog(DiffSave.this.getThis(), "RMA", "You must select either the first or the second Rating period to be overwritten.");
                    return;
                }
                if (DiffSave.this.save()) {
                    DiffSave.this.setVisible(false);
                }
            }
        });
        this.overwriteButton.setSelected(true);
        exportBrowseButton.setEnabled(false);
        backupBrowseButton.setEnabled(false);
        JPanel outerPanel = new JPanel(new GridBagLayout());
        outerPanel.setBorder(BorderFactory.createBevelBorder(0));
        JPanel overwritePanel = new JPanel(new GridBagLayout());
        overwritePanel.setBorder(BorderFactory.createEtchedBorder());
        overwritePanel.add((Component)this.firstBox, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(15, 15, 0, 0), 0, 0));
        overwritePanel.add((Component)this.secondBox, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        overwritePanel.add((Component)this.backupBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(15, 15, 0, 0), 0, 0));
        overwritePanel.add((Component)backupBrowseButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 12, 0, new Insets(15, 0, 0, 10), 0, 0));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 3, new Insets(5, 0, 5, 0), 0, 0));
        buttonPanel.add((Component)saveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 10, 5, 5), 0, 0));
        JPanel savePanel = new JPanel(new GridBagLayout());
        savePanel.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(12, 10, 15, 0), 0, 0));
        savePanel.add((Component)saveLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        savePanel.add((Component)saveLabel2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 15, 0), 0, 0));
        outerPanel.add((Component)savePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        outerPanel.add((Component)this.exportButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 0), 0, 0));
        outerPanel.add((Component)exportBrowseButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 16), 0, 0));
        outerPanel.add((Component)this.overwriteButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 10, 0, 0), 0, 0));
        outerPanel.add((Component)overwritePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(11, 5, 5, 5), 0, 0));
        this.add((Component)outerPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setSize(480, 300);
        this.setResizable(false);
        this.setVisible(true);
    }

    public static int save(Component owner, DiffTree resultTree, RatingPeriodProxy firstPeriod, DiffTree firstTree, RatingPeriodProxy secondPeriod, DiffTree secondTree, boolean[] saveDestinationTrees) {
        JFrame f = GuiServiceCenter.getInstance().getMainWindow();
        JDesktopPane d = GuiServiceCenter.getInstance().getDesktopPane();
        int mainX = f.getX() + d.getX();
        int mainY = f.getY() + d.getY();
        Point p = new Point(mainX + owner.getX() + owner.getWidth() / 2 - 240, mainY + owner.getY() + owner.getHeight() / 2 - 150);
        if (saveDestinationTrees == null || saveDestinationTrees.length != 2) {
            throw new IllegalArgumentException("The parameter saveDestinationTrees should have the length 2.");
        }
        DiffSave dialog = new DiffSave(p, resultTree, firstPeriod, firstTree, secondPeriod, secondTree, saveDestinationTrees);
        return dialog.myResult;
    }

    public static int save(final SelectionTree selectionTree, final RatingPeriodProxy proxy, final DiffTree resultTree, final DiffTree backupTree, boolean saveBackup) {
        try {
            if (saveBackup && DialogFactory.getQuestionDialogCustomButtons(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "Would you like to keep a copy of the remote structure as a backup?", "Yes", "No")) {
                Element remoteStructure = XMLUtil.buildDocumentFromString(DiffTree.getXml(backupTree.getRoot())).getDocumentElement();
                DiffSave.saveAs(remoteStructure);
            }
            Window owner = GuiUtil.getClosestWindowParent(resultTree);
            final DiffProgressDialog progressDialog = DiffProgressDialog.showDialog(owner, "Saving Selection Tree...");
            SwingWorker<Integer, Void> worker = new SwingWorker<Integer, Void>(){

                @Override
                protected Integer doInBackground() throws Exception {
                    try {
                        Version remoteVersion;
                        Element remoteVersionElement;
                        long newVersion = backupTree.getRoot().getVersion().getVersion() + 1L;
                        resultTree.getRoot().updateLastModifiedDate();
                        resultTree.getRoot().getVersion().setVersion(newVersion);
                        Document tDoc = XMLUtil.buildDocumentFromString(DiffTree.getXml(resultTree.getRoot()));
                        Element remoteTree = proxy.getRatingPeriodRuleTree();
                        if (!"TariffStructure".equals(remoteTree.getNodeName())) {
                            remoteTree = XMLUtil.getNamedElement("TariffStructure", remoteTree.getElementsByTagName("TariffStructure"));
                        }
                        if ((remoteVersionElement = XMLUtil.getNamedElement("Version", remoteTree.getChildNodes())) != null && (remoteVersion = Version.create(remoteVersionElement, null)).getVersion() >= newVersion) {
                            return 2;
                        }
                        proxy.updateRatingPeriodRuleTree(tDoc.getDocumentElement());
                        selectionTree.getVersion().setVersion(newVersion);
                        selectionTree.resetModified();
                        return 0;
                    }
                    catch (EreCommunicationException e) {
                        ExceptionUtil.handleException(e, "diffTool", 1, "There was an error trying to save the result tree!", true);
                        return 1;
                    }
                }

                @Override
                protected void done() {
                    progressDialog.setVisible(false);
                    super.done();
                }
            };
            worker.execute();
            progressDialog.setVisible(true);
            int result = (Integer)worker.get();
            return result;
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "diffTool", 1, "There was an error trying to save the result tree!", true);
            return 1;
        }
    }

    private boolean save() {
        final DiffProgressDialog progressDialog = DiffProgressDialog.showDialog(this, "Saving Selection Tree...");
        SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            protected Boolean doInBackground() throws Exception {
                DiffSave.this.myResultTree.getRoot().setVersion(new Version(DiffSave.this.myResultTree.getRoot()));
                Element treeElement = XMLUtil.buildDocumentFromString(DiffTree.getXml(DiffSave.this.myResultTree.getRoot())).getDocumentElement();
                if (DiffSave.this.exportButton.isSelected()) {
                    if (DiffSave.this.exportDestination == null) {
                        DialogFactory.getInformationDialog(DiffSave.this.getThis(), "RMA", "You must a select a destination to which the result tree will be saved.");
                        return false;
                    }
                    DiffSave.doExport(treeElement, DiffSave.this.exportDestination);
                } else if (DiffSave.this.overwriteButton.isSelected()) {
                    if (DiffSave.this.firstBox.isSelected()) {
                        DiffSave.this.myFirstPeriod.updateRatingPeriodRuleTree(treeElement);
                        if (DiffSave.this.backupBox.isSelected()) {
                            if (DiffSave.this.backupDestination == null) {
                                DialogFactory.getInformationDialog(DiffSave.this.getThis(), "RMA", "You must a select a destination to which the backup will be saved.");
                                return false;
                            }
                            File firstPeriodFile = new File(DiffSave.this.backupDestination.getPath() + File.separator + DiffSave.BACKUP_PREFIX + DiffSave.this.myFirstPeriod.getName() + ".xml");
                            FileHandling.writeToFile(DiffTree.getXml(DiffSave.this.myFirstTree.getRoot()), firstPeriodFile);
                        }
                    }
                    if (DiffSave.this.secondBox.isSelected()) {
                        DiffSave.this.mySecondPeriod.updateRatingPeriodRuleTree(treeElement);
                        if (DiffSave.this.backupBox.isSelected()) {
                            if (DiffSave.this.backupDestination == null) {
                                DialogFactory.getInformationDialog(DiffSave.this.getThis(), "RMA", "You must a select a destination to which the backup will be saved.");
                                return false;
                            }
                            File secondPeriodFile = new File(DiffSave.this.backupDestination.getPath() + File.separator + DiffSave.BACKUP_PREFIX + DiffSave.this.mySecondPeriod.getName() + ".xml");
                            FileHandling.writeToFile(DiffTree.getXml(DiffSave.this.mySecondTree.getRoot()), secondPeriodFile);
                        }
                    }
                }
                DialogFactory.getInformationDialog(DiffSave.this.getThis(), "RMA", "The result tree was successfully saved.");
                return true;
            }

            @Override
            protected void done() {
                progressDialog.setVisible(false);
                super.done();
            }
        };
        worker.execute();
        progressDialog.setVisible(true);
        try {
            return (Boolean)worker.get();
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "diffTool", 1, "There was an error trying to save the backup!", true);
            return false;
        }
    }

    private static void saveAs(Element elementToSave) {
        int returnVal;
        JFileChooser myFileChooser = new JFileChooser();
        myFileChooser.setDialogTitle("Save As");
        int dialogAnswer = 2;
        while ((returnVal = myFileChooser.showSaveDialog(null)) == 0) {
            File dest = myFileChooser.getSelectedFile();
            dialogAnswer = 0;
            if (dest.exists()) {
                dialogAnswer = DialogFactory.getQuestionDialogWithCancel(null, "File exists", "The file '" + dest.getPath() + "' exists, overwrite existing file?");
            }
            if (dialogAnswer != 2) {
                try {
                    if (dialogAnswer == 0) {
                        if (myFileChooser.getFileFilter() instanceof FileFilterImpl) {
                            FileFilterImpl fileFilter = (FileFilterImpl)myFileChooser.getFileFilter();
                            dest = fileFilter.addExtensionToFileName(myFileChooser, dest);
                        }
                        try {
                            DiffSave.doExport(elementToSave, dest);
                        }
                        catch (Exception e) {
                            ExceptionUtil.handleException(e, "diffTool", 1, "Failed to save to file " + dest.getPath(), true);
                        }
                    }
                }
                catch (Exception e) {
                    ExceptionUtil.handleException(e, "diffTool", 1, "Failed exporting tariff to file " + dest.getPath(), true);
                }
            }
            if (dialogAnswer == 2) continue;
        }
    }

    private static void doExport(Element selectionTreeElement, File exportFile) throws ExportFailedException {
        try {
            PrintWriter printer = new PrintWriter(exportFile, "UTF-8");
            DomWriter.nodeToWriter(selectionTreeElement, printer, true, true);
            printer.flush();
            printer.close();
        }
        catch (FileNotFoundException ex) {
            ExceptionUtil.handleException(ex, "diffTool", 2, "Failed to export selection tree. Could not find specified file.", true);
        }
        catch (UnsupportedEncodingException ex) {
            ExceptionUtil.handleException(ex, "diffTool", 2, "Failed to export selection tree", true);
        }
    }

    private DiffSave getThis() {
        return this;
    }
}

