/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffPoint;
import com.ericsson.ere.gui.diff.DiffPointChildOrder;
import com.ericsson.ere.gui.diff.DiffPointMissingChild;
import com.ericsson.ere.gui.diff.DiffPointVariables;
import com.ericsson.ere.gui.diff.DiffTree;
import com.ericsson.ere.gui.diff.Match;
import com.ericsson.ere.gui.diff.NodeIndexComparator;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.VariableUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Node;

public class DiffToolAnalyzer {
    private DiffTree myLocalTree;
    private DiffTree myRemoteTree;
    private List<DiffPoint> myDiffPoints = new ArrayList<DiffPoint>();

    public List<DiffPoint> doAnalyze(DiffTree localTree, DiffTree remoteTree) {
        this.myLocalTree = localTree;
        this.myRemoteTree = remoteTree;
        this.enterTariffStructure(this.myLocalTree.getRoot(), this.myRemoteTree.getRoot());
        return this.getDiffPoints();
    }

    private void enterTariffStructure(TSTariffStructure localStructure, TSTariffStructure remoteStructure) {
        if (!this.configIsEqual(localStructure, remoteStructure)) {
            this.compareVariables(localStructure, remoteStructure);
            List<Match> bestMatches = this.getBestMatchesAmongChildren(localStructure, remoteStructure);
            if (!this.compareOrder(bestMatches)) {
                this.addDiffPointChildOrder(localStructure, remoteStructure, bestMatches);
            }
            for (int i = 0; i < bestMatches.size(); ++i) {
                Match match = bestMatches.get(i);
                TariffDAGNode localNode = match.getLocalNode();
                TariffDAGNode remoteNode = match.getRemoteNode();
                if (localNode instanceof TSNode) {
                    this.enterNode((TSNode)localNode, (TSNode)remoteNode);
                    continue;
                }
                if (!(match.getLocalNode() instanceof TSLink)) continue;
                this.enterLink((TSLink)localNode, (TSLink)remoteNode);
            }
            this.addNewElementDiffPoints(localStructure, remoteStructure, bestMatches);
        }
    }

    private void enterNode(TSNode localTSNode, TSNode remoteTSNode) {
        if (!this.configIsEqual(localTSNode, remoteTSNode)) {
            this.compareVariables(localTSNode, remoteTSNode);
            List<Match> bestMatches = this.getBestMatchesAmongChildren(localTSNode, remoteTSNode);
            if (!this.compareOrder(bestMatches)) {
                this.addDiffPointChildOrder(localTSNode, remoteTSNode, bestMatches);
            }
            for (int i = 0; i < bestMatches.size(); ++i) {
                Match match = bestMatches.get(i);
                TariffDAGNode localNode = match.getLocalNode();
                TariffDAGNode remoteNode = match.getRemoteNode();
                if (localNode instanceof TSNode) {
                    this.enterNode((TSNode)localNode, (TSNode)remoteNode);
                    continue;
                }
                if (localNode instanceof TSCondition) {
                    this.enterCondition((TSCondition)localNode, (TSCondition)remoteNode);
                    continue;
                }
                if (localNode instanceof TSModifier) {
                    this.enterModifier((TSModifier)localNode, (TSModifier)remoteNode);
                    continue;
                }
                if (!(localNode instanceof TSLink)) continue;
                this.enterLink((TSLink)localNode, (TSLink)remoteNode);
            }
            this.addNewElementDiffPoints(localTSNode, remoteTSNode, bestMatches);
        }
    }

    private void enterCondition(TSCondition localCondition, TSCondition remoteCondition) {
        if (!this.configIsEqual(localCondition, remoteCondition)) {
            this.compareVariables(localCondition, remoteCondition);
            List<Match> bestMatches = this.getBestMatchesAmongChildren(localCondition, remoteCondition);
            if (!this.compareOrder(bestMatches)) {
                this.addDiffPointChildOrder(localCondition, remoteCondition, bestMatches);
            }
            for (int i = 0; i < bestMatches.size(); ++i) {
                Match match = bestMatches.get(i);
                TariffDAGNode localNode = match.getLocalNode();
                TariffDAGNode remoteNode = match.getRemoteNode();
                if (localNode instanceof TSCondition) {
                    this.enterCondition((TSCondition)localNode, (TSCondition)remoteNode);
                    continue;
                }
                if (!(localNode instanceof TSLink)) continue;
                this.enterLink((TSLink)localNode, (TSLink)remoteNode);
            }
            this.addNewElementDiffPoints(localCondition, remoteCondition, bestMatches);
        }
    }

    private void enterModifier(TSModifier localModifier, TSModifier remoteModifier) {
        if (!this.configIsEqual(localModifier, remoteModifier)) {
            this.compareVariables(localModifier, remoteModifier);
        }
    }

    private void enterLink(TSLink localLink, TSLink remoteLink) {
        if (!this.configIsEqual(localLink, remoteLink)) {
            this.compareVariables(localLink, remoteLink);
        }
    }

    private void compareVariables(TariffDAGNode localNode, TariffDAGNode remoteNode) {
        List<Variable> localVars = localNode.getVariablesForEditing(null);
        List<Variable> remoteVars = remoteNode.getVariablesForEditing(null);
        if (localVars.size() != remoteVars.size()) {
            this.addDiffPointVariables(localNode, remoteNode);
        } else {
            for (int i = 0; i < localVars.size(); ++i) {
                Variable remoteVar;
                Variable localVar = localVars.get(i);
                if (localNode instanceof TSTariffStructure && "Version".equals(localVar.getLabel()) || VariableUtil.areVariablesEqual(localVar, remoteVar = remoteVars.get(i))) continue;
                this.addDiffPointVariables(localNode, remoteNode);
                break;
            }
        }
    }

    private boolean configIsEqual(TSElement localNode, TSElement remoteNode) {
        Node localNodeConfig = localNode.state().getXMLConfig();
        Node remoteNodeConfig = remoteNode.state().getXMLConfig();
        return localNodeConfig.isEqualNode(remoteNodeConfig);
    }

    private boolean compareOrder(List<Match> childMatches) {
        ArrayList<TariffDAGNode> localChildren = new ArrayList<TariffDAGNode>();
        ArrayList<TariffDAGNode> remoteChildren = new ArrayList<TariffDAGNode>();
        for (int i = 0; i < childMatches.size(); ++i) {
            Match match = childMatches.get(i);
            localChildren.add(match.getLocalNode());
            remoteChildren.add(match.getRemoteNode());
        }
        NodeIndexComparator comparator = new NodeIndexComparator();
        Collections.sort(localChildren, comparator);
        Collections.sort(remoteChildren, comparator);
        block1: for (int i = 0; i < localChildren.size(); ++i) {
            TariffDAGNode localChild = (TariffDAGNode)localChildren.get(i);
            for (int j = 0; j < childMatches.size(); ++j) {
                if (localChild != childMatches.get(j).getLocalNode()) continue;
                if (localChildren.indexOf(localChild) == remoteChildren.indexOf(childMatches.get(j).getRemoteNode())) continue block1;
                return false;
            }
        }
        return true;
    }

    private List<Match> getBestMatchesAmongChildren(TariffDAGNode localParent, TariffDAGNode remoteParent) {
        Match match;
        ArrayList<Match> allMatches = new ArrayList<Match>(Math.max(localParent.getChildCount(), remoteParent.getChildCount()));
        block0: for (int i = 0; i < localParent.getChildCount(); ++i) {
            TariffDAGNode probableChild;
            TariffDAGNode localChild = (TariffDAGNode)localParent.getChildAt(i);
            boolean matchAlreadyFound = false;
            if (i < remoteParent.getChildCount() && (match = new Match(localChild, probableChild = (TariffDAGNode)remoteParent.getChildAt(i), i, i)).getMatchPriority() == 6) {
                matchAlreadyFound = true;
                allMatches.add(match);
            }
            if (matchAlreadyFound) continue;
            for (int j = 0; j < remoteParent.getChildCount(); ++j) {
                TariffDAGNode remoteChild = (TariffDAGNode)remoteParent.getChildAt(j);
                match = new Match(localChild, remoteChild, i, j);
                if (!match.isSufficient()) continue;
                allMatches.add(match);
                if (match.getMatchPriority() == 6) continue block0;
            }
        }
        Collections.sort(allMatches, Collections.reverseOrder());
        ArrayList<Match> bestMatches = new ArrayList<Match>();
        for (int i = 0; i < allMatches.size(); ++i) {
            match = (Match)allMatches.get(i);
            if (DiffToolAnalyzer.isElementMatched(bestMatches, match.getLocalNode()) || DiffToolAnalyzer.isElementMatched(bestMatches, match.getRemoteNode())) continue;
            bestMatches.add(match);
        }
        return bestMatches;
    }

    private static boolean isElementMatched(List<Match> matchedElements, TariffDAGNode node) {
        boolean isMatched = false;
        for (int i = 0; i < matchedElements.size(); ++i) {
            Match alreadyMatch = matchedElements.get(i);
            if (alreadyMatch.getLocalNode() != node && alreadyMatch.getRemoteNode() != node) continue;
            isMatched = true;
        }
        return isMatched;
    }

    private void addNewElementDiffPoints(TariffDAGNode localNode, TariffDAGNode remoteNode, List<Match> matches) {
        TariffDAGNode element;
        int i;
        for (i = 0; i < localNode.getChildCount(); ++i) {
            element = (TariffDAGNode)localNode.getChildAt(i);
            if (DiffToolAnalyzer.isElementMatched(matches, element)) continue;
            this.addDiffPointMissingChild(localNode, remoteNode, element, true);
        }
        for (i = 0; i < remoteNode.getChildCount(); ++i) {
            element = (TariffDAGNode)remoteNode.getChildAt(i);
            if (DiffToolAnalyzer.isElementMatched(matches, element)) continue;
            this.addDiffPointMissingChild(localNode, remoteNode, element, false);
        }
    }

    private void addDiffPointChildOrder(TariffDAGNode localNode, TariffDAGNode remoteNode, List<Match> matches) {
        DiffPointChildOrder diffPoint = new DiffPointChildOrder(DiffTree.getPath(this.myLocalTree.getRoot(), localNode), DiffTree.getPath(this.myRemoteTree.getRoot(), remoteNode), matches);
        this.myDiffPoints.add(diffPoint);
    }

    private void addDiffPointVariables(TariffDAGNode localNode, TariffDAGNode remoteNode) {
        List<Variable> localVariables = localNode.getVariablesForEditing(null);
        List<Variable> remoteVariables = remoteNode.getVariablesForEditing(null);
        DiffPointVariables diffPoint = new DiffPointVariables(DiffTree.getPath(this.myLocalTree.getRoot(), localNode), DiffTree.getPath(this.myRemoteTree.getRoot(), remoteNode), localVariables, remoteVariables);
        this.myDiffPoints.add(diffPoint);
    }

    private void addDiffPointMissingChild(TariffDAGNode localNode, TariffDAGNode remoteNode, TariffDAGNode newElement, boolean existsInLocal) {
        DiffPointMissingChild diffPoint = new DiffPointMissingChild(DiffTree.getPath(this.myLocalTree.getRoot(), localNode), DiffTree.getPath(this.myRemoteTree.getRoot(), remoteNode), newElement, existsInLocal);
        this.myDiffPoints.add(diffPoint);
    }

    public DiffTree getLocalTree() {
        return this.myLocalTree;
    }

    public DiffTree getRemoteTree() {
        return this.myRemoteTree;
    }

    public List<DiffPoint> getDiffPoints() {
        return this.myDiffPoints;
    }
}

