/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffPoint;
import com.ericsson.ere.gui.diff.DiffPointChildOrder;
import com.ericsson.ere.gui.diff.DiffPointMissingChild;
import com.ericsson.ere.gui.diff.DiffPointVariables;
import com.ericsson.ere.gui.diff.DiffTree;
import com.ericsson.ere.gui.diff.Match;
import com.ericsson.ere.gui.diff.NodeIndexComparator;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.ratingrules.RatingJTreeErrorHandler;
import ericsson.ere.gui.ratingrules.RatingJTreeNodeFactory;
import ericsson.ere.gui.ratingrules.nodes.DefaultLinkIdUpdater;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TSTreeElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.ratingrules.CycleDetectedException;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.ratingrules.UnresolvedLinkTargetException;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public class DiffToolMerger {
    private DiffTree myLocalTree;
    private TSTariffStructure myResultTree;
    private List<DiffPoint> myDiffPoints;
    private HashMap<TariffDAGNode, TreePath> myPathsInResultTree;
    private RatingRuleBuilder myBuilder;

    public DiffToolMerger(ClassRepository rep, String service, DiffTree localTree, List<DiffPoint> diffPoints) {
        RatingJTreeNodeFactory nodeFactory = new RatingJTreeNodeFactory(service, rep);
        RatingJTreeErrorHandler errorHandler = new RatingJTreeErrorHandler();
        this.myBuilder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        this.myLocalTree = localTree;
        this.myDiffPoints = diffPoints;
        try {
            this.restartMerge();
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "diffTool", 1, "Diff Tool couldn't merge the two trees!", true);
        }
    }

    public void tearDown() {
        this.myDiffPoints.clear();
        this.myPathsInResultTree.clear();
    }

    public void restartMerge() {
        try {
            String treeXml = DiffTree.getXml(this.myLocalTree.getRoot());
            this.myResultTree = (TSTariffStructure)this.myBuilder.buildFromString(treeXml);
            this.initResultPaths(this.myDiffPoints);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "diffTool", 1, "Diff Tool couldn't merge the two trees!", true);
        }
    }

    public TreePath doMerge(DiffPoint diff) throws Exception {
        TreePath localPath = diff.getLocalPath();
        TariffDAGNode localNode = (TariffDAGNode)localPath.getLastPathComponent();
        TreePath remotePath = diff.getRemotePath();
        TariffDAGNode remoteNode = (TariffDAGNode)remotePath.getLastPathComponent();
        TreePath resultPath = this.getResultPath(localNode);
        TariffDAGNode resultNode = (TariffDAGNode)resultPath.getLastPathComponent();
        if (diff instanceof DiffPointMissingChild) {
            TariffDAGNode newElement = ((DiffPointMissingChild)diff).getNewElement();
            switch (diff.getAction()) {
                case 1: {
                    if (((DiffPointMissingChild)diff).elementExistsInLocalPath()) {
                        TariffDAGNode newResultNode = this.addNode(resultNode, newElement, localNode);
                        this.myPathsInResultTree.put(newElement, resultPath.pathByAddingChild(newResultNode));
                        break;
                    }
                    TariffDAGNode newResultElement = this.getResultNode(newElement);
                    if (newResultElement != null) {
                        Object[] deletionPath = DiffTree.getPath(this.myResultTree, newResultElement).getPath();
                        if (this.myResultTree.getTreeModel().allowsDelete(deletionPath)) {
                            this.myResultTree.getTreeModel().delete(deletionPath);
                        } else {
                            throw new MergeException("The diff element is not allowed to be deleted!\nHint: There may be links in the tree referring to elements in this part of the tree that has to be deleted first.");
                        }
                    }
                    this.myPathsInResultTree.remove(newElement);
                    break;
                }
                case 2: {
                    if (((DiffPointMissingChild)diff).elementExistsInLocalPath()) {
                        TariffDAGNode newResultElement = this.getResultNode(newElement);
                        Object[] deletionPath = DiffTree.getPath(this.myResultTree, newResultElement).getPath();
                        if (!this.myResultTree.getTreeModel().allowsDelete(deletionPath)) {
                            throw new MergeException("The merge operation is not allowed to be deleted!\nHint: There may be links in the tree referring to elements in this part of the tree that has to be deleted first.");
                        }
                        this.myResultTree.getTreeModel().delete(deletionPath);
                        this.myPathsInResultTree.remove(newElement);
                        break;
                    }
                    TariffDAGNode newResultNode = this.addNode(resultNode, newElement, remoteNode);
                    this.myPathsInResultTree.put(newElement, resultPath.pathByAddingChild(newResultNode));
                }
            }
        } else if (diff instanceof DiffPointChildOrder) {
            List<Match> matches = ((DiffPointChildOrder)diff).getMatches();
            switch (diff.getAction()) {
                case 1: {
                    this.orderChildren(resultNode, matches, true);
                    break;
                }
                case 2: {
                    this.orderChildren(resultNode, matches, false);
                }
            }
        } else if (diff instanceof DiffPointVariables) {
            TariffDAGNode resultParent = null;
            if (resultPath.getParentPath() != null) {
                resultParent = (TariffDAGNode)resultPath.getParentPath().getLastPathComponent();
            }
            switch (diff.getAction()) {
                case 1: {
                    this.updateVariables(resultParent, resultNode, localNode);
                    break;
                }
                case 2: {
                    this.updateVariables(resultParent, resultNode, remoteNode);
                }
            }
        }
        return resultPath;
    }

    private TariffDAGNode addNode(TariffDAGNode parent, TariffDAGNode child, TariffDAGNode oldParent) throws Exception {
        try {
            if (!parent.getAllowsChildren()) {
                throw new MergeException("The merge operation is not allowed!\nThe position where you trying to add a new tree element doesn't allow any children.");
            }
            String newElementXml = DiffTree.getXml(child);
            TariffDAGNode resultElement = (TariffDAGNode)this.myBuilder.buildFromString(newElementXml);
            Object[] newPath = DiffTree.getPath(this.myResultTree, parent).getPath();
            this.myResultTree.getTreeModel().addTariffStrucureNodeAsChild(newPath, resultElement);
            DefaultLinkIdUpdater updater = new DefaultLinkIdUpdater(this.myResultTree.getTreeModel());
            DAGUtil.visitPreorder(this.myResultTree, updater);
            if (oldParent != null) {
                int indexInParent = oldParent.getIndexOfChild(child);
                int newIndex = parent.getIndexOfChild(resultElement);
                newPath = DiffTree.getPath(this.myResultTree, parent).pathByAddingChild(resultElement).getPath();
                for (int i = 0; i < Math.abs(newIndex - indexInParent); ++i) {
                    if (newIndex > indexInParent) {
                        this.myResultTree.getTreeModel().moveUp(newPath);
                        continue;
                    }
                    this.myResultTree.getTreeModel().moveDown(newPath);
                }
            }
            return resultElement;
        }
        catch (CycleDetectedException x) {
            StringBuffer buf = new StringBuffer();
            List<DAGNode> cycle = x.getCyclePath();
            int len = cycle.size();
            for (int i = 0; i < len; ++i) {
                buf.append("/");
                buf.append(((TariffStructureNode)cycle.get(i)).getNodeId());
            }
            throw new MergeException("The merge operation is not allowed!\nThe tree element that you're trying to add creates cycles in the rating structure.\nPasting onto the selected node would create a cycle that looks like:\n" + buf.toString());
        }
        catch (UnresolvedLinkTargetException x) {
            TariffStructureNode node = (TariffStructureNode)x.getContextNode();
            String id = "";
            if (node != null) {
                id = node.getNodeId();
            }
            String unresolvableId = x.getUnresolvable();
            throw new MergeException("The merge operation is not allowed!\nThe tree element that you're trying to add contains links that points to an identified element.\nThe node " + id + " does not contain a child with the id: " + unresolvableId);
        }
    }

    private void updateVariables(TariffDAGNode resultParent, final TariffDAGNode oldNode, final TariffDAGNode newNode) throws Exception {
        String xmlString;
        List<Variable> oldVariables = oldNode.getVariablesForEditing(null);
        List<Variable> newVariables = newNode.getVariablesForEditing(null);
        Object newName = null;
        Variable resultNameVar = null;
        if (oldNode instanceof TSLink) {
            resultNameVar = VarListUtil.getVariableForName(oldVariables, "Target");
            newName = VarListUtil.getVariableForName(newVariables, "Target").getValueObject();
            if (!((String)resultNameVar.getValueObject()).equals(newName)) {
                throw new MergeException("The merge operation is not allowed!\nIt's not allowed to update the target of a link in the diff tool.");
            }
        } else {
            newName = VarListUtil.getVariableForName(newVariables, "Name").getValueObject();
            resultNameVar = VarListUtil.getVariableForName(oldVariables, "Name");
            String newId = (String)VarListUtil.getVariableForName(newVariables, "Id").getValueObject();
            String resultId = (String)VarListUtil.getVariableForName(oldVariables, "Id").getValueObject();
            if (!((String)resultNameVar.getValueObject()).equals(newName) || !resultId.equals(newId)) {
                HashMap<DAGNode, DAGNode> links = new HashMap<DAGNode, DAGNode>();
                DAGUtil.getLinksToTargets(oldNode, links);
                if (links.size() > 0) {
                    throw new MergeException("The merge operation is not allowed!\nThere exists links in the Selection tree element that's is affected by this change.\nThis change has to be done manually.");
                }
            }
        }
        if ((xmlString = EDT.runAndWait(new Callable<String>(){

            @Override
            public String call() throws Exception {
                String xml = null;
                if (oldNode instanceof TSLink) {
                    Map<String, Object> newParameters = ((TSLink)newNode).getParameters();
                    ((TSLink)oldNode).setParameters("Id", newParameters.get("Id"));
                    ((TSLink)oldNode).setParameters("Comment", newParameters.get("Comment"));
                    ((TSLink)oldNode).setParameters("Locked", newParameters.get("Locked"));
                } else if (oldNode instanceof TSTreeElement) {
                    xml = ((TSTreeElement)((Object)newNode)).getXMLConfig();
                }
                return xml;
            }
        })) != null) {
            Element xmlElement = XMLUtil.buildDocumentFromString(xmlString).getDocumentElement();
            oldNode.init(xmlElement, true);
        }
        oldNode.getVariablesForEditing(null);
    }

    private void orderChildren(TariffDAGNode resultParent, List<Match> childMatches, boolean useLocalOrder) {
        ArrayList<TariffDAGNode> localChildren = new ArrayList<TariffDAGNode>();
        ArrayList<TariffDAGNode> remoteChildren = new ArrayList<TariffDAGNode>();
        for (int i = 0; i < childMatches.size(); ++i) {
            Match match = childMatches.get(i);
            localChildren.add(match.getLocalNode());
            remoteChildren.add(match.getRemoteNode());
        }
        NodeIndexComparator comparator = new NodeIndexComparator();
        Collections.sort(localChildren, comparator);
        Collections.sort(remoteChildren, comparator);
        for (int i = 0; i < localChildren.size() - 1; ++i) {
            for (int j = i + 1; j < localChildren.size(); ++j) {
                TariffDAGNode local1 = (TariffDAGNode)localChildren.get(i);
                TariffDAGNode local2 = (TariffDAGNode)localChildren.get(j);
                TariffDAGNode remote1 = this.findMatch(childMatches, local1);
                TariffDAGNode remote2 = this.findMatch(childMatches, local2);
                TariffDAGNode result1 = this.getResultNode(local1);
                TariffDAGNode result2 = this.getResultNode(local2);
                if (useLocalOrder) {
                    if (resultParent.getIndexOfChild(result1) <= resultParent.getIndexOfChild(result2)) continue;
                    this.reOrder(resultParent, result2, result1);
                    continue;
                }
                if (remoteChildren.indexOf(remote1) <= remoteChildren.indexOf(remote2) || resultParent.getIndexOfChild(result1) >= resultParent.getIndexOfChild(result2)) continue;
                this.reOrder(resultParent, result1, result2);
            }
        }
    }

    private TariffDAGNode findMatch(List<Match> matches, TariffDAGNode node) {
        for (int j = 0; j < matches.size(); ++j) {
            TariffDAGNode n1 = matches.get(j).getLocalNode();
            TariffDAGNode n2 = matches.get(j).getRemoteNode();
            if (node == n1) {
                return n2;
            }
            if (node != n2) continue;
            return n1;
        }
        return null;
    }

    private void reOrder(TariffDAGNode parent, TariffDAGNode upper, TariffDAGNode lower) {
        for (int count = 0; parent.getIndexOfChild(upper) < parent.getIndexOfChild(lower) && count < parent.getChildCount(); ++count) {
            parent.moveUp(lower);
        }
    }

    public TreePath getResultPath(TariffDAGNode node) {
        return this.myPathsInResultTree.get(node);
    }

    public TariffDAGNode getResultNode(TariffDAGNode node) {
        TreePath path = this.myPathsInResultTree.get(node);
        if (path != null) {
            return (TariffDAGNode)path.getLastPathComponent();
        }
        return null;
    }

    private void initResultPaths(List<DiffPoint> diffPoints) {
        this.myPathsInResultTree = new HashMap();
        for (int i = 0; i < diffPoints.size(); ++i) {
            DiffPoint diff = diffPoints.get(i);
            TreePath localPath = diff.getLocalPath();
            TreePath remotePath = diff.getRemotePath();
            TariffDAGNode localDiffNode = (TariffDAGNode)localPath.getLastPathComponent();
            TariffDAGNode remoteDiffNode = (TariffDAGNode)remotePath.getLastPathComponent();
            TreePath localPathInResultPath = this.getPathInResultTree(this.myResultTree, localPath);
            this.myPathsInResultTree.put(localDiffNode, localPathInResultPath);
            this.myPathsInResultTree.put(remoteDiffNode, localPathInResultPath);
            if (diff instanceof DiffPointMissingChild) {
                TariffDAGNode newElement = ((DiffPointMissingChild)diff).getNewElement();
                if (!((DiffPointMissingChild)diff).elementExistsInLocalPath()) continue;
                this.myPathsInResultTree.put(newElement, this.getPathInResultTree(this.myResultTree, localPath.pathByAddingChild(newElement)));
                continue;
            }
            if (!(diff instanceof DiffPointChildOrder)) continue;
            List<Match> childMatches = ((DiffPointChildOrder)diff).getMatches();
            for (int j = 0; j < childMatches.size(); ++j) {
                Match match = childMatches.get(j);
                TreePath path = this.getPathInResultTree(this.myResultTree, localPath.pathByAddingChild(match.getLocalNode()));
                this.myPathsInResultTree.put(match.getLocalNode(), path);
                this.myPathsInResultTree.put(match.getRemoteNode(), path);
            }
        }
    }

    private TreePath getPathInResultTree(TSTariffStructure resultTree, TreePath localPath) {
        TreePath resultPath = new TreePath(resultTree);
        for (int i = 1; i < localPath.getPathCount(); ++i) {
            TariffDAGNode localChild = (TariffDAGNode)localPath.getPathComponent(i);
            TariffDAGNode localParent = (TariffDAGNode)localPath.getPathComponent(i - 1);
            TariffDAGNode resultParent = (TariffDAGNode)resultPath.getPathComponent(i - 1);
            int index = localParent.getIndexOfChild(localChild);
            TariffDAGNode resultChild = (TariffDAGNode)resultParent.getChildAt(index);
            resultPath = resultPath.pathByAddingChild(resultChild);
        }
        return resultPath;
    }

    public TSTariffStructure getResultTree() {
        return this.myResultTree;
    }

    public static class MergeException
    extends Exception {
        public MergeException(String msg) {
            super(msg);
        }
    }
}

