/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.dataset.jump.SelectionTreeDestination;
import com.ericsson.ere.gui.diff.BuildTariffStructureWorker;
import com.ericsson.ere.gui.diff.DiffPoint;
import com.ericsson.ere.gui.diff.DiffPointChildOrder;
import com.ericsson.ere.gui.diff.DiffPointMissingChild;
import com.ericsson.ere.gui.diff.DiffProgressDialog;
import com.ericsson.ere.gui.diff.DiffSave;
import com.ericsson.ere.gui.diff.DiffToolAnalyzer;
import com.ericsson.ere.gui.diff.DiffToolMerger;
import com.ericsson.ere.gui.diff.DiffTree;
import com.ericsson.ere.gui.diff.DiffTreeCellRenderer;
import com.ericsson.ere.gui.diff.MergeOptionsPanel;
import com.ericsson.ere.gui.diff.ToggleLegendAction;
import com.ericsson.ere.gui.navigator.NavigatorNodeTransferable;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.ratingrules.RatingRuleFrameJumper;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffCellRenderer;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.UtilMenuItem;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.Service;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;

public class DiffToolPanel
extends JPanel
implements UtilMenuItem {
    private DiffToolPanelListener myListener = new DiffToolPanelListener();
    private DiffToolPanelDropListener myDropListener = new DiffToolPanelDropListener();
    private JScrollPane myLocalTreeScroll;
    private JScrollPane myRemoteTreeScroll;
    private JScrollPane myResultTreeScroll;
    private JLabel myResultTreeLabel;
    private DiffTree myLocalTree;
    private DiffTree myRemoteTree;
    private DiffTree myResultTree;
    private RatingPeriodProxy myLocalPeriod;
    private RatingPeriodProxy myRemotePeriod;
    private RatingPeriodProxy myRatingRuleTreeProxy;
    private JLabel myLocalTreePlaceHolder;
    private JLabel myRemoteTreePlaceHolder;
    private JLabel myLocalVersionLabel;
    private JLabel myRemoteVersionLabel;
    private DropTarget myLocalDropTarget;
    private DropTarget myRemoteDropTarget;
    private Action myNavigateFirstDiff = new ShowFirstDiffAction();
    private Action myNavigatePreviousDiff = new ShowPreviousDiffAction();
    private ShowCurrentDiffAction myNavigateCurrentDiff = new ShowCurrentDiffAction();
    private Action myNavigateNextDiff = new ShowNextDiffAction();
    private Action myNavigateLastDiff = new ShowLastDiffAction();
    private DiffPoint mySelectedDiff;
    private JButton myMergeButton;
    private JSplitPane myMergePane;
    private JTabbedPane myMergeOptionsPane;
    private JButton mySaveButton;
    private JButton myCancelButton;
    private Component myOwnerComponent;
    private ContextAwareServiceContainer myLocalServiceContainer;
    private ContextAwareServiceContainer myRemoteServiceContainer;
    private List<DiffPoint> myDiffPoints;
    private Map<TariffDAGNode, List<DiffPoint>> myDiffPointsHash = new HashMap<TariffDAGNode, List<DiffPoint>>();
    private Map<TariffDAGNode, Boolean> myDiffPointAncestors = new HashMap<TariffDAGNode, Boolean>();
    private boolean isLocalDropEnabled = false;
    private boolean isRemoteDropEnabled = false;
    private SelectionTree mySelectionTree;
    DiffToolMerger myMerger;
    boolean useLocalAndRemoteTerms;
    int myAction;
    public static final int ACTION_VIEW = 1;
    public static final int ACTION_MERGE = 2;
    public static final int ACTION_DIFF = 3;
    public static final String RMA_HEADER_TEXT = "RMA";

    public DiffToolPanel(JInternalFrame aOwnerFrame, Node aConfig) {
        this.myOwnerComponent = aOwnerFrame;
        this.myAction = 1;
        this.useLocalAndRemoteTerms = false;
        this.isLocalDropEnabled = true;
        this.isRemoteDropEnabled = true;
        try {
            this.initComponents();
            this.init();
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "diffTool", 1, "There was an error opening the Diff Tool!", true);
        }
    }

    public DiffToolPanel(RatingPeriodProxy firstPeriod, int action) {
        this(firstPeriod, null, action);
    }

    public DiffToolPanel(RatingPeriodProxy firstPeriod, RatingPeriodProxy secondPeriod, int action) {
        if (action != 1 && action != 2) {
            throw new IllegalArgumentException("Action must be either DiffToolPanel.ACTION_VIEW or DiffToolPanel.ACTION_MERGE");
        }
        try {
            this.myLocalServiceContainer = this.createServiceForRatingPeriodProxy(firstPeriod);
            this.myRemoteServiceContainer = this.createServiceForRatingPeriodProxy(secondPeriod);
            this.useLocalAndRemoteTerms = false;
            this.isLocalDropEnabled = true;
            this.isRemoteDropEnabled = true;
            this.myAction = action;
            this.initComponents();
            this.openRatingPeriod(firstPeriod, true);
            if (secondPeriod != null) {
                this.openRatingPeriod(secondPeriod, false);
            }
            this.init();
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "diffTool", 1, "There was an error openiong the Diff Tool!", true);
        }
    }

    public DiffToolPanel(SelectionTree selectionTree, RatingPeriodProxy proxy, ContextAwareServiceContainer serviceContainer, TSTariffStructure localTree, TSTariffStructure remoteTree, int action) {
        if (action != 3 && action != 2) {
            throw new IllegalArgumentException("Action must be either DiffToolPanel.ACTION_DIFF or DiffToolPanel.ACTION_MERGE");
        }
        try {
            this.mySelectionTree = selectionTree;
            this.useLocalAndRemoteTerms = true;
            this.myAction = action;
            this.myRatingRuleTreeProxy = proxy;
            this.myLocalServiceContainer = serviceContainer;
            this.myRemoteServiceContainer = serviceContainer;
            this.isLocalDropEnabled = false;
            this.isRemoteDropEnabled = false;
            this.initComponents();
            this.openTariffStructure(localTree, true);
            this.myAction = action;
            this.openTariffStructure(remoteTree, false);
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "diffTool", 1, "There was an error trying to analyze differences between the two structures!", true);
        }
    }

    public RmaFrameSupport getInternalFrame() {
        if (this.myOwnerComponent == null) {
            this.myOwnerComponent = EDT.runAndWait(new EDT.ValueRunnable<RmaFrameSupport>(){

                @Override
                public RmaFrameSupport run() {
                    RmaFrameSupport frame = new RmaFrameSupport();
                    frame.setTitle("Selection Tree Difference Detection Tool");
                    frame.setClosable(true);
                    frame.setIconifiable(true);
                    frame.setFrameIcon(RmaDefs.getImageIcon("components16.png"));
                    frame.setMaximizable(true);
                    frame.setResizable(true);
                    frame.getContentPane().add(DiffToolPanel.this);
                    frame.setSize(700, 650);
                    frame.setVisible(true);
                    return frame;
                }
            });
        } else if (!(this.myOwnerComponent instanceof RmaFrameSupport)) {
            throw new IllegalStateException("A diff tool owner has already been created of another type.");
        }
        return (RmaFrameSupport)this.myOwnerComponent;
    }

    public JDialog getDialog() {
        if (this.myOwnerComponent == null) {
            this.myOwnerComponent = EDT.runAndWait(new EDT.ValueRunnable<JDialog>(){

                @Override
                public JDialog run() {
                    JDialog dialog = new JDialog();
                    dialog.setTitle("Selection Tree Difference Detection Tool");
                    dialog.setIconImage(RmaDefs.getImageIcon("components16.png").getImage());
                    dialog.setResizable(true);
                    dialog.getContentPane().add(DiffToolPanel.this);
                    dialog.setSize(700, 650);
                    dialog.setLocationRelativeTo(DiffToolPanel.this.getFrame());
                    dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
                    return dialog;
                }
            });
        } else if (!(this.myOwnerComponent instanceof JDialog)) {
            throw new IllegalStateException("A diff tool owner has already been created of another type.");
        }
        return (JDialog)this.myOwnerComponent;
    }

    private void openRatingPeriod(RatingPeriodProxy period, boolean openInLocal) {
        ContextAwareServiceContainer serviceContainer = null;
        try {
            serviceContainer = this.createServiceForRatingPeriodProxy(period);
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "diffTool", 1, "There was an error trying to open the rating period " + period.getName() + ". Could not instantiate Service", true);
        }
        boolean servicesAreCompatible = DiffToolPanel.servicesAreCompatible(serviceContainer, openInLocal ? this.myRemoteServiceContainer : this.myLocalServiceContainer);
        if (this.myAction == 2 && !servicesAreCompatible) {
            DialogFactory.getInformationDialog(this.myOwnerComponent, RMA_HEADER_TEXT, "Two trees built with incompatible services cannot be merged together.\nOnly diff functionality will be available.");
            this.stopMerge();
        }
        Window owner = GuiUtil.getClosestWindowParent(this);
        DiffProgressDialog progressDialog = DiffProgressDialog.showDialog(owner, "Opening Rating period...");
        try {
            BuildTariffStructureWorker worker = new BuildTariffStructureWorker(progressDialog, serviceContainer, period);
            worker.execute();
            progressDialog.setVisible(true);
            TSTariffStructure structure = (TSTariffStructure)worker.get();
            SelectionTreeDestination myOwnDestination = new SelectionTreeDestination(period.getRatingPlanName(), period.getServiceName(), period.getServiceProviderName());
            serviceContainer.getClassRepository().setJumperSupport(new RatingRuleFrameJumper(period.getRatingManagerProxy(), myOwnDestination));
            if (openInLocal) {
                this.myLocalPeriod = period;
                this.myLocalServiceContainer = serviceContainer;
            } else {
                this.myRemotePeriod = period;
                this.myRemoteServiceContainer = serviceContainer;
            }
            this.openTariffStructure(structure, openInLocal);
            if (this.myLocalTreeScroll != null && this.myRemoteTreeScroll != null) {
                this.myLocalTreeScroll.repaint();
                this.myRemoteTreeScroll.repaint();
            }
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "diffTool", 1, "There was an error trying to open the rating period " + period.getName(), true);
        }
    }

    private void openTariffStructure(TSTariffStructure structure, boolean openInLocal) throws Exception {
        if (openInLocal) {
            this.myLocalTree = this.openTariffStructure(structure, this.myLocalTreeScroll, this.myLocalVersionLabel, "DiffToolPanel.DiffTree.LocalTree");
            if (this.myLocalTreeScroll != null && this.isLocalDropEnabled) {
                this.myLocalDropTarget = new DropTarget(this.myLocalTree, 3, this.myDropListener, true);
            }
        } else {
            this.myRemoteTree = this.openTariffStructure(structure, this.myRemoteTreeScroll, this.myRemoteVersionLabel, "DiffToolPanel.DiffTree.RemoteTree");
            if (this.myRemoteTreeScroll != null && this.isRemoteDropEnabled) {
                this.myRemoteDropTarget = new DropTarget(this.myRemoteTree, 3, this.myDropListener, true);
            }
        }
        this.init();
    }

    private DiffTree openTariffStructure(TSTariffStructure structure, JScrollPane scroller, JLabel versionLabel, String name) throws Exception {
        DiffTree tree = new DiffTree(structure, this);
        tree.setName(name);
        if (scroller != null) {
            scroller.getViewport().removeAll();
            tree.setCellRenderer(new DiffTreeCellRenderer());
            tree.addTreeSelectionListener(this.myListener);
            ToolTipManager.sharedInstance().registerComponent(tree);
            scroller.getViewport().add(tree);
            versionLabel.setText(" (ver. " + tree.getVersion() + ")");
        }
        return tree;
    }

    private void init() throws Exception {
        if (this.treesAreLoaded() && this.updateStateAndAnalyzeForDifferences()) {
            if (this.myAction == 2) {
                this.startMerge();
            }
            Collections.sort(this.myDiffPoints);
            this.showFirstDiff();
        } else {
            this.setNoDifferenceState();
        }
    }

    private boolean treesAreLoaded() {
        return this.myLocalTree != null && this.myRemoteTree != null;
    }

    private boolean updateStateAndAnalyzeForDifferences() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                DiffToolPanel.this.myMergeButton.setEnabled(true);
                DiffToolPanel.this.myMergePane.setDividerLocation(0.5);
            }
        });
        this.myDiffPoints = DiffToolPanel.findDifferences(this.myLocalTree, this.myRemoteTree);
        this.initDiffPointsHash();
        return this.myDiffPoints.size() > 0;
    }

    private void setNoDifferenceState() {
        this.disableNavigation();
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                DiffToolPanel.this.myMergeButton.setEnabled(false);
                DiffToolPanel.this.stopMerge();
                DiffToolPanel.this.myMergeOptionsPane.removeAll();
                JLabel emptyLabel = new JLabel("No difference is selected.");
                emptyLabel.setHorizontalAlignment(0);
                emptyLabel.setVerticalAlignment(0);
                JPanel emptyPanel = new JPanel(new GridBagLayout());
                emptyPanel.add((Component)emptyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                DiffToolPanel.this.myMergeOptionsPane.addTab("Merge options", emptyPanel);
            }
        });
    }

    private void initComponents() {
        EDT.runAndWait(new ComponentInitializer());
    }

    private MergeOptionsPanel isDiffAvaliable(DiffPoint diff) {
        for (int i = 0; i < this.myMergeOptionsPane.getTabCount(); ++i) {
            if (!(this.myMergeOptionsPane.getComponentAt(i) instanceof MergeOptionsPanel)) {
                return null;
            }
            if (((MergeOptionsPanel)this.myMergeOptionsPane.getComponentAt((int)i)).myDiffPoint != diff) continue;
            return (MergeOptionsPanel)this.myMergeOptionsPane.getComponentAt(i);
        }
        return null;
    }

    protected Component getFrame() {
        Component frame = this.mySelectionTree.getOwnerFrame();
        return frame;
    }

    private void openSelectionTreeEditor(RatingPeriodProxy rpProxy) {
        AbstractNavigatorNode nodeForProxy = GuiServiceCenter.getInstance().getNavigatorTreeModel().getNodeForProxy(rpProxy);
        nodeForProxy.performNodeAction();
        TreePath treePath = new TreePath(nodeForProxy.getPath());
        GuiServiceCenter.getInstance().getNavigatorTree().expandPath(treePath);
        GuiServiceCenter.getInstance().getNavigatorTree().setSelectionPath(treePath);
    }

    private void showFirstDiff() {
        if (this.myDiffPoints.size() > 0) {
            DiffPoint diff = this.myDiffPoints.get(0);
            this.showDiff(diff);
        }
    }

    private void showDiff(DiffPoint diffPoint) {
        try {
            this.mySelectedDiff = diffPoint;
            this.updateNavigatorButtonsAndSelectPath(diffPoint);
            this.updateMergeOptionsPane(diffPoint);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "diffTool", 1, "There was an error trying to show the selected difference!", true);
        }
    }

    private void updateMergeOptionsPane(DiffPoint diffPoint) {
        TariffDAGNode selectedNode = (TariffDAGNode)diffPoint.getLocalPath().getLastPathComponent();
        List<DiffPoint> selectedDiffs = this.myDiffPointsHash.get(selectedNode);
        this.myMergeOptionsPane.removeChangeListener(this.myListener);
        if (selectedDiffs != null && selectedDiffs.size() > 0) {
            MergeOptionsPanel diffPanel = this.isDiffAvaliable(this.mySelectedDiff);
            if (diffPanel != null) {
                this.myMergeOptionsPane.setSelectedComponent(diffPanel);
            } else {
                for (int i = 0; i < this.myMergeOptionsPane.getTabCount(); ++i) {
                    if (!(this.myMergeOptionsPane.getComponentAt(i) instanceof MergeOptionsPanel)) continue;
                    ((MergeOptionsPanel)this.myMergeOptionsPane.getComponentAt(i)).tearDown();
                }
                this.myMergeOptionsPane.removeAll();
                MergeOptionsPanel selectedPanel = null;
                for (int i = 0; i < selectedDiffs.size(); ++i) {
                    MergeOptionsPanel tab = new MergeOptionsPanel(this, selectedDiffs.get(i));
                    String tabTitle = "" + (this.myDiffPoints.indexOf(selectedDiffs.get(i)) + 1);
                    if (this.myMergeOptionsPane.getTabCount() == 0) {
                        tabTitle = "Selected " + DiffPoint.getNodeTypeString((TariffDAGNode)selectedDiffs.get((int)i).myLocalPath.getLastPathComponent()) + " diff " + tabTitle;
                    }
                    this.myMergeOptionsPane.addTab(tabTitle, tab);
                    if (tab.myDiffPoint != this.mySelectedDiff) continue;
                    selectedPanel = tab;
                }
                if (selectedPanel != null) {
                    this.myMergeOptionsPane.setSelectedComponent(selectedPanel);
                } else if (this.myMergeOptionsPane.getTabCount() > 0) {
                    this.myMergeOptionsPane.setSelectedIndex(0);
                    this.mySelectedDiff = ((MergeOptionsPanel)this.myMergeOptionsPane.getSelectedComponent()).myDiffPoint;
                }
            }
            this.myMergeOptionsPane.addChangeListener(this.myListener);
        }
    }

    private void updateNavigatorButtonsAndSelectPath(DiffPoint diffPoint) {
        this.myNavigateCurrentDiff.setText(this.myDiffPoints.indexOf(diffPoint) + 1 + " of " + this.myDiffPoints.size(), true);
        boolean is2ndDiffOrLater = this.myDiffPoints.indexOf(this.mySelectedDiff) > 0;
        this.myNavigateFirstDiff.setEnabled(is2ndDiffOrLater);
        this.myNavigatePreviousDiff.setEnabled(is2ndDiffOrLater);
        boolean isNextToLastDiffOrEarlier = this.myDiffPoints.indexOf(this.mySelectedDiff) < this.myDiffPoints.size() - 1;
        this.myNavigateNextDiff.setEnabled(isNextToLastDiffOrEarlier);
        this.myNavigateLastDiff.setEnabled(isNextToLastDiffOrEarlier);
        if (diffPoint instanceof DiffPointMissingChild || diffPoint instanceof DiffPointChildOrder) {
            this.myLocalTree.expandPath(diffPoint.getLocalPath());
            this.myRemoteTree.expandPath(diffPoint.getRemotePath());
        }
        this.setSelectionPathWithoutEventsAndScrollTo(this.myLocalTree, diffPoint.getLocalPath());
        this.setSelectionPathWithoutEventsAndScrollTo(this.myRemoteTree, diffPoint.getRemotePath());
        if (this.myResultTree != null && this.myResultTree.isVisible()) {
            TreePath resultPath = this.myMerger.getResultPath((TariffDAGNode)diffPoint.getLocalPath().getLastPathComponent());
            this.myResultTree.expandPath(resultPath);
            this.myResultTree.scrollPathToVisible(resultPath);
            this.myResultTree.setSelectionPath(resultPath);
        }
    }

    private void setSelectionPathWithoutEventsAndScrollTo(DiffTree tree, TreePath path) {
        tree.removeTreeSelectionListener(this.myListener);
        tree.setSelectionPath(path);
        tree.addTreeSelectionListener(this.myListener);
        tree.scrollPathToVisible(path);
    }

    private void initDiffPointsHash() {
        this.myDiffPointsHash = new HashMap<TariffDAGNode, List<DiffPoint>>();
        this.myDiffPointAncestors = new HashMap<TariffDAGNode, Boolean>();
        for (int i = 0; i < this.myDiffPoints.size(); ++i) {
            DiffPoint diff = this.myDiffPoints.get(i);
            TreePath localPath = diff.getLocalPath();
            TreePath remotePath = diff.getRemotePath();
            TariffDAGNode localNode = (TariffDAGNode)localPath.getLastPathComponent();
            TariffDAGNode remoteNode = (TariffDAGNode)remotePath.getLastPathComponent();
            this.addDiffPointToMapForNode(diff, localNode, this.myDiffPointsHash);
            this.addDiffPointToMapForNode(diff, remoteNode, this.myDiffPointsHash);
            for (int j = 0; j < localPath.getPathCount() - 1; ++j) {
                TariffDAGNode localAncestor = (TariffDAGNode)localPath.getPathComponent(j);
                TariffDAGNode remoteAncestor = (TariffDAGNode)remotePath.getPathComponent(j);
                this.myDiffPointAncestors.put(localAncestor, Boolean.TRUE);
                this.myDiffPointAncestors.put(remoteAncestor, Boolean.FALSE);
            }
        }
    }

    private void addDiffPointToMapForNode(DiffPoint diff, TariffDAGNode node, Map<TariffDAGNode, List<DiffPoint>> map) {
        List<DiffPoint> l = map.get(node);
        if (l == null) {
            l = new ArrayList<DiffPoint>();
            map.put(node, l);
        }
        l.add(diff);
    }

    private void startMerge() {
        DiffPoint selectedDiff = this.mySelectedDiff;
        if (!DiffToolPanel.servicesAreCompatible(this.myLocalServiceContainer, this.myRemoteServiceContainer)) {
            DialogFactory.getInformationDialog(this.myOwnerComponent, RMA_HEADER_TEXT, "Two trees built with incompatible services cannot be merged together.\nOnly diff functionality will be avaliabe.");
            this.stopMerge();
            return;
        }
        this.myAction = 2;
        this.myMergeButton.setText("Restart merge");
        this.myMerger = new DiffToolMerger(this.myLocalServiceContainer.getClassRepository(), this.myLocalServiceContainer.getService().getId(), this.myLocalTree, this.myDiffPoints);
        this.restartMerge();
        if (this.myResultTreeScroll != null) {
            this.showResultTree();
        }
        if (selectedDiff != null) {
            this.showDiff(selectedDiff);
        }
    }

    public static boolean servicesAreCompatible(ContextAwareServiceContainer aServiceContainer, ContextAwareServiceContainer anotherServiceAndContext) {
        boolean secondRepoContainsContextFields;
        if (aServiceContainer == null || anotherServiceAndContext == null) {
            return false;
        }
        if (!aServiceContainer.getService().getId().equals(anotherServiceAndContext.getService().getId())) {
            return false;
        }
        List<FieldHierarchyNode> aFieldListWithContext = aServiceContainer.getClassRepository().getFieldRepository().getAllFields();
        List<FieldHierarchyNode> anotherFieldListWithContext = anotherServiceAndContext.getClassRepository().getFieldRepository().getAllFields();
        List<FieldHierarchyNode> aFieldListWithoutContext = aServiceContainer.getService().getClassRepository().getFieldRepository().getAllFields();
        List<FieldHierarchyNode> anotherFieldListWithoutContext = anotherServiceAndContext.getService().getClassRepository().getFieldRepository().getAllFields();
        boolean firstRepoContainsContextFields = aFieldListWithContext.size() != aFieldListWithoutContext.size();
        boolean bl = secondRepoContainsContextFields = anotherFieldListWithContext.size() != anotherFieldListWithoutContext.size();
        if (firstRepoContainsContextFields || secondRepoContainsContextFields) {
            return aServiceContainer.getFieldContext().equals(anotherServiceAndContext.getFieldContext());
        }
        return true;
    }

    private ContextAwareServiceContainer createServiceForRatingPeriodProxy(RatingPeriodProxy proxy) throws Exception {
        if (proxy == null) {
            return null;
        }
        ServiceProxy serviceProxy = proxy.getRatingManagerProxy().getServiceListProxy().getServiceProxy(proxy.getServiceName());
        Service serviceInstance = serviceProxy.instantiateServiceObject();
        RatingPlanProxy rpProxy = proxy.getParentRatingPlanProxy();
        FieldContext context = new FieldContext(rpProxy.getServiceProviderProxy().getName(), rpProxy.getName());
        return ContextAwareServiceContainer.createContainerWithContext(serviceInstance, context);
    }

    private void showResultTree() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                DiffToolPanel.this.myResultTreeScroll.setVisible(true);
                DiffToolPanel.this.myResultTreeLabel.setVisible(true);
                DiffToolPanel.this.mySaveButton.setVisible(true);
            }
        });
    }

    private void restartMerge() {
        DiffPoint.initActions(this.myDiffPoints, 1);
        Window owner = GuiUtil.getClosestWindowParent(this);
        final DiffProgressDialog progressDialog = DiffProgressDialog.showDialog(owner, "Merging...");
        new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws Exception {
                DiffToolPanel.this.myMerger.restartMerge();
                return null;
            }

            @Override
            public void done() {
                progressDialog.setVisible(false);
                progressDialog.dispose();
            }
        }.execute();
        progressDialog.setVisible(true);
        for (int i = 0; i < this.myMergeOptionsPane.getTabCount(); ++i) {
            if (!(this.myMergeOptionsPane.getComponentAt(i) instanceof MergeOptionsPanel)) continue;
            ((MergeOptionsPanel)this.myMergeOptionsPane.getComponentAt(i)).tearDown();
        }
        this.myMergeOptionsPane.removeAll();
        if (this.myResultTree != null) {
            ToolTipManager.sharedInstance().unregisterComponent(this.myResultTree);
        }
        this.myResultTree = new DiffTree(this.myMerger.getResultTree(), this);
        this.myResultTree.setName("DiffToolPanel.DiffTree.ResultTree");
        this.myResultTree.setCellRenderer(new TariffCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.myResultTree);
        this.myResultTreeScroll.getViewport().removeAll();
        this.myResultTreeScroll.getViewport().add(this.myResultTree);
        this.updateResultTree(null);
        this.showFirstDiff();
    }

    private void stopMerge() {
        if (this.myAction != 3) {
            this.myAction = 1;
        }
        this.myMergeButton.setText("Merge");
        this.myResultTreeScroll.setVisible(false);
        this.myResultTreeLabel.setVisible(false);
        if (this.myAction != 3) {
            this.mySaveButton.setVisible(false);
        }
    }

    private void closeComponent(Component component) {
        if (component instanceof JInternalFrame) {
            this.closeFrameIgnoringException((JInternalFrame)component);
        } else if (component instanceof JDialog) {
            ((JDialog)component).setVisible(false);
        } else if (component != null) {
            throw new AssertionError((Object)("Unhandled owner type: " + component.getClass()));
        }
    }

    private void closeFrameIgnoringException(JInternalFrame frame) {
        try {
            frame.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void disableNavigation() {
        this.myNavigateFirstDiff.setEnabled(false);
        this.myNavigatePreviousDiff.setEnabled(false);
        this.myNavigateNextDiff.setEnabled(false);
        this.myNavigateLastDiff.setEnabled(false);
        this.myNavigateCurrentDiff.setText("No differences exists", false);
    }

    public List<DiffPoint> getAssociatedDiffPoints(TariffDAGNode node) {
        return this.myDiffPointsHash.get(node);
    }

    public boolean hasDescendantDiffPoints(TariffDAGNode node) {
        return this.myDiffPointAncestors.get(node) != null;
    }

    void updateResultTree(final TreePath selectionPath) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                try {
                    if (selectionPath != null) {
                        DiffToolPanel.this.myResultTree.updateUI();
                        DiffToolPanel.this.myResultTree.expandPath(selectionPath);
                        DiffToolPanel.this.myResultTree.scrollPathToVisible(selectionPath);
                        DiffToolPanel.this.myResultTree.setSelectionPath(selectionPath);
                    }
                }
                catch (Exception ex) {
                    ExceptionUtil.handleException(ex, "diffTool", 1, "Error displaying the result tree in Diff tool", false);
                }
            }
        });
    }

    public Map<TariffDAGNode, List<DiffPoint>> getDiffPoints() {
        return this.myDiffPointsHash;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return "Selection Tree Difference Detection Tool";
    }

    @Override
    public boolean isClosable() {
        return true;
    }

    @Override
    public boolean isIconifiable() {
        return true;
    }

    @Override
    public boolean isMaximizable() {
        return true;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public static List<DiffPoint> findDifferences(final DiffTree localTree, final DiffTree remoteTree) {
        final DiffToolAnalyzer analyzer = new DiffToolAnalyzer();
        Window owner = GuiUtil.getClosestWindowParent(localTree);
        final DiffProgressDialog progressDialog = DiffProgressDialog.showDialog(owner, "Analyzing differences...");
        try {
            SwingWorker<List<DiffPoint>, Void> worker = new SwingWorker<List<DiffPoint>, Void>(){

                @Override
                protected List<DiffPoint> doInBackground() throws Exception {
                    analyzer.doAnalyze(localTree, remoteTree);
                    return analyzer.getDiffPoints();
                }

                @Override
                public void done() {
                    progressDialog.setVisible(false);
                    progressDialog.dispose();
                }
            };
            worker.execute();
            progressDialog.setVisible(true);
            return (List)worker.get();
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "diffTool", 1, "There was an error trying to analyze differences between the two structures", true);
            return new ArrayList<DiffPoint>();
        }
    }

    private class ShowLastDiffAction
    extends AbstractAction {
        ShowLastDiffAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("navigate_end24.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DiffToolPanel.this.myDiffPoints.size() > 0) {
                DiffPoint diff = (DiffPoint)DiffToolPanel.this.myDiffPoints.get(DiffToolPanel.this.myDiffPoints.size() - 1);
                DiffToolPanel.this.showDiff(diff);
            }
        }
    }

    private class ShowNextDiffAction
    extends AbstractAction {
        ShowNextDiffAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("navigate_right24.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int currentIndex;
            if (DiffToolPanel.this.myDiffPoints.size() > 0 && (currentIndex = DiffToolPanel.this.myDiffPoints.indexOf(DiffToolPanel.this.mySelectedDiff)) < DiffToolPanel.this.myDiffPoints.size() - 1) {
                DiffPoint diff = (DiffPoint)DiffToolPanel.this.myDiffPoints.get(++currentIndex);
                DiffToolPanel.this.showDiff(diff);
            }
        }
    }

    private class ShowCurrentDiffAction
    extends AbstractAction {
        ShowCurrentDiffAction() {
            this.setText("No difference exsists", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiffToolPanel.this.showDiff(DiffToolPanel.this.mySelectedDiff);
        }

        public void setText(String text, boolean enabled) {
            this.putValue("Name", text);
            this.setEnabled(enabled);
        }
    }

    private class ShowPreviousDiffAction
    extends AbstractAction {
        ShowPreviousDiffAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("navigate_left24.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int currentIndex;
            if (DiffToolPanel.this.myDiffPoints.size() > 0 && (currentIndex = DiffToolPanel.this.myDiffPoints.indexOf(DiffToolPanel.this.mySelectedDiff)) > 0) {
                DiffPoint diff = (DiffPoint)DiffToolPanel.this.myDiffPoints.get(--currentIndex);
                DiffToolPanel.this.showDiff(diff);
            }
        }
    }

    private class ShowFirstDiffAction
    extends AbstractAction {
        ShowFirstDiffAction() {
            this.putValue("SmallIcon", RmaDefs.getImageIcon("navigate_beginning24.png"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiffToolPanel.this.showFirstDiff();
        }
    }

    private class DiffToolPanelDropListener
    extends DropTargetAdapter {
        private DiffToolPanelDropListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                DiffToolPanel.this.myLocalDropTarget.setActive(false);
                DiffToolPanel.this.myRemoteDropTarget.setActive(false);
                if (e.getTransferable().isDataFlavorSupported(NavigatorNodeTransferable.NAVIGATOR_TREE_PATH_FLAVOR)) {
                    TreePath dragPath = (TreePath)e.getTransferable().getTransferData(NavigatorNodeTransferable.NAVIGATOR_TREE_PATH_FLAVOR);
                    if (!(dragPath.getLastPathComponent() instanceof RatingPeriodNode)) {
                        throw new UnsupportedFlavorException(null);
                    }
                    RatingPeriodProxy period = (RatingPeriodProxy)((RatingPeriodNode)dragPath.getLastPathComponent()).getProxy();
                    Component dropTarget = ((DropTarget)e.getSource()).getComponent();
                    if (dropTarget == DiffToolPanel.this.myLocalTree || dropTarget == DiffToolPanel.this.myLocalTreePlaceHolder) {
                        DiffToolPanel.this.openRatingPeriod(period, true);
                    } else if (dropTarget == DiffToolPanel.this.myRemoteTree || dropTarget == DiffToolPanel.this.myRemoteTreePlaceHolder) {
                        DiffToolPanel.this.openRatingPeriod(period, false);
                    }
                    e.dropComplete(true);
                    return;
                }
            }
            catch (UnsupportedFlavorException ex) {
                DialogFactory.getInformationDialog(DiffToolPanel.this, DiffToolPanel.RMA_HEADER_TEXT, "Only Rating periods can be compared in this tool.");
            }
            catch (IOException ex) {
                DialogFactory.getInformationDialog(DiffToolPanel.this, DiffToolPanel.RMA_HEADER_TEXT, "Only Rating periods can be compared in this tool.");
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "diffTool", 2, "Failed to drop the period in the Diff Tool.", true);
            }
            finally {
                DiffToolPanel.this.myLocalDropTarget.setActive(true);
                DiffToolPanel.this.myRemoteDropTarget.setActive(true);
            }
            e.rejectDrop();
        }
    }

    private class DiffToolPanelListener
    implements TreeSelectionListener,
    ChangeListener,
    ActionListener {
        private DiffToolPanelListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (DiffToolPanel.this.treesAreLoaded()) {
                List selectedDiffs = null;
                if (e.getSource() == DiffToolPanel.this.myLocalTree) {
                    if (DiffToolPanel.this.myLocalTree.getSelectionPath() != null) {
                        TariffDAGNode selectedNode = (TariffDAGNode)DiffToolPanel.this.myLocalTree.getSelectionPath().getLastPathComponent();
                        selectedDiffs = (List)DiffToolPanel.this.myDiffPointsHash.get(selectedNode);
                    }
                } else if (e.getSource() == DiffToolPanel.this.myRemoteTree && DiffToolPanel.this.myRemoteTree.getSelectionPath() != null) {
                    TariffDAGNode selectedNode = (TariffDAGNode)DiffToolPanel.this.myRemoteTree.getSelectionPath().getLastPathComponent();
                    selectedDiffs = (List)DiffToolPanel.this.myDiffPointsHash.get(selectedNode);
                }
                if (selectedDiffs != null && selectedDiffs.size() > 0) {
                    DiffToolPanel.this.showDiff((DiffPoint)selectedDiffs.get(0));
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            MergeOptionsPanel panel;
            if (e.getSource() == DiffToolPanel.this.myMergeOptionsPane && DiffToolPanel.this.myMergeOptionsPane.getSelectedComponent() instanceof MergeOptionsPanel && (panel = (MergeOptionsPanel)DiffToolPanel.this.myMergeOptionsPane.getSelectedComponent()) != null) {
                DiffToolPanel.this.showDiff(panel.myDiffPoint);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == DiffToolPanel.this.myMergeButton) {
                if (DiffToolPanel.this.myAction == 1) {
                    DiffToolPanel.this.startMerge();
                } else if (DiffToolPanel.this.myAction == 2) {
                    DiffToolPanel.this.restartMerge();
                }
            } else if (e.getSource() == DiffToolPanel.this.mySaveButton) {
                boolean[] saveDestinationTrees = new boolean[]{false, false};
                int saveResult = DiffToolPanel.this.useLocalAndRemoteTerms ? (DiffToolPanel.this.myAction == 3 ? DiffSave.save(DiffToolPanel.this.mySelectionTree, DiffToolPanel.this.myRatingRuleTreeProxy, DiffToolPanel.this.myLocalTree, DiffToolPanel.this.myRemoteTree, false) : DiffSave.save(DiffToolPanel.this.mySelectionTree, DiffToolPanel.this.myRatingRuleTreeProxy, DiffToolPanel.this.myResultTree, DiffToolPanel.this.myRemoteTree, true)) : DiffSave.save(DiffToolPanel.this.myOwnerComponent, DiffToolPanel.this.myResultTree, DiffToolPanel.this.myLocalPeriod, DiffToolPanel.this.myLocalTree, DiffToolPanel.this.myRemotePeriod, DiffToolPanel.this.myRemoteTree, saveDestinationTrees);
                if (saveResult == 0) {
                    if (DiffToolPanel.this.mySelectionTree != null) {
                        DiffToolPanel.this.mySelectionTree.resetModified();
                    }
                    boolean continueEditing = false;
                    if (DiffToolPanel.this.useLocalAndRemoteTerms || saveDestinationTrees[0] || saveDestinationTrees[1]) {
                        continueEditing = DialogFactory.getQuestionDialogCustomButtons(GuiServiceCenter.getInstance().getMainWindow(), DiffToolPanel.RMA_HEADER_TEXT, "The result tree was succesfully saved!\nContinue editing?", "Yes", "No");
                    }
                    if (DiffToolPanel.this.myAction == 2) {
                        if (DiffToolPanel.this.useLocalAndRemoteTerms) {
                            if (continueEditing) {
                                DiffToolPanel.this.openSelectionTreeEditor(DiffToolPanel.this.myRatingRuleTreeProxy);
                            } else if (DiffToolPanel.this.mySelectionTree != null) {
                                DiffToolPanel.this.closeComponent(DiffToolPanel.this.getFrame());
                            }
                        } else if (continueEditing) {
                            if (saveDestinationTrees[0]) {
                                DiffToolPanel.this.openSelectionTreeEditor(DiffToolPanel.this.myLocalPeriod);
                            }
                            if (saveDestinationTrees[1]) {
                                DiffToolPanel.this.openSelectionTreeEditor(DiffToolPanel.this.myRemotePeriod);
                            }
                        }
                    } else if (!continueEditing) {
                        DiffToolPanel.this.closeComponent(DiffToolPanel.this.getFrame());
                    }
                    DiffToolPanel.this.closeComponent(DiffToolPanel.this.myOwnerComponent);
                } else if (saveResult == 2) {
                    DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), DiffToolPanel.RMA_HEADER_TEXT, "A version conflict has been detected. The tool has to discard your changes and reload the remote tree.");
                    DiffToolPanel.this.myAction = 2;
                    DiffToolPanel.this.openRatingPeriod(DiffToolPanel.this.myRatingRuleTreeProxy, false);
                }
            } else if (e.getSource() == DiffToolPanel.this.myCancelButton) {
                if (DiffToolPanel.this.myAction == 2 || DiffToolPanel.this.myAction == 3) {
                    DialogFactory.getInformationDialog(DiffToolPanel.this, DiffToolPanel.RMA_HEADER_TEXT, "No changes to the tariff structure was saved");
                }
                DiffToolPanel.this.closeComponent(DiffToolPanel.this.myOwnerComponent);
            }
        }
    }

    private final class ComponentInitializer
    implements Runnable {
        private ComponentInitializer() {
        }

        @Override
        public void run() {
            DiffToolPanel.this.setLayout(new GridBagLayout());
            this.setupMergePane();
            this.setupMergeButton();
            DiffToolPanel.this.disableNavigation();
            this.setupSaveButton();
            this.setupCancelButton();
            JPanel navigatorPanel = this.setupNavigatorPanel();
            JPanel actionPanel = new JPanel(new GridBagLayout());
            actionPanel.add((Component)DiffToolPanel.this.myCancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            actionPanel.add((Component)DiffToolPanel.this.mySaveButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 20, 0, 0), 0, 0));
            DiffToolPanel.this.add((Component)DiffToolPanel.this.myMergeButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(10, 10, 10, 0), 10, 0));
            DiffToolPanel.this.add((Component)navigatorPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(10, 0, 10, 0), 0, 0));
            JToggleButton legendButton = new JToggleButton(new ToggleLegendAction());
            legendButton.setName("DiffToolPanel.JToogleButton.ShowLegend");
            DiffToolPanel.this.add((Component)legendButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(10, 0, 10, 10), 0, 0));
            DiffToolPanel.this.add((Component)DiffToolPanel.this.myMergePane, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            DiffToolPanel.this.add((Component)actionPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 10), 0, 0));
        }

        private JPanel setupNavigatorPanel() {
            JPanel navigatorPanel = new JPanel(new GridBagLayout());
            JPanel prevPanel = new JPanel(new GridBagLayout());
            prevPanel.add((Component)new JButton(DiffToolPanel.this.myNavigateFirstDiff), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            prevPanel.add((Component)new JButton(DiffToolPanel.this.myNavigatePreviousDiff), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            JPanel nextPanel = new JPanel(new GridBagLayout());
            nextPanel.add((Component)new JButton(DiffToolPanel.this.myNavigateNextDiff), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            JButton lastDiffButton = new JButton(DiffToolPanel.this.myNavigateLastDiff);
            lastDiffButton.setName("DiffToolPanel.JButton.LastDiff");
            nextPanel.add((Component)lastDiffButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            JButton currentDiffButton = new JButton(DiffToolPanel.this.myNavigateCurrentDiff);
            currentDiffButton.setBorder(BorderFactory.createBevelBorder(1));
            navigatorPanel.add((Component)prevPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
            navigatorPanel.add((Component)currentDiffButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 10, 0));
            navigatorPanel.add((Component)nextPanel, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
            return navigatorPanel;
        }

        private void setupSaveButton() {
            DiffToolPanel.this.mySaveButton = new JButton("Save");
            DiffToolPanel.this.mySaveButton.setName("DiffToolPanel.JButton.Save");
            DiffToolPanel.this.mySaveButton.setIcon(RmaDefs.getImageIcon("disk_blue16.png"));
            DiffToolPanel.this.mySaveButton.addActionListener(DiffToolPanel.this.myListener);
            if (DiffToolPanel.this.myAction == 1) {
                DiffToolPanel.this.mySaveButton.setVisible(false);
            }
        }

        private void setupCancelButton() {
            DiffToolPanel.this.myCancelButton = new JButton();
            DiffToolPanel.this.myCancelButton.setIcon(RmaDefs.getImageIcon("door2_16.png"));
            if (DiffToolPanel.this.myAction == 2 || DiffToolPanel.this.myAction == 3) {
                DiffToolPanel.this.myCancelButton.setText("Cancel");
            } else if (DiffToolPanel.this.myAction == 1) {
                DiffToolPanel.this.myCancelButton.setText("Close");
            }
            DiffToolPanel.this.myCancelButton.addActionListener(DiffToolPanel.this.myListener);
        }

        private JPanel setupLocalTreePanel() {
            DiffToolPanel.this.myLocalVersionLabel = new JLabel();
            if (DiffToolPanel.this.myLocalTree != null) {
                DiffToolPanel.this.myLocalTree.setCellRenderer(new DiffTreeCellRenderer());
                DiffToolPanel.this.myLocalTree.addTreeSelectionListener(DiffToolPanel.this.myListener);
                ToolTipManager.sharedInstance().registerComponent(DiffToolPanel.this.myLocalTree);
                DiffToolPanel.this.myLocalTreeScroll = new JScrollPane(DiffToolPanel.this.myLocalTree);
                if (DiffToolPanel.this.isLocalDropEnabled) {
                    DiffToolPanel.this.myLocalDropTarget = new DropTarget(DiffToolPanel.this.myLocalTree, 3, DiffToolPanel.this.myDropListener, true);
                }
                DiffToolPanel.this.myLocalVersionLabel.setText(" (ver. " + DiffToolPanel.this.myLocalTree.getVersion() + ")");
            } else {
                DiffToolPanel.this.myLocalTreePlaceHolder = this.createPlaceHolder("DiffToolPanel.JLabel.LocalTreePlaceHolder");
                DiffToolPanel.this.myLocalTreeScroll = new JScrollPane(DiffToolPanel.this.myLocalTreePlaceHolder);
                DiffToolPanel.this.myLocalDropTarget = new DropTarget(DiffToolPanel.this.myLocalTreePlaceHolder, 3, DiffToolPanel.this.myDropListener, true);
            }
            JPanel localTreePanel = this.createTreePanel(DiffToolPanel.this.useLocalAndRemoteTerms ? "Local tree" : "First tree", RmaDefs.getImageIcon("component_blue16.png"), DiffToolPanel.this.myLocalVersionLabel, DiffToolPanel.this.myLocalTreeScroll);
            return localTreePanel;
        }

        private JPanel setupRemoteTreePanel() {
            DiffToolPanel.this.myRemoteVersionLabel = new JLabel();
            if (DiffToolPanel.this.myRemoteTree != null) {
                DiffToolPanel.this.myRemoteTree.setCellRenderer(new DiffTreeCellRenderer());
                DiffToolPanel.this.myRemoteTree.addTreeSelectionListener(DiffToolPanel.this.myListener);
                ToolTipManager.sharedInstance().registerComponent(DiffToolPanel.this.myRemoteTree);
                DiffToolPanel.this.myRemoteTreeScroll = new JScrollPane(DiffToolPanel.this.myRemoteTree);
                if (DiffToolPanel.this.isRemoteDropEnabled) {
                    DiffToolPanel.this.myRemoteDropTarget = new DropTarget(DiffToolPanel.this.myRemoteTree, 3, DiffToolPanel.this.myDropListener, true);
                }
                DiffToolPanel.this.myRemoteVersionLabel.setText(" (ver. " + DiffToolPanel.this.myRemoteTree.getVersion() + ")");
            } else {
                DiffToolPanel.this.myRemoteTreePlaceHolder = this.createPlaceHolder("DiffToolPanel.JLabel.RemoteTreePlaceHolder");
                DiffToolPanel.this.myRemoteTreeScroll = new JScrollPane(DiffToolPanel.this.myRemoteTreePlaceHolder);
                DiffToolPanel.this.myRemoteDropTarget = new DropTarget(DiffToolPanel.this.myRemoteTreePlaceHolder, 3, DiffToolPanel.this.myDropListener, true);
            }
            JPanel remoteTreePanel = this.createTreePanel(DiffToolPanel.this.useLocalAndRemoteTerms ? "Remote tree" : "Second tree", RmaDefs.getImageIcon("component_green16.png"), DiffToolPanel.this.myRemoteVersionLabel, DiffToolPanel.this.myRemoteTreeScroll);
            return remoteTreePanel;
        }

        private JPanel createTreePanel(String treeName, ImageIcon icon, JLabel versionLabel, JScrollPane treeScroll) {
            JPanel treePanel = new JPanel(new GridBagLayout());
            JLabel treeLabel = new JLabel();
            treeLabel.setIconTextGap(10);
            treeLabel.setText(treeName);
            treeLabel.setIcon(icon);
            treePanel.add((Component)treeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
            treePanel.add((Component)versionLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            treePanel.add((Component)treeScroll, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 10, 10, 10), 0, 0));
            return treePanel;
        }

        private void setupMergeButton() {
            DiffToolPanel.this.myMergeButton = new JButton();
            DiffToolPanel.this.myMergeButton.setName("DiffToolPanel.JButton.Merge");
            if (DiffToolPanel.this.myAction == 1) {
                DiffToolPanel.this.myMergeButton.setText("Merge");
                if (DiffToolPanel.this.myLocalTree == null || DiffToolPanel.this.myRemoteTree == null) {
                    DiffToolPanel.this.myMergeButton.setEnabled(false);
                }
            } else if (DiffToolPanel.this.myAction == 2) {
                DiffToolPanel.this.myMergeButton.setText("Restart merge");
            } else if (DiffToolPanel.this.myAction == 3) {
                DiffToolPanel.this.myMergeButton.setVisible(false);
            }
            DiffToolPanel.this.myMergeButton.addActionListener(DiffToolPanel.this.myListener);
            DiffToolPanel.this.myMergeButton.setIcon(RmaDefs.getImageIcon("start_merge24.png"));
            DiffToolPanel.this.myMergeButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (DiffToolPanel.this.myMergeButton.isEnabled()) {
                        DiffToolPanel.this.myMergeButton.setIcon(RmaDefs.getImageIcon("start_merge_hover24.png"));
                    }
                    super.mouseEntered(e);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DiffToolPanel.this.myMergeButton.setIcon(RmaDefs.getImageIcon("start_merge24.png"));
                    super.mouseExited(e);
                }
            });
        }

        private void setupMergePane() {
            JPanel localTreePanel = this.setupLocalTreePanel();
            JPanel remoteTreePanel = this.setupRemoteTreePanel();
            JSplitPane mergeInputSplitPane = new JSplitPane(1, localTreePanel, remoteTreePanel);
            mergeInputSplitPane.setResizeWeight(0.5);
            mergeInputSplitPane.setDividerLocation(0.5);
            JPanel mergeResultPanel = new JPanel(new GridBagLayout());
            mergeResultPanel.setBorder(BorderFactory.createBevelBorder(1));
            JPanel mergeOptionsPanel = new JPanel(new GridBagLayout());
            mergeOptionsPanel.setBorder(BorderFactory.createEtchedBorder());
            DiffToolPanel.this.myResultTreeScroll = new JScrollPane(DiffToolPanel.this.myResultTree != null ? DiffToolPanel.this.myResultTree : new JPanel());
            DiffToolPanel.this.myMergeOptionsPane = new JTabbedPane();
            DiffToolPanel.this.myMergeOptionsPane.setName("DiffToolPanel.JTabbedPane.MergeOptionsPane");
            DiffToolPanel.this.myMergeOptionsPane.setTabLayoutPolicy(1);
            JLabel emptyLabel = new JLabel("No difference is selected.");
            emptyLabel.setHorizontalAlignment(0);
            emptyLabel.setVerticalAlignment(0);
            JPanel emptyPanel = new JPanel(new GridBagLayout());
            emptyPanel.add((Component)emptyLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            DiffToolPanel.this.myMergeOptionsPane.addTab("Merge options", emptyPanel);
            DiffToolPanel.this.myMergeOptionsPane.addChangeListener(DiffToolPanel.this.myListener);
            DiffToolPanel.this.myResultTreeLabel = new JLabel("Resulting tree");
            mergeResultPanel.add((Component)DiffToolPanel.this.myMergeOptionsPane, new GridBagConstraints(0, 0, 1, 2, 0.1, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
            mergeResultPanel.add((Component)DiffToolPanel.this.myResultTreeLabel, new GridBagConstraints(1, 0, 1, 1, 0.9, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
            mergeResultPanel.add((Component)DiffToolPanel.this.myResultTreeScroll, new GridBagConstraints(1, 1, 1, 1, 0.9, 1.0, 10, 1, new Insets(4, 10, 10, 10), 0, 0));
            if (DiffToolPanel.this.myAction == 1 || DiffToolPanel.this.myAction == 3) {
                DiffToolPanel.this.myResultTreeLabel.setVisible(false);
                DiffToolPanel.this.myResultTreeScroll.setVisible(false);
            }
            mergeResultPanel.setPreferredSize(mergeInputSplitPane.getPreferredSize());
            DiffToolPanel.this.myMergePane = new JSplitPane(0, mergeInputSplitPane, mergeResultPanel);
            DiffToolPanel.this.myMergePane.setResizeWeight(0.5);
            DiffToolPanel.this.myMergePane.setDividerLocation(0.5);
        }

        private JLabel createPlaceHolder(String name) {
            JLabel placeHolder = new JLabel("Drag a rating period here.");
            placeHolder.setName(name);
            placeHolder.setHorizontalAlignment(0);
            placeHolder.setVerticalAlignment(0);
            return placeHolder;
        }
    }
}

