/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffToolPanel;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.DAGNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class DiffTree
extends JTree {
    public static final int DIFF_TYPE_STRUCTURE = 0;
    public static final int DIFF_TYPE_NODE = 1;
    public static final int DIFF_TYPE_CONDITION = 2;
    public static final int DIFF_TYPE_MODIFIER = 3;
    public static final int DIFF_TYPE_LINK = 4;
    public static final int DIFF_TYPE_DEFS = 5;
    private TSTariffStructure myRootNode;
    private TariffDAGModel myTreeModel;
    private DiffToolPanel myDiffToolPanel;

    public DiffTree(TSTariffStructure root, DiffToolPanel diffToolPanel) {
        this.myDiffToolPanel = diffToolPanel;
        this.myRootNode = root;
        this.myTreeModel = new TariffDAGModel(this, this.myRootNode);
        this.setModel(this.myTreeModel);
        this.myRootNode.setTreeModel(this.myTreeModel);
    }

    public void tearDown() {
        this.myDiffToolPanel = null;
        this.myTreeModel = null;
        this.myRootNode = null;
        this.setModel(null);
    }

    public TSTariffStructure getRoot() {
        return this.myRootNode;
    }

    public static int getNodeType(TariffDAGNode node) {
        int nodeType = -1;
        if (node.isLink()) {
            nodeType = 4;
        } else {
            switch (node.getNodeType()) {
                case 2: {
                    nodeType = 2;
                    break;
                }
                case 3: {
                    nodeType = 3;
                    break;
                }
                case 1: {
                    nodeType = "Defs".equals(node.getTypename()) ? 5 : 1;
                    break;
                }
                case 0: {
                    nodeType = 0;
                    break;
                }
            }
        }
        return nodeType;
    }

    public static String getXml(TariffDAGNode node) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
            node.print(pw, 0, "  ");
            pw.close();
            return baos.toString("UTF-8");
        }
        catch (IOException e) {
            ExceptionUtil.handleException(e, "diffTool", 1, "Diff Tool couldn't fetch tree xml!", true);
            return null;
        }
    }

    public static TreePath getPath(TSTariffStructure root, TariffDAGNode n) {
        ArrayList<TariffDAGNode> pathToRoot = new ArrayList<TariffDAGNode>();
        if (n == root) {
            pathToRoot.add(n);
        } else {
            pathToRoot.add(n);
            while (true) {
                TariffDAGNode parent;
                n = parent = (TariffDAGNode)n.getParent();
                if (parent == root) {
                    pathToRoot.add(0, parent);
                    break;
                }
                if (parent == null) {
                    return null;
                }
                pathToRoot.add(0, parent);
            }
        }
        return new TreePath(pathToRoot.toArray());
    }

    public static int getIndex(TariffDAGNode n) {
        DAGNode parent = n.getParent();
        if (parent == null) {
            return -1;
        }
        return parent.getIndexOfChild(n);
    }

    public DiffToolPanel getDiffToolPanel() {
        return this.myDiffToolPanel;
    }

    public long getVersion() {
        return this.myRootNode.getVersion().getVersion();
    }
}

