/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.diff;

import com.ericsson.ere.gui.diff.DiffTree;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import org.w3c.dom.Node;

public class Match
implements Comparable<Match> {
    public static final int WORSE_MATCH = -1;
    public static final int AS_GOOD_A_MATCH = 0;
    public static final int BETTER_MATCH = 1;
    private static final int PRIO_NOT_SET = -1;
    public static final int PRIO_NO_MATCH = 0;
    public static final int PRIO_TYPE_MATCHES = 1;
    public static final int PRIO_INDEX_MATCHES = 2;
    public static final int PRIO_NAME_MATCHES = 3;
    public static final int PRIO_NAME_AND_INDEX_MATCH = 4;
    public static final int PRIO_XML_MATCH = 5;
    public static final int PRIO_EXACT_MATCH = 6;
    private TariffDAGNode myLocalNode;
    private TariffDAGNode myRemoteNode;
    private int myPriority = -1;
    private final boolean myIndexMatch;
    private final boolean myTypeMatch;

    public Match(TariffDAGNode localNode, TariffDAGNode remoteNode) {
        this.myLocalNode = localNode;
        this.myRemoteNode = remoteNode;
        this.myIndexMatch = DiffTree.getIndex(this.myLocalNode) == DiffTree.getIndex(this.myRemoteNode);
        this.myTypeMatch = DiffTree.getNodeType(this.myLocalNode) == DiffTree.getNodeType(this.myRemoteNode);
    }

    public Match(TariffDAGNode localNode, TariffDAGNode remoteNode, int localIndex, int remoteIndex) {
        this.myLocalNode = localNode;
        this.myRemoteNode = remoteNode;
        this.myIndexMatch = localIndex == remoteIndex;
        this.myTypeMatch = DiffTree.getNodeType(this.myLocalNode) == DiffTree.getNodeType(this.myRemoteNode);
    }

    @Override
    public int compareTo(Match otherMatch) {
        if (otherMatch == null) {
            return 1;
        }
        if (otherMatch.getMatchPriority() < this.getMatchPriority()) {
            return 1;
        }
        if (otherMatch.getMatchPriority() > this.getMatchPriority()) {
            return -1;
        }
        return 0;
    }

    public boolean isSufficient() {
        return this.myTypeMatch && (this.myIndexMatch || this.doesNameMatch());
    }

    public int getMatchPriority() {
        if (this.myPriority == -1) {
            this.myPriority = 0;
            if (this.myTypeMatch) {
                boolean nameMatches;
                this.myPriority = this.doesXmlMatch() ? (this.myIndexMatch ? 6 : 5) : ((nameMatches = this.doesNameMatch()) && this.myIndexMatch ? 4 : (nameMatches ? 3 : (this.myIndexMatch ? 2 : 1)));
            }
        }
        return this.myPriority;
    }

    private boolean doesXmlMatch() {
        boolean retVal = false;
        if (this.myLocalNode instanceof TSElement && this.myRemoteNode instanceof TSElement) {
            Node localXmlConfig = ((TSElement)this.myLocalNode).state().getXMLConfig();
            Node remoteXmlConfig = ((TSElement)this.myRemoteNode).state().getXMLConfig();
            retVal = localXmlConfig.isEqualNode(remoteXmlConfig);
        }
        return retVal;
    }

    public boolean doesTypeMatch() {
        return this.myTypeMatch;
    }

    public boolean doesNameMatch() {
        return this.myLocalNode.getNodeName().equals(this.myRemoteNode.getNodeName());
    }

    public boolean doesIndexMatch() {
        return this.myIndexMatch;
    }

    public TariffDAGNode getLocalNode() {
        return this.myLocalNode;
    }

    public TariffDAGNode getRemoteNode() {
        return this.myRemoteNode;
    }

    public String toString() {
        String s = "Matching '" + this.myLocalNode.getNodeName() + "' and '" + this.myRemoteNode.getNodeName() + "' : ";
        switch (this.getMatchPriority()) {
            case 0: {
                s = s + "No match";
                break;
            }
            case 1: {
                s = s + "Type matches";
                break;
            }
            case 2: {
                s = s + "Index matches";
                break;
            }
            case 3: {
                s = s + "Name matches";
                break;
            }
            case 4: {
                s = s + "Name and index matches";
                break;
            }
            case 5: {
                s = s + "Xml matches";
                break;
            }
            case 6: {
                s = s + "Exact match";
            }
        }
        return s;
    }
}

