/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.interfaces.NewProxyEditorInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.StringVariable;

public class DefaultNewServiceProxyEditor
implements NewProxyEditorInterface {
    @Override
    public void performNew(final AbstractEreProxy abstractProxy) {
        if (abstractProxy instanceof ServiceListProxy || abstractProxy instanceof ServiceProxy) {
            RatingManagerProxy ratingManagerProxy = abstractProxy.getRatingManagerProxy();
            final ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
            VarTableModel newSettings = new VarTableModel();
            newSettings.addRow(new StringVariable("Name", ""));
            PropertiesEditor.showDialogEdit(newSettings, "New Service", new EditablePropertiesInterface(){

                @Override
                public void cancel() {
                }

                @Override
                public String getTitle() {
                    return "New Service";
                }

                @Override
                public void update(VarTableModel model) throws PropertiesException {
                    SettingsMap newSettings = VarTableInput.readFromVarTableModel(model);
                    if (!RatingPlanProxy.validateName(newSettings.getParameterAsString("Name"))) {
                        throw new PropertiesException("The service name contains invalid characters.\nCharacters \\ / : * ? ; \" are not valid.");
                    }
                    if (abstractProxy instanceof ServiceListProxy || abstractProxy instanceof ServiceProxy) {
                        try {
                            serviceListProxy.createNewService(newSettings);
                        }
                        catch (EreCommunicationException ex) {
                            ExceptionUtil.handleException(ex, "navigator", 2, "Could not create new Service on remote ERE", true);
                        }
                        catch (Exception e) {
                            ExceptionUtil.handleException(e, "navigator", 2, "Could not create new skeleton for Service.", true);
                        }
                    }
                }

                @Override
                public boolean isSuccessful() {
                    return true;
                }
            });
        }
    }

    @Override
    public AbstractEreProxy getCreatedProxy() {
        return null;
    }
}

