/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.propertyeditor;

import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesEditor;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.util.Collections;
import java.util.Vector;

public class DefaultProxySettingsEditor
implements ProxySettingsEditorInterface {
    @Override
    public void performEdit(AbstractEreProxy abstractProxy) {
        RatingManagerProxy ratingManagerProxy = abstractProxy.getRatingManagerProxy();
        ServiceListProxy serviceListProxy = ratingManagerProxy.getServiceListProxy();
        if (serviceListProxy.getServiceList() == null || serviceListProxy.getServiceList().isEmpty()) {
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "No Service in Service list", "There is no service defined in the Service list. \nPlease, add a Service before trying to add a Service Provider.");
            return;
        }
        Vector<String> serviceNameList = new Vector<String>();
        for (ServiceProxy serviceProxy : serviceListProxy.getServiceList()) {
            serviceNameList.add(serviceProxy.getName());
        }
        Collections.sort(serviceNameList);
        StringVariable serviceProviderVariable = new StringVariable("Service provider");
        BaseVariable serviceVariable = new DropDownVariable("Service", 0, serviceNameList.toArray());
        StringVariable ratingPlanVariable = new StringVariable("Ratingplan");
        StringVariable nameVariable = new StringVariable("Name");
        DateAndTimeVariable startDateVariable = new DateAndTimeVariable("Start date", DateAndTimeVariable.Content.DATE_TIME, "99990101T000000000");
        if (!(abstractProxy instanceof ServiceProviderListProxy)) {
            RatingPlanProxy ratingPlanProxy;
            if (abstractProxy instanceof ServiceProviderProxy) {
                ServiceProviderProxy serviceProviderProxy = (ServiceProviderProxy)abstractProxy;
                serviceProviderVariable.setValue(serviceProviderProxy.getName());
                serviceProviderVariable.setAllowEdit(false);
            } else if (abstractProxy instanceof RatingPlanProxy) {
                ratingPlanProxy = (RatingPlanProxy)abstractProxy;
                serviceProviderVariable.setValue(ratingPlanProxy.getServiceProviderProxy().getName());
                serviceProviderVariable.setAllowEdit(false);
                serviceVariable = new StringVariable("Service", ratingPlanProxy.getServiceName());
                ((Variable)serviceVariable).setAllowEdit(false);
                ratingPlanVariable.setValue(ratingPlanProxy.getName());
                ratingPlanVariable.setAllowEdit(false);
            } else if (abstractProxy instanceof RatingPeriodProxy) {
                ratingPlanProxy = ((RatingPeriodProxy)abstractProxy).getParentRatingPlanProxy();
                serviceProviderVariable.setValue(ratingPlanProxy.getServiceProviderProxy().getName());
                serviceProviderVariable.setAllowEdit(false);
                serviceVariable = new StringVariable("Service", ratingPlanProxy.getServiceName());
                ((Variable)serviceVariable).setAllowEdit(false);
                ratingPlanVariable.setValue(ratingPlanProxy.getName());
                ratingPlanVariable.setAllowEdit(false);
            }
        }
        VarTableModel newSettings = new VarTableModel();
        newSettings.addRow(serviceProviderVariable);
        newSettings.addRow(serviceVariable);
        newSettings.addRow(ratingPlanVariable);
        newSettings.addRow(nameVariable);
        newSettings.addRow(startDateVariable);
        PropertiesEditor.showDialogEdit(newSettings, "New rating period", new EditablePropertiesInterface(){

            @Override
            public void cancel() {
            }

            @Override
            public String getTitle() {
                return null;
            }

            @Override
            public void update(VarTableModel model) throws PropertiesException {
            }

            @Override
            public boolean isSuccessful() {
                return true;
            }
        });
    }
}

