/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor;

import com.ericsson.ere.constraint.ConstraintModel;
import com.ericsson.ere.defs.GuiService;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.appaction.ApplicationAction;
import com.ericsson.ere.gui.appaction.ApplicationActionStateHandler;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorRootModel;
import com.ericsson.ere.gui.editors.serviceeditor.TreeNodeSelectionHandler;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.ConstraintDefinitionPanel;
import com.ericsson.ere.gui.editors.serviceeditor.datarepository.DataRepositoryEditor;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsAndContextTabPanel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsPanel;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTree;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeModel;
import com.ericsson.ere.gui.navigator.nodes.ServiceNode;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.interfaces.ProxyTargetEditor;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameInterface;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.StatusPanel;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.gui.util.SwingWorker;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.management.EreProvisioningException;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceUpgradeException;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTable2;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;

public class ServiceEditorInternalFrame
extends RmaFrameSupport
implements RmaFrameInterface,
ApplicationActionStateHandler,
ProxyTargetEditor {
    public static String ACTION_KEY_IMPORT = "Import";
    public static String ACTION_KEY_SAVE = "Save";
    public static String ACTION_KEY_EXPORT = "Export";
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();
    private Service myService;
    private ServiceProxy myServiceProxy = null;
    private PluginsTree myPluginDefinitionTree;
    private JTree myContextDefinitionTree;
    private JTree myFieldsDefinitionTree;
    private FieldsAndContextTabPanel myFieldsDefinitionPanel;
    private JSplitPane myRecordConditionPanel;
    private JTabbedPane myDefinitionTabbedPane;
    public static final String TAG_LBL_TAB_CD = "Plug-ins";
    public static final String TAG_LBL_TAB_C = "Fields definition";
    private DataRepositoryEditor myDataRepositoryEditor;
    private Map<String, Action> myCommonActions;
    private ServiceEditorRootModel myRootModel;

    public static ServiceEditorInternalFrame createSafely(final ServiceProxy proxy, Element serviceDefinition) throws Exception {
        if (serviceDefinition == null) {
            throw new IllegalArgumentException("Must have a non-null service definition element.");
        }
        final Element definitionElement = serviceDefinition;
        final Element conditionElement = ServiceEditorInternalFrame.extractConditionElement(definitionElement);
        final Service service = ServiceEditorInternalFrame.createAndStartService(proxy.getName(), definitionElement);
        ServiceEditorInternalFrame frame = EDT.runAndWait(new Callable<ServiceEditorInternalFrame>(){

            @Override
            public ServiceEditorInternalFrame call() throws Exception {
                return new ServiceEditorInternalFrame(proxy, service, definitionElement, conditionElement);
            }
        });
        return frame;
    }

    private static Service createAndStartService(String name, Element definitionElement) throws Exception {
        GuiService service = new GuiService(name);
        service.startService(definitionElement);
        return service;
    }

    private static Element extractConditionElement(Element definitionElement) {
        Element ce = XMLUtil.getNamedElement("Settings", definitionElement.getChildNodes());
        if (ce == null) {
            ce = XMLUtil.getNamedElement("Settings", definitionElement.getParentNode().getChildNodes());
        }
        if (ce == null) {
            throw new IllegalArgumentException("Cannot locate the Settings element in the service XML.");
        }
        return ce;
    }

    protected ServiceEditorInternalFrame(ServiceProxy proxy, Service service, Element definitionElement, Element conditionElement) {
        super(proxy.getDefaultWindowTitle());
        this.myServiceProxy = proxy;
        this.myService = service;
        this.init(definitionElement, conditionElement);
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
    }

    private void init(Element definitionElement, Element conditionElement) {
        this.myCommonActions = this.createCommonActions();
        this.bindCommonActions(this.myCommonActions);
        this.myRootModel = new ServiceEditorRootModel(this.getServiceProxy(), this.myService, definitionElement, conditionElement);
        this.initComponents();
    }

    private void initComponents() {
        this.createPluginsDefinitionPanel(this.myRootModel.getPluginsModel());
        this.createContextPanel(this.myRootModel.getContextsModel(), this.myRootModel.getFieldsModel());
        this.myDefinitionTabbedPane = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int index) {
                if (index == 0 && this.getTabCount() == 1) {
                    super.setSelectedIndex(index);
                } else if (ServiceEditorInternalFrame.this.prepareTabChange(this.getSelectedIndex(), index)) {
                    super.setSelectedIndex(index);
                }
            }
        };
        this.myDefinitionTabbedPane.setName("ServiceEditorInternalFrame.JTabbedPane.MainTabs");
        this.getContentPane().add(this.myDefinitionTabbedPane);
        if (!GuiServiceCenter.getInstance().setWindowPosition(this)) {
            this.setSize(new Dimension(800, 500));
        }
        this.setFrameIcon(RmaDefs.getImageIcon("navigator_service.png"));
        this.myDefinitionTabbedPane.addTab(TAG_LBL_TAB_C, this.myFieldsDefinitionPanel);
        this.myDefinitionTabbedPane.addTab(TAG_LBL_TAB_CD, this.myRecordConditionPanel);
        FunctionContext ctx = FunctionContext.build().withProxy(this.myServiceProxy).get();
        FunctionState state = FunctionManagerImpl.getInstance().getStateForFunction(FunctionToken.CONSTRAINTS, ctx);
        ConstraintModel constraintsModel = this.myRootModel.getConstraintsModel();
        if (!constraintsModel.getConstraintList().isEmpty() || state.getState() == FunctionState.State.ON) {
            ConstraintDefinitionPanel constraintDefPanel = this.createConstraintDefinitionPanel(constraintsModel);
            this.myDefinitionTabbedPane.addTab("Constraints", constraintDefPanel);
        }
        this.myDataRepositoryEditor = new DataRepositoryEditor(this.myService.getClassRepository(), this.myRootModel.getDataRepositoryModel());
        this.myDefinitionTabbedPane.addTab("Data Area", this.myDataRepositoryEditor);
    }

    boolean prepareTabChange(int currentIndex, int newIndex) {
        String currentTitle = this.myDefinitionTabbedPane.getTitleAt(currentIndex);
        boolean accept = true;
        if (!this.isTabValid(currentTitle)) {
            DialogFactory.getErrorDialog(currentTitle + " Error", "The setup in the current tab is invalid. Please correct it before leaving the tab.");
            accept = false;
        } else if (this.isModified()) {
            try {
                this.updateClassRepositoryFromCurrentSetup();
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "service", 1, "Failed to apply the current service setup.", true);
                accept = false;
            }
        }
        return accept;
    }

    private void updateClassRepositoryFromCurrentSetup() throws Exception {
        ServiceEditorRootModel.ClassRepositoryData repositoryData = this.myRootModel.createClassRepository(new Time());
        ClassRepository classReposi = repositoryData.getClassRepository();
        this.myService.setClassRepository(classReposi);
    }

    private boolean isTabValid(String title) {
        boolean isValid = true;
        if (TAG_LBL_TAB_C.equals(title)) {
            AbstractTreeNode fieldsRoot = (AbstractTreeNode)this.myRootModel.getFieldsModel().getRoot();
            AbstractTreeNode contextsRoot = (AbstractTreeNode)this.myRootModel.getContextsModel().getRoot();
            isValid = fieldsRoot.isNodeValid() && contextsRoot.isNodeValid();
        } else if (TAG_LBL_TAB_CD.equals(title)) {
            AbstractTreeNode pluginsRoot = (AbstractTreeNode)this.myRootModel.getPluginsModel().getRoot();
            isValid = pluginsRoot.isNodeValid();
        }
        return isValid;
    }

    private void bindCommonActions(Map<String, Action> commonActions) {
        ActionMap am = this.getActionMap();
        InputMap im = this.getInputMap(1);
        for (Map.Entry<String, Action> entry : commonActions.entrySet()) {
            String key = "__" + entry.getKey();
            Action action = entry.getValue();
            im.put((KeyStroke)action.getValue("AcceleratorKey"), key);
            am.put(key, action);
        }
    }

    private Map<String, Action> createCommonActions() {
        HashMap<String, Action> actions = new HashMap<String, Action>();
        actions.put(ACTION_KEY_SAVE, new SaveAction());
        actions.put(ACTION_KEY_IMPORT, new ImportAction());
        actions.put(ACTION_KEY_EXPORT, new ExportAction());
        return actions;
    }

    public boolean compareServiceAndEreConnector(ServiceProxy anyServiceProxy) {
        return this.myServiceProxy.equals(anyServiceProxy);
    }

    public ServiceProxy getServiceProxy() {
        return this.myServiceProxy;
    }

    @Deprecated
    public boolean compareDefintionFileName(String fileName) {
        return this.myService.getFileName().equals(fileName);
    }

    private void createContextPanel(ContextDefinitionTreeModel contextModel, FieldsDefinitionTreeModel fieldsModel) {
        this.myFieldsDefinitionPanel = new FieldsAndContextTabPanel(contextModel, fieldsModel, this.myCommonActions);
        this.myContextDefinitionTree = this.myFieldsDefinitionPanel.getContextTree();
        this.myFieldsDefinitionTree = this.myFieldsDefinitionPanel.getFieldsTree();
    }

    private void createPluginsDefinitionPanel(PluginsTreeModel pluginModel) {
        PluginsPanel condPanel = new PluginsPanel();
        this.myPluginDefinitionTree = new PluginsTree(pluginModel, this.myCommonActions);
        VarTable2 editTable = condPanel.getTable();
        TreeNodeSelectionHandler selectionHandler = new TreeNodeSelectionHandler(editTable.getTableModel());
        selectionHandler.bindTree(this.myPluginDefinitionTree, this.myPluginDefinitionTree, editTable);
        this.myRecordConditionPanel = new JSplitPane(1, new JScrollPane(this.myPluginDefinitionTree), condPanel);
        this.myRecordConditionPanel.setDividerSize(8);
        this.myRecordConditionPanel.setDividerLocation(200);
        this.myRecordConditionPanel.setOneTouchExpandable(true);
    }

    private ConstraintDefinitionPanel createConstraintDefinitionPanel(ConstraintModel model) {
        ConstraintDefinitionPanel panel = new ConstraintDefinitionPanel(this.myService, model);
        return panel;
    }

    public void triggerSave() {
        final ProgressDialog progressDialog = new ProgressDialog("RMA", "Saving Service");
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                ProgressIndicator pi = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(progressDialog);
                ServiceEditorInternalFrame.this.save(pi);
                return new Object();
            }

            @Override
            public void finished() {
                StatusPanel.getInstance().setStatusMsg("");
                progressDialog.dispose();
            }
        };
        worker.start();
        progressDialog.setVisible(true);
    }

    @Override
    public boolean save(ProgressIndicator progress) {
        this.notifyIfUncommittedChanges();
        progress.progressStart();
        this.saveService();
        progress.progressIncrement(100);
        return true;
    }

    public boolean saveService() {
        boolean success = true;
        if (this.isModified() && (success = this.treeConsistencyCheck())) {
            Time newSaveTime = new Time();
            try {
                ServiceEditorRootModel.ClassRepositoryData repositoryData = this.myRootModel.createClassRepository(newSaveTime);
                success = this.updateWithNewClassRepository(newSaveTime, repositoryData);
            }
            catch (Exception e) {
                this.handleSaveError(e, "Failed to save Service", "Save failed");
                success = false;
            }
        }
        return success;
    }

    private boolean updateWithNewClassRepository(Time newSaveTime, ServiceEditorRootModel.ClassRepositoryData repositoryData) {
        boolean success = false;
        try {
            this.myService.setClassRepository(repositoryData.getClassRepository());
            this.updateServiceViaProxy(repositoryData.getDefinitionElement(), repositoryData.getConditionElement(), newSaveTime, false);
            success = true;
        }
        catch (EreCommunicationException ece) {
            ServiceUpgradeException sue = this.getServiceUpgradeException(ece);
            if (sue != null && sue.isForcable()) {
                if (this.askToForceUpgrade(sue)) {
                    try {
                        this.updateServiceViaProxy(repositoryData.getDefinitionElement(), repositoryData.getConditionElement(), newSaveTime, true);
                        success = true;
                    }
                    catch (EreCommunicationException e) {
                        this.handleSaveError(e, "Forced upgrade of service failed", "Upgrade failed");
                    }
                }
            }
            this.handleSaveError(ece, "Failed to save Service", "Save failed");
        }
        return success;
    }

    private ServiceUpgradeException getServiceUpgradeException(EreCommunicationException ece) {
        EreProvisioningException epe = ece.getProvisioningException();
        return epe instanceof ServiceUpgradeException ? (ServiceUpgradeException)epe : null;
    }

    private void handleSaveError(Exception e, String msg, String title) {
        RmaDefs.loggerServiceDefinition.warning("Exception " + e.getMessage());
        String fullmsg = msg + "\nDetails: " + e.getMessage();
        this.myDialogFactory.getErrorDialog(this, title, fullmsg);
    }

    private void updateServiceViaProxy(Element definitionElement, Element conditionElement, Time newSaveTime, boolean forceUpgrade) throws EreCommunicationException {
        this.myServiceProxy.updateService(definitionElement, conditionElement, forceUpgrade);
        FieldTopNode fieldTopNode = (FieldTopNode)this.myFieldsDefinitionTree.getModel().getRoot();
        fieldTopNode.setSavedDate(newSaveTime);
        this.resetModified();
    }

    private boolean askToForceUpgrade(Exception sue) {
        String msg = "Failed to save Service \nDetails: " + sue.getMessage() + "\n\nDo you want to force an upgrade anyway?\nNOTE! Improper changes can make the rating fail after the upgrade.";
        int option = JOptionPane.showOptionDialog(this, msg, "Save failed", 0, 0, null, new Object[]{"Force upgrade!", "Cancel"}, "Cancel");
        return option == 0;
    }

    @Override
    public void export(ProgressIndicator progress) {
        boolean doExport = true;
        if (this.isModified()) {
            int result = DialogFactory.getQuestionDialogWithCancel(this, "Service is not saved", "The Service has been modified and is not saved. If you export without\nsaving the exported Service will be the last saved version.\nDo you want to save the Service before exporting?");
            if (result == 0) {
                this.triggerSave();
            } else if (result == 2 || result == -1) {
                doExport = false;
            }
        }
        if (doExport) {
            ServiceNode tempNode = new ServiceNode(this.myServiceProxy);
            WizardView view = WizardFactory.createNavigatorExportWizard(GuiServiceCenter.getInstance().getMainWindow(), tempNode);
            view.run();
        }
    }

    @Override
    public void importFile() {
        ServiceNode node = new ServiceNode(this.myServiceProxy);
        WizardView tDialog = WizardFactory.createNavigatorImportWizard(GuiServiceCenter.getInstance().getMainWindow(), node);
        tDialog.run();
    }

    @Override
    public boolean isOkToDiscardChanges() {
        boolean isOk = true;
        this.notifyIfUncommittedChanges();
        if (this.isModified()) {
            int result = DialogFactory.getQuestionDialogWithCancel(this, "Save " + this.getTitle(), "Save Changes ?\n" + this.getTitle());
            switch (result) {
                case 0: {
                    isOk = this.saveService();
                    break;
                }
                case 1: {
                    isOk = true;
                    break;
                }
                default: {
                    isOk = false;
                }
            }
        }
        return isOk;
    }

    public boolean isModified() {
        return this.myRootModel.isModified() || this.myDataRepositoryEditor.isModified();
    }

    private void resetModified() {
        this.myRootModel.resetModified();
        this.myDataRepositoryEditor.resetModified();
    }

    boolean arePluginsConsistent() {
        return this.isTabValid(TAG_LBL_TAB_CD);
    }

    private boolean areFieldsConsistent() {
        return this.isTabValid(TAG_LBL_TAB_C);
    }

    private boolean treeConsistencyCheck() {
        if (((AbstractTreeNode)this.myContextDefinitionTree.getModel().getRoot()).isNodeValid() && this.arePluginsConsistent() && this.areFieldsConsistent()) {
            return true;
        }
        DialogFactory.getErrorDialog(this, "Consistency check result", "The definition is NOT consistent.\nThe Service could not be saved.");
        return false;
    }

    @Override
    public boolean isApplicationActionSupported(ApplicationAction action) {
        switch (action) {
            case SAVE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getContentDescription() {
        return "Service";
    }

    @Override
    public boolean isEditingProxy(AbstractEreProxy aProxy) {
        boolean editing = false;
        if (this.myServiceProxy != null && aProxy instanceof ServiceProxy) {
            ServiceProxy other = (ServiceProxy)aProxy;
            editing = this.myServiceProxy.getName().equals(other.getName());
        }
        return editing;
    }

    private void notifyIfUncommittedChanges() {
        if (!this.myDataRepositoryEditor.isCommitted()) {
            DialogFactory.getWarningDialog(this, "Data Area", "There are uncommitted changes that will not be saved.");
        }
    }

    private class ExportAction
    extends AbstractAction {
        ExportAction() {
            this.putValue("Name", ACTION_KEY_EXPORT);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control E"));
            this.putValue("ShortDescription", "Exports the Service");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServiceEditorInternalFrame.this.export(null);
        }
    }

    private class ImportAction
    extends AbstractAction {
        ImportAction() {
            this.putValue("Name", ACTION_KEY_IMPORT);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control I"));
            this.putValue("ShortDescription", "Imports a Service");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServiceEditorInternalFrame.this.importFile();
        }
    }

    private class SaveAction
    extends AbstractAction {
        SaveAction() {
            this.putValue("Name", ACTION_KEY_SAVE);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control S"));
            this.putValue("ShortDescription", "Saves the Service");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ServiceEditorInternalFrame.this.triggerSave();
        }
    }
}

