/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor;

import com.ericsson.ere.constraint.ConstraintModel;
import com.ericsson.ere.constraint.ConstraintReader;
import com.ericsson.ere.constraint.ConstraintReaderImpl;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.defs.DataRepositoryModel;
import com.ericsson.ere.defs.DataRepositoryModelImpl;
import com.ericsson.ere.defs.RMAClassRepository;
import com.ericsson.ere.gui.editors.serviceeditor.NameRepositories;
import com.ericsson.ere.gui.editors.serviceeditor.TreeModelModificationListener;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsAndContextDefinitionTreeBuilder;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeBuilder;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.xmlprinters.PrintPlugins;
import com.ericsson.ere.gui.editors.serviceeditor.xmlprinters.PrintServiceDefintion;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.ServiceProxy;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.exception.EreException;
import ericsson.ere.management.Service;
import ericsson.ere.xml.XMLUtil;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceEditorRootModel {
    private TreeModelModificationListener myModificationListener = new TreeModelModificationListener();
    private ConstraintModel myConstraintModel;
    private DataRepositoryModel myDataModel;
    private FieldsDefinitionTreeModel myFieldsModel;
    private ContextDefinitionTreeModel myContextsModel;
    private PluginsTreeModel myPluginsModel;

    public ServiceEditorRootModel(ServiceProxy serviceProxy, Service service, Element definitionElement, Element conditionElement) {
        NameRepositories repositories = new NameRepositories();
        PluginsTreeBuilder pluginBuilder = new PluginsTreeBuilder(definitionElement, conditionElement);
        FieldsAndContextDefinitionTreeBuilder contextDefBuilder = new FieldsAndContextDefinitionTreeBuilder(definitionElement, serviceProxy);
        this.myPluginsModel = pluginBuilder.build(repositories);
        this.myFieldsModel = contextDefBuilder.buildFieldsModel(repositories, this.myPluginsModel);
        this.myContextsModel = contextDefBuilder.buildContextModel(repositories, this.myFieldsModel);
        this.myFieldsModel.addTreeModelListener(this.myModificationListener);
        this.myContextsModel.addTreeModelListener(this.myModificationListener);
        this.myPluginsModel.addTreeModelListener(this.myModificationListener);
        Node constraintsNode = definitionElement.getElementsByTagName("Constraints").item(0);
        this.myConstraintModel = this.createConstraintModel(constraintsNode);
        Element dataElement = XMLUtil.getNamedElement("Data", definitionElement.getChildNodes());
        this.myDataModel = new DataRepositoryModelImpl(dataElement, service.getClassRepository());
    }

    public FieldsDefinitionTreeModel getFieldsModel() {
        return this.myFieldsModel;
    }

    public ContextDefinitionTreeModel getContextsModel() {
        return this.myContextsModel;
    }

    public PluginsTreeModel getPluginsModel() {
        return this.myPluginsModel;
    }

    public ConstraintModel getConstraintsModel() {
        return this.myConstraintModel;
    }

    public DataRepositoryModel getDataRepositoryModel() {
        return this.myDataModel;
    }

    public boolean isModified() {
        return this.myModificationListener.isModified() || this.myConstraintModel.isModified() || this.myDataModel.isModified();
    }

    public void resetModified() {
        this.myModificationListener.resetModified();
        this.myConstraintModel.resetModified();
        this.myDataModel.resetModified();
    }

    public ClassRepositoryData createClassRepository(Time timeStamp) throws Exception {
        DefaultMutableTreeNode pluginsRoot = (DefaultMutableTreeNode)this.myPluginsModel.getRoot();
        DefaultMutableTreeNode fieldsRoot = (DefaultMutableTreeNode)this.myFieldsModel.getRoot();
        DefaultMutableTreeNode contextsRoot = (DefaultMutableTreeNode)this.myContextsModel.getRoot();
        Document conditionDocument = PrintPlugins.printToDocument(pluginsRoot);
        Document definitionDocument = PrintServiceDefintion.printToDocument(fieldsRoot, contextsRoot, this.myConstraintModel.getXMLRepresentation());
        Element repositoryElement = this.myDataModel.getRepositoryElement();
        definitionDocument.getDocumentElement().appendChild(definitionDocument.adoptNode(repositoryElement));
        this.modifySavedTimeOnDefinitionDocument(timeStamp, definitionDocument);
        RMAClassRepository classReposi = new RMAClassRepository();
        Element definitionElement = definitionDocument.getDocumentElement();
        Element conditionElement = conditionDocument.getDocumentElement();
        ((ClassRepository)classReposi).init(definitionElement, conditionElement);
        return new ClassRepositoryData(classReposi, definitionElement, conditionElement);
    }

    private void modifySavedTimeOnDefinitionDocument(Time aTime, Document aDoc) {
        Element theSaveElement = XMLUtil.getFirstElementNamed("SavedDate", (Element)aDoc.getFirstChild());
        if (theSaveElement != null) {
            theSaveElement.setAttribute("date", aTime.getString());
        }
    }

    private ConstraintModel createConstraintModel(Node constraintsNode) {
        List<Constraint> constraints = null;
        try {
            if (constraintsNode != null) {
                ConstraintReader reader = ConstraintReaderImpl.getInstance(constraintsNode);
                constraints = reader.findAllConstraints();
            }
        }
        catch (EreException e) {
            ExceptionUtil.handleException(e, "service", 1, "Failed to initialize constraints.", false);
        }
        ConstraintModel model = constraints != null ? ConstraintModel.createModelFromValues(constraints) : ConstraintModel.createEmptyModel();
        model.resetModified();
        return model;
    }

    public static class ClassRepositoryData {
        private ClassRepository myClassRepository;
        private Element myDefinitionElement;
        private Element myConditionElement;

        ClassRepositoryData(ClassRepository repository, Element definitionElement, Element conditionElement) {
            this.myClassRepository = repository;
            this.myDefinitionElement = definitionElement;
            this.myConditionElement = conditionElement;
        }

        public ClassRepository getClassRepository() {
            return this.myClassRepository;
        }

        public Element getDefinitionElement() {
            return this.myDefinitionElement;
        }

        public Element getConditionElement() {
            return this.myConditionElement;
        }
    }
}

