/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui;

import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import ericsson.ere.util.StringUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class ConstraintSpecificationNode {
    private List<ConstraintSpecificationNode> myChildren = new ArrayList<ConstraintSpecificationNode>();
    private ConstraintSpecificationNode myParent = null;
    private ConstraintSpecification mySpec;

    ConstraintSpecificationNode(ConstraintSpecification spec) {
        this.mySpec = spec;
    }

    void addChild(ConstraintSpecificationNode child) {
        this.myChildren.add(child);
        child.myParent = this;
    }

    public String toString() {
        return this.asString(0);
    }

    private String asString(int indent) {
        StringBuilder builder = new StringBuilder(this.spaces(indent));
        builder.append(this.mySpec.toString());
        if (this.myChildren.size() > 0) {
            builder.append(" >[\n");
            for (int i = 0; i < this.myChildren.size(); ++i) {
                builder.append(this.myChildren.get(i).asString(indent + 2));
            }
            builder.append("\n").append(this.spaces(indent)).append("]");
        }
        return builder.toString();
    }

    private String spaces(int count) {
        return StringUtil.repeat(" ", count);
    }

    static ConstraintSpecificationNode createContextItemTypeTree(Set<ConstraintSpecification> specifications) {
        ConstraintSpecificationNode tree = new ConstraintSpecificationNode(ConstraintSpecification.of(null, new ConstraintContextItemType[0]));
        ArrayList<ConstraintSpecification> left = new ArrayList<ConstraintSpecification>(specifications);
        while (left.size() > 0) {
            int sizeBefore = left.size();
            for (int i = left.size() - 1; i >= 0; --i) {
                ConstraintSpecification twc = (ConstraintSpecification)left.get(i);
                if (!ConstraintSpecificationNode.tryAttachToTree(tree, twc)) continue;
                left.remove(i);
            }
            int sizeAfter = left.size();
            if (sizeAfter != sizeBefore) continue;
            throw new RuntimeException("Didn't attach any to the tree...");
        }
        return tree;
    }

    private static boolean tryAttachToTree(ConstraintSpecificationNode tree, ConstraintSpecification twc) {
        ConstraintSpecificationNode parent = ConstraintSpecificationNode.findAddLocation(tree, twc.getContextItemTypes(), twc.getTargetType());
        boolean success = false;
        if (parent != null) {
            parent.addChild(new ConstraintSpecificationNode(twc));
            success = true;
        }
        return success;
    }

    private static ConstraintSpecificationNode findAddLocation(ConstraintSpecificationNode node, Set<ConstraintContextItemType> context, ConstraintTargetType target) {
        ConstraintSpecificationNode foundNode;
        block6: {
            EnumSet<ConstraintContextItemType> contextCopy = ConstraintSpecificationNode.copyOfSet(node.mySpec.getContextItemTypes(), ConstraintContextItemType.class);
            foundNode = null;
            boolean goOnAndSearch = true;
            ConstraintTargetType targetType = node.mySpec.getTargetType();
            if (targetType != null) {
                ConstraintContextItemType itemType = ConstraintSpecificationNode.targetTypeToItem(targetType);
                if (itemType != null) {
                    contextCopy.add(itemType);
                } else {
                    goOnAndSearch = false;
                }
            }
            if (!goOnAndSearch) break block6;
            if (contextCopy.equals(context)) {
                foundNode = node;
            } else {
                ConstraintSpecificationNode child;
                Iterator<ConstraintSpecificationNode> iterator = node.myChildren.iterator();
                while (iterator.hasNext() && (foundNode = ConstraintSpecificationNode.findAddLocation(child = iterator.next(), context, target)) == null) {
                }
            }
        }
        return foundNode;
    }

    static List<ConstraintSpecificationNode> findBranchesContaining(ConstraintSpecificationNode tree, ConstraintSpecification target) {
        ArrayList<ConstraintSpecificationNode> nodes = new ArrayList<ConstraintSpecificationNode>();
        for (ConstraintSpecificationNode branch : tree.myChildren) {
            if (!ConstraintSpecificationNode.branchContainsSpecification(branch, target)) continue;
            nodes.add(branch);
        }
        return nodes;
    }

    private static boolean branchContainsSpecification(ConstraintSpecificationNode branch, ConstraintSpecification target) {
        boolean contains = false;
        if (target.equals(branch.mySpec)) {
            contains = true;
        } else {
            for (ConstraintSpecificationNode child : branch.myChildren) {
                if (!ConstraintSpecificationNode.branchContainsSpecification(child, target)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    static ConstraintContextItemType targetTypeToItem(ConstraintTargetType targetType) {
        switch (targetType) {
            case FIELD: {
                return ConstraintContextItemType.FIELD;
            }
            case CONDITION: {
                return ConstraintContextItemType.CONDITION;
            }
            case MODIFIER: {
                return ConstraintContextItemType.MODIFIER;
            }
            case OPERATION: {
                return ConstraintContextItemType.OPERATION;
            }
        }
        return null;
    }

    private static <T extends Enum<T>> EnumSet<T> copyOfSet(Set<T> set, Class<T> enumClass) {
        EnumSet<T> copy = set.isEmpty() ? EnumSet.noneOf(enumClass) : EnumSet.copyOf(set);
        return copy;
    }

    ConstraintSpecification getSpecification() {
        return this.mySpec;
    }

    ConstraintSpecificationNode getParent() {
        return this.myParent;
    }

    List<ConstraintSpecificationNode> getChildren() {
        return this.myChildren;
    }
}

