/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.PluginConstrainableTableModel;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.PluginConstraintDialogDataSource;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.actions.ConstraintActionHandler;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.actions.ConstraintActionHandlerImpl;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.management.Service;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class PluginConstraintGUIBuilder
extends JPanel {
    private static final long serialVersionUID = 1L;
    private PluginConstrainableTableModel myConstrainableTableModel;
    private ConstraintActionHandler myActionHandler;
    private JPanel myEditConstraintPanel;
    private JTable myConstrainableTable;
    private JTable myConstraintTable;
    private DefaultTableModel myConstraintTableModel;
    private EditAction myEditAction;
    private DeleteAction myDeleteAction;
    private AddAction myAddAction;
    private Service myService;

    public PluginConstraintGUIBuilder(PluginConstrainableTableModel model, Service service) {
        this.myConstrainableTableModel = model;
        this.myService = service;
        this.myActionHandler = new ConstraintActionHandlerImpl(model.getConstraintModel(), service);
        this.buildComponents();
    }

    private void buildComponents() {
        this.setLayout(new GridBagLayout());
        this.buildConstrainableTable();
        this.buildEditConstraintTable();
        this.setVisible(true);
    }

    private void buildConstrainableTable() {
        JPanel definedConstraintPanel = new JPanel();
        definedConstraintPanel.setLayout(new GridBagLayout());
        this.myConstrainableTable = new JTable(this.myConstrainableTableModel){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.myConstrainableTable.setSelectionMode(0);
        this.myConstrainableTable.getColumnModel().getColumn(0).setHeaderValue("Plugin Constraints");
        this.myConstrainableTable.getSelectionModel().addListSelectionListener(new ConstrainableValueChangedListener());
        DefaultTableCellRenderer constrainableTableRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderer.setToolTipText(null);
                Constrainable selectedConstrainable = (Constrainable)value;
                if (selectedConstrainable.isGeneral()) {
                    Font oldFont = renderer.getFont();
                    Font bold = new Font(oldFont.getName(), 1, oldFont.getSize());
                    renderer.setFont(bold);
                    renderer.setText(selectedConstrainable.toString());
                    this.setIcon(null);
                } else {
                    renderer.setText(selectedConstrainable.toString());
                }
                boolean inconsistentConstraint = false;
                for (Constraint con : PluginConstraintGUIBuilder.this.myConstrainableTableModel.getConstraintModel().getConstraintsForConstrainable(selectedConstrainable)) {
                    if (ConstraintService.doesPluginConstraintExistInService(con, PluginConstraintGUIBuilder.this.myService)) continue;
                    inconsistentConstraint = true;
                    break;
                }
                if (inconsistentConstraint) {
                    renderer.setIcon(RmaDefs.getImageIcon("warning16.png"));
                    renderer.setToolTipText("The constrainable '" + selectedConstrainable.getName() + "' has constraint targets that do not exist in the service");
                    inconsistentConstraint = false;
                } else {
                    renderer.setIcon(null);
                }
                return renderer;
            }
        };
        this.myConstrainableTable.getColumnModel().getColumn(0).setCellRenderer(constrainableTableRenderer);
        this.myConstrainableTable.setRowSorter(new TableRowSorter<PluginConstrainableTableModel>(this.myConstrainableTableModel));
        this.myConstrainableTable.setGridColor(Color.WHITE);
        this.myConstrainableTable.setFillsViewportHeight(true);
        this.myConstrainableTable.getTableHeader().setReorderingAllowed(false);
        this.myConstrainableTable.setName("PluginConstrainableTable");
        JScrollPane mainTableScroll = new JScrollPane(this.myConstrainableTable);
        definedConstraintPanel.add((Component)mainTableScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 10), 0, 0));
        this.add((Component)definedConstraintPanel, new GridBagConstraints(0, 0, 1, 1, 0.3, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void buildEditConstraintTable() {
        this.myEditConstraintPanel = new JPanel();
        this.myEditConstraintPanel.setLayout(new GridBagLayout());
        JToolBar constraintSettingsToolBar = new JToolBar();
        constraintSettingsToolBar.setFloatable(false);
        this.setUpAddAction(constraintSettingsToolBar);
        this.setUpEditAction(constraintSettingsToolBar);
        this.setUpDeleteAction(constraintSettingsToolBar);
        this.add((Component)constraintSettingsToolBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 10), 0, 0));
        this.myConstraintTableModel = new DefaultTableModel(0, 1);
        this.myConstraintTable = new JTable(this.myConstraintTableModel){

            @Override
            public boolean isCellEditable(int x, int y) {
                return false;
            }
        };
        this.myConstraintTable.getColumnModel().getColumn(0).setHeaderValue("Constraints");
        this.myConstraintTable.getTableHeader().setReorderingAllowed(false);
        this.myConstraintTable.setName("PluginConstraintTable");
        this.myConstraintTable.getSelectionModel().addListSelectionListener(new ConstraintValueChangedListener());
        this.myConstraintTable.setSelectionMode(2);
        this.myConstraintTable.getColumnModel().getColumn(0).setHeaderValue("Constraints");
        DefaultTableCellRenderer constraintTableRenderer = new DefaultTableCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                renderer.setToolTipText(value.toString());
                int selectedRow = PluginConstraintGUIBuilder.this.myConstrainableTable.getSelectedRow();
                Constraint selectedConstraint = (Constraint)value;
                if (selectedRow > -1) {
                    boolean existInService;
                    if (selectedConstraint.getConstrainable().isGeneral()) {
                        Font oldFont = renderer.getFont();
                        Font italic = new Font(oldFont.getName(), 2, oldFont.getSize());
                        renderer.setFont(italic);
                        renderer.setIcon(null);
                    }
                    if (existInService = ConstraintService.doesPluginConstraintExistInService(selectedConstraint, PluginConstraintGUIBuilder.this.myService)) {
                        renderer.setIcon(null);
                        renderer.setText(selectedConstraint.toString());
                    } else {
                        renderer.setIcon(RmaDefs.getImageIcon("warning16.png"));
                        renderer.setToolTipText("Constraint '" + selectedConstraint + "' are not consistent with the service");
                    }
                }
                return renderer;
            }
        };
        this.myConstraintTable.getColumnModel().getColumn(0).setCellRenderer(constraintTableRenderer);
        JScrollPane settingsScroll = new JScrollPane(this.myConstraintTable);
        this.myEditConstraintPanel.add((Component)settingsScroll, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 10, 5, 5), 1, 1));
        this.add((Component)this.myEditConstraintPanel, new GridBagConstraints(1, 0, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void setUpEditAction(JToolBar constraintSettingsToolBar) {
        JButton editButton = new JButton();
        editButton.setName("PluginConstraintEditButton");
        this.myEditAction = new EditAction(RmaDefs.getImageIcon("new_edit.gif"), "Edit settings for constraint");
        editButton.setAction(this.myEditAction);
        this.myEditAction.setEnabled(false);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 128), "enter");
        this.getActionMap().put("enter", this.myEditAction);
        constraintSettingsToolBar.add(editButton);
    }

    private void setUpDeleteAction(JToolBar constraintSettingsToolBar) {
        JButton deleteButton = new JButton();
        deleteButton.setName("PluginConstraintDeleteButton");
        this.myDeleteAction = new DeleteAction(RmaDefs.getImageIcon("new_delete.gif"), "Deletes the selected constraint(s)");
        deleteButton.setAction(this.myDeleteAction);
        this.myDeleteAction.setEnabled(false);
        this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.getActionMap().put("delete", this.myDeleteAction);
        constraintSettingsToolBar.add(deleteButton);
    }

    private void setUpAddAction(JToolBar constraintSettingsToolBar) {
        JButton addButton = new JButton();
        addButton.setName("PluginConstraintAddButton");
        this.myAddAction = new AddAction(RmaDefs.getImageIcon("new_add.gif"), "Add a new constraint");
        addButton.setAction(this.myAddAction);
        constraintSettingsToolBar.add(addButton);
    }

    private void printNotDeletedConstraints(int constraintsDeleted, int numberOfSelectedConstraints, Constrainable selectedConstrainable, List<Constraint> notDeletedConstraints) {
        if (constraintsDeleted != numberOfSelectedConstraints && !selectedConstrainable.isGeneral()) {
            int printedRows = 0;
            String namesOfNotDeletedConstraints = "";
            for (Constraint constraint : notDeletedConstraints) {
                if (printedRows > 3) continue;
                namesOfNotDeletedConstraints = namesOfNotDeletedConstraints + constraint.toString() + "\n";
                if (++printedRows != 3) continue;
                namesOfNotDeletedConstraints = namesOfNotDeletedConstraints + "...";
                break;
            }
            DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Constraints deleted", "Did not delete general constraints: \n\n" + namesOfNotDeletedConstraints);
        }
    }

    protected static int findRowInTableModel(TableModel model, Object object, int column) {
        int row = -1;
        for (int i = 0; i < model.getRowCount() && row < 0; ++i) {
            if (!model.getValueAt(i, column).equals(object)) continue;
            row = i;
        }
        return row;
    }

    private int findConstrainableRow(Constrainable constrainableToMatch) {
        int row = -1;
        for (int i = 0; i < this.myConstrainableTable.getRowCount() && row < 0; ++i) {
            if (!this.myConstrainableTable.getValueAt(i, 0).equals(constrainableToMatch)) continue;
            row = i;
        }
        return row;
    }

    private void clearConstraintTableValues() {
        this.myConstraintTableModel.getDataVector().clear();
        this.myConstraintTableModel.fireTableDataChanged();
        this.myConstraintTable.getColumnModel().getColumn(0).setHeaderValue("Constraints");
        this.myConstraintTable.getTableHeader().repaint();
    }

    protected void setFirstRowSelected() {
        if (this.myConstrainableTable.getRowCount() > 0) {
            this.myConstrainableTable.setRowSelectionInterval(0, 0);
        } else {
            this.clearConstraintTableValues();
        }
        if (this.myConstraintTable.getRowCount() > 0) {
            this.myConstraintTable.setRowSelectionInterval(0, 0);
        }
    }

    private class ConstraintValueChangedListener
    implements ListSelectionListener {
        private ConstraintValueChangedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int numberOfSelectedConstraints = PluginConstraintGUIBuilder.this.myConstraintTable.getSelectedRows().length;
            int selectedRow = PluginConstraintGUIBuilder.this.myConstraintTable.getSelectedRow();
            Constraint selectedConstraint = null;
            Constrainable selectedConstrainable = null;
            if (selectedRow != -1) {
                selectedConstraint = (Constraint)PluginConstraintGUIBuilder.this.myConstraintTable.getValueAt(selectedRow, 0);
                selectedConstrainable = (Constrainable)PluginConstraintGUIBuilder.this.myConstrainableTable.getValueAt(PluginConstraintGUIBuilder.this.myConstrainableTable.getSelectedRow(), 0);
            }
            if (numberOfSelectedConstraints > 1) {
                PluginConstraintGUIBuilder.this.myEditAction.setEnabled(false);
                PluginConstraintGUIBuilder.this.myDeleteAction.setEnabled(true);
            } else if (selectedConstraint == null) {
                PluginConstraintGUIBuilder.this.myDeleteAction.setEnabled(false);
                PluginConstraintGUIBuilder.this.myEditAction.setEnabled(false);
            } else if (!selectedConstrainable.isGeneral() && selectedConstraint.getConstrainable().isGeneral()) {
                PluginConstraintGUIBuilder.this.myEditAction.setEnabled(false);
                PluginConstraintGUIBuilder.this.myDeleteAction.setEnabled(false);
            } else if (selectedConstrainable.isGeneral()) {
                PluginConstraintGUIBuilder.this.myEditAction.setEnabled(false);
                PluginConstraintGUIBuilder.this.myDeleteAction.setEnabled(true);
            } else {
                PluginConstraintGUIBuilder.this.myEditAction.setEnabled(true);
                PluginConstraintGUIBuilder.this.myDeleteAction.setEnabled(true);
            }
        }
    }

    private class ConstrainableValueChangedListener
    implements ListSelectionListener {
        private ConstrainableValueChangedListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = PluginConstraintGUIBuilder.this.myConstrainableTable.getSelectedRow();
            if (PluginConstraintGUIBuilder.this.myConstrainableTable.getRowCount() > 0 && selectedRow != -1) {
                Constrainable selectedId = (Constrainable)PluginConstraintGUIBuilder.this.myConstrainableTable.getValueAt(selectedRow, 0);
                List<Constraint> constraints = PluginConstraintGUIBuilder.this.myConstrainableTableModel.getConstraintModel().getConstraintsForConstrainable(selectedId);
                PluginConstraintGUIBuilder.this.clearConstraintTableValues();
                for (Constraint con : constraints) {
                    PluginConstraintGUIBuilder.this.myConstraintTableModel.addRow(new Vector<Constraint>(Arrays.asList(con)));
                }
                if (PluginConstraintGUIBuilder.this.myConstraintTable.getRowCount() > 0) {
                    PluginConstraintGUIBuilder.this.myConstraintTable.setRowSelectionInterval(0, 0);
                    String fieldName = "Constraints for '" + selectedId.toString() + "'";
                    PluginConstraintGUIBuilder.this.myConstraintTable.getColumnModel().getColumn(0).setHeaderValue(fieldName);
                    PluginConstraintGUIBuilder.this.myConstraintTable.getTableHeader().repaint();
                }
            }
        }
    }

    class EditAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public EditAction(ImageIcon icon, String desc) {
            super("", icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedConstrainableRow = PluginConstraintGUIBuilder.this.myConstrainableTable.getSelectedRow();
            int selectedConstraintRow = PluginConstraintGUIBuilder.this.myConstraintTable.getSelectedRow();
            if (selectedConstrainableRow > -1) {
                Constraint selectedConstraint = (Constraint)PluginConstraintGUIBuilder.this.myConstraintTable.getValueAt(PluginConstraintGUIBuilder.this.myConstraintTable.getSelectedRow(), 0);
                Constraint resultingConstraint = PluginConstraintGUIBuilder.this.myActionHandler.showConstraintSettingDialog(selectedConstraint, new PluginConstraintDialogDataSource());
                if (resultingConstraint != null) {
                    int constrainableRow = PluginConstraintGUIBuilder.this.findConstrainableRow(resultingConstraint.getConstrainable());
                    selectedConstrainableRow = constrainableRow >= 0 ? constrainableRow : 0;
                    int row = PluginConstraintGUIBuilder.findRowInTableModel(PluginConstraintGUIBuilder.this.myConstraintTableModel, resultingConstraint, 0);
                    selectedConstraintRow = row >= 0 ? row : 0;
                }
                PluginConstraintGUIBuilder.this.myConstrainableTable.setRowSelectionInterval(selectedConstrainableRow, selectedConstrainableRow);
                PluginConstraintGUIBuilder.this.myConstraintTable.setRowSelectionInterval(selectedConstraintRow, selectedConstraintRow);
            }
        }
    }

    class AddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public AddAction(ImageIcon icon, String desc) {
            super("", icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Constraint resultingConstraint = PluginConstraintGUIBuilder.this.myActionHandler.showAddConstraintDialog(new PluginConstraintDialogDataSource());
            int constrainableRowToSelect = PluginConstraintGUIBuilder.this.myConstrainableTable.getSelectedRow();
            int constraintRowToSelect = 0;
            if (constrainableRowToSelect == -1) {
                constrainableRowToSelect = 0;
            }
            if (constraintRowToSelect == -1) {
                constraintRowToSelect = 0;
            }
            if (resultingConstraint != null) {
                Constrainable resultingConstrainable = resultingConstraint.getConstrainable();
                int row = PluginConstraintGUIBuilder.this.findConstrainableRow(resultingConstrainable);
                if (row >= 0) {
                    constrainableRowToSelect = row;
                }
                PluginConstraintGUIBuilder.this.myConstrainableTable.setRowSelectionInterval(constrainableRowToSelect, constrainableRowToSelect);
                row = PluginConstraintGUIBuilder.findRowInTableModel(PluginConstraintGUIBuilder.this.myConstraintTableModel, resultingConstraint, 0);
                constraintRowToSelect = row >= 0 ? row : PluginConstraintGUIBuilder.this.myConstraintTable.getRowCount();
                PluginConstraintGUIBuilder.this.myConstraintTable.setRowSelectionInterval(constraintRowToSelect, constraintRowToSelect);
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction(ImageIcon icon, String desc) {
            super("", icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedConstraintRow = PluginConstraintGUIBuilder.this.myConstraintTable.getSelectedRow();
            int selectedConstrainableRow = PluginConstraintGUIBuilder.this.myConstrainableTable.getSelectedRow();
            int[] rows = PluginConstraintGUIBuilder.this.myConstraintTable.getSelectedRows();
            boolean delete = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Remove Constraint", "Are you sure you want to delete the selected constraint(s)?");
            if (delete) {
                Constrainable selectedConstrainable = null;
                ArrayList<Constraint> notDeletedConstraints = new ArrayList<Constraint>();
                int constraintsDeleted = 0;
                int numberOfSelectedConstraints = rows.length;
                selectedConstrainable = (Constrainable)PluginConstraintGUIBuilder.this.myConstrainableTable.getValueAt(PluginConstraintGUIBuilder.this.myConstrainableTable.getSelectedRow(), 0);
                for (int i = 0; i < numberOfSelectedConstraints; ++i) {
                    Constraint con = (Constraint)PluginConstraintGUIBuilder.this.myConstraintTable.getValueAt(rows[i], 0);
                    if (selectedConstrainable.isGeneral()) {
                        PluginConstraintGUIBuilder.this.myActionHandler.deleteConstraint(con);
                        ++constraintsDeleted;
                        continue;
                    }
                    if (!con.getConstrainable().isGeneral()) {
                        PluginConstraintGUIBuilder.this.myActionHandler.deleteConstraint(con);
                        ++constraintsDeleted;
                        continue;
                    }
                    notDeletedConstraints.add(con);
                }
                PluginConstraintGUIBuilder.this.printNotDeletedConstraints(constraintsDeleted, numberOfSelectedConstraints, selectedConstrainable, notDeletedConstraints);
                int constrainableRowCount = PluginConstraintGUIBuilder.this.myConstrainableTable.getRowCount();
                int constraintRowCount = PluginConstraintGUIBuilder.this.myConstraintTable.getRowCount();
                if (constrainableRowCount > 0 && constraintRowCount > 1) {
                    if (selectedConstrainableRow < constrainableRowCount) {
                        PluginConstraintGUIBuilder.this.myConstrainableTable.setRowSelectionInterval(selectedConstrainableRow, selectedConstrainableRow);
                    } else if (selectedConstrainableRow == constrainableRowCount) {
                        PluginConstraintGUIBuilder.this.myConstrainableTable.setRowSelectionInterval(selectedConstrainableRow - 1, selectedConstrainableRow - 1);
                    } else {
                        PluginConstraintGUIBuilder.this.myConstrainableTable.setRowSelectionInterval(0, 0);
                    }
                    if (selectedConstraintRow == constraintRowCount - 1) {
                        PluginConstraintGUIBuilder.this.myConstraintTable.setRowSelectionInterval(selectedConstraintRow - 1, selectedConstraintRow - 1);
                    } else {
                        PluginConstraintGUIBuilder.this.myConstraintTable.setRowSelectionInterval(0, 0);
                    }
                } else {
                    PluginConstraintGUIBuilder.this.clearConstraintTableValues();
                    if (PluginConstraintGUIBuilder.this.myConstrainableTable.getRowCount() > 0) {
                        if (selectedConstrainableRow == PluginConstraintGUIBuilder.this.myConstrainableTable.getRowCount()) {
                            PluginConstraintGUIBuilder.this.myConstrainableTable.setRowSelectionInterval(selectedConstrainableRow - 1, selectedConstrainableRow - 1);
                        } else {
                            PluginConstraintGUIBuilder.this.myConstrainableTable.setRowSelectionInterval(selectedConstrainableRow, selectedConstrainableRow);
                        }
                    }
                }
            }
        }
    }
}

