/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.datarepository;

import com.ericsson.ere.defs.DataRepositoryModel;
import com.ericsson.ere.variable.DefaultVariableProducer;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.Variable;
import java.util.HashMap;
import java.util.Map;

final class DataRepositoryHelper {
    private DataRepositoryHelper() {
    }

    static String[] objectToValueStringArray(Object[] array, ValueClassFactory factory) {
        String[] stringArray = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            stringArray[i] = factory.makeValueString(array[i]);
        }
        return stringArray;
    }

    static Map<Object, Object> objectToValueStringMap(Map<Object, Object> map, ValueClassFactory kcf, ValueClassFactory vcf) {
        Map<Object, Object> resultMap = map;
        if (kcf != null || vcf != null) {
            resultMap = new HashMap<Object, Object>(map.size());
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object key = kcf == null ? entry.getKey() : kcf.makeValueString(entry.getKey());
                Object value = vcf == null ? entry.getValue() : vcf.makeValueString(entry.getValue());
                resultMap.put(key, value);
            }
        }
        return resultMap;
    }

    static class MultilineStringVariableProducer
    extends DefaultVariableProducer {
        private final boolean myEnableMultilineStringDetachedEditor;

        public MultilineStringVariableProducer(ClassRepository repository, boolean enableMultilineStringDetachedEditor) {
            super(repository);
            this.myEnableMultilineStringDetachedEditor = enableMultilineStringDetachedEditor;
        }

        @Override
        public Variable produceVariable(DataType dataType, Object value) {
            Variable var;
            if (dataType == DataType.STRING) {
                String defaultValue = value == null ? "" : String.valueOf(value);
                var = new MultilineStringVariable("Multiline variable", defaultValue){

                    @Override
                    protected Object parseValueToObject(String value) {
                        return value;
                    }
                };
                ((MultilineStringVariable)var).setDetachedEditorAvailable(this.myEnableMultilineStringDetachedEditor);
            } else {
                var = super.produceVariable(dataType, value);
            }
            return var;
        }
    }

    static class DataTypeLabeler
    implements TypedDropDownVariable.ItemLabeler<DataType> {
        DataTypeLabeler() {
        }

        @Override
        public String getDisplayStringFor(DataType dataType, int index) {
            return dataType.getTypeName();
        }
    }

    static class RepositoryDataTypeLabeler
    implements TypedDropDownVariable.ItemLabeler<DataRepositoryModel.RepositoryDataType> {
        RepositoryDataTypeLabeler() {
        }

        @Override
        public String getDisplayStringFor(DataRepositoryModel.RepositoryDataType repositoryDataType, int index) {
            String str = repositoryDataType.name().replace('_', ' ');
            return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
        }
    }
}

