/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts;

import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorNodeTransferable;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeTransferHandler;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.GuiUtil;
import java.awt.Point;
import java.util.List;
import javax.swing.DropMode;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class ContextDefinitionTree
extends JTree {
    public ContextDefinitionTree(ContextDefinitionTreeModel model, JTree fieldsTree) {
        super(model);
        this.setName("ServiceEditor.JTree.ContextDefinitionTree");
        this.enableDrop();
        GuiUtil.disableRootCollapse(this);
        GuiUtil.enableSelectionOnRightClick(this);
        GuiServiceCenter.getInstance().enableHelpKey(this, this.getClass().toString(), null);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private void enableDrop() {
        this.setTransferHandler(new DropTransferHandler());
        this.setDropMode(DropMode.ON);
    }

    private class DropTransferHandler
    extends ServiceEditorTreeTransferHandler {
        private DropTransferHandler() {
        }

        @Override
        protected boolean importDropData(TransferHandler.TransferSupport support) {
            boolean imported = false;
            if (this.canDrop(support)) {
                CommonLinkNode newLink;
                AbstractTreeNode original = this.getDraggedNode(support);
                AbstractTreeNode dropTarget = this.getDropTarget(support);
                if (original instanceof FieldNode) {
                    newLink = ((ContextDefinitionTreeModel)ContextDefinitionTree.this.getModel()).addNewFieldLinkNode(new TreePath(dropTarget.getPath()), original);
                } else if (original instanceof HierarchicalFieldNode) {
                    newLink = ((ContextDefinitionTreeModel)ContextDefinitionTree.this.getModel()).addNewHierarchicalFieldLinkNode(new TreePath(dropTarget.getPath()), original);
                } else if (original instanceof FieldGroupNode) {
                    newLink = ((ContextDefinitionTreeModel)ContextDefinitionTree.this.getModel()).addNewFieldGroupLinkNode(new TreePath(dropTarget.getPath()), original);
                } else {
                    throw new AssertionError((Object)("Unrecognized target type: " + original.getClass()));
                }
                TreePath linkPath = new TreePath(newLink.getPath());
                support.getComponent().requestFocusInWindow();
                ContextDefinitionTree.this.setSelectionPath(linkPath);
                imported = true;
            }
            return imported;
        }

        @Override
        protected boolean canDrop(TransferHandler.TransferSupport support) {
            boolean drop = false;
            if (support.isDataFlavorSupported(ServiceEditorNodeTransferable.NODE_FLAVOR)) {
                AbstractTreeNode draggedNode = this.getDraggedNode(support);
                if (draggedNode instanceof FieldNode || draggedNode instanceof HierarchicalFieldNode) {
                    AbstractTreeNode dropTarget = this.getDropTarget(support);
                    drop = dropTarget != null && this.fieldCanBeDroppedAt(draggedNode, dropTarget);
                } else if (draggedNode instanceof FieldGroupNode) {
                    AbstractTreeNode dropTarget = this.getDropTarget(support);
                    drop = dropTarget != null && this.groupCanBeDroppedAt(draggedNode, dropTarget);
                }
            }
            return drop;
        }

        private AbstractTreeNode getDropTarget(TransferHandler.TransferSupport support) {
            Point loc = support.getDropLocation().getDropPoint();
            JTree tree = (JTree)support.getComponent();
            TreePath pathToDropOn = tree.getPathForLocation(loc.x, loc.y);
            return pathToDropOn != null ? (AbstractTreeNode)pathToDropOn.getLastPathComponent() : null;
        }

        private AbstractTreeNode getDraggedNode(TransferHandler.TransferSupport support) throws AssertionError {
            try {
                return (AbstractTreeNode)support.getTransferable().getTransferData(ServiceEditorNodeTransferable.NODE_FLAVOR);
            }
            catch (Exception ex) {
                throw new AssertionError((Object)("Error when getting transfer data, should not happen: " + ex.getMessage()));
            }
        }

        private boolean fieldCanBeDroppedAt(AbstractTreeNode fieldNode, AbstractTreeNode target) {
            boolean result = false;
            ContextNode contextNode = this.getContextNodeForNode(target);
            if (contextNode != null) {
                result = !this.isReferredToUnderContext(contextNode, fieldNode);
            }
            return result;
        }

        private boolean groupCanBeDroppedAt(AbstractTreeNode groupNode, AbstractTreeNode target) {
            boolean result = false;
            ContextNode contextNode = this.getContextNodeForNode(target);
            if (contextNode != null) {
                result = !this.isReferredToUnderContext(contextNode, groupNode);
            }
            return result;
        }

        private ContextNode getContextNodeForNode(AbstractTreeNode target) {
            AbstractTreeNode context;
            for (context = target; context != null && !(context instanceof ContextNode); context = (AbstractTreeNode)context.getParent()) {
            }
            return (ContextNode)context;
        }

        private boolean isReferredToUnderContext(ContextNode context, AbstractTreeNode target) {
            boolean referrerFound = false;
            List<AbstractTreeNode> referrers = target.getReferrers();
            for (AbstractTreeNode referrer : referrers) {
                if (!context.isNodeDescendant(referrer)) continue;
                referrerFound = true;
                break;
            }
            return referrerFound;
        }
    }
}

