/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts;

import com.ericsson.ere.gui.editors.serviceeditor.NameRepositories;
import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.TreeNodeChangeTracker;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldTopNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import com.ericsson.ere.util.CountedObjectRepository;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public class ContextDefinitionTreeModel
extends ServiceEditorTreeModel {
    private CountedObjectRepository<String> myContextNameRepository;
    private boolean myAddChildOrderEnabled = true;
    private FieldsDefinitionTreeModel myFieldsModel;

    public ContextDefinitionTreeModel(AbstractTreeNode topNode, NameRepositories repositories, FieldsDefinitionTreeModel fieldsModel) {
        super(topNode);
        this.myContextNameRepository = repositories.getContextNameRepository();
        this.myFieldsModel = fieldsModel;
        topNode.setTreeModel(this);
        new TreeNodeChangeTracker(this);
    }

    public FieldsDefinitionTreeModel getFieldsModel() {
        return this.myFieldsModel;
    }

    private void addNode(AbstractTreeNode newNode, TreePath thePath) {
        if (thePath != null) {
            boolean allowsChildren;
            AbstractTreeNode parentNode = (AbstractTreeNode)thePath.getLastPathComponent();
            int index = this.myAddChildOrderEnabled ? 0 : parentNode.getChildCount();
            boolean isSameType = parentNode.getClass() == newNode.getClass();
            boolean isNonNestable = parentNode instanceof ContextNode;
            boolean bl = allowsChildren = !(parentNode instanceof CommonLinkNode);
            if (!allowsChildren || isNonNestable && isSameType) {
                AbstractTreeNode currentNode = parentNode;
                parentNode = (AbstractTreeNode)parentNode.getParent();
                index = parentNode.getIndex(currentNode) + 1;
            }
            this.insertNodeInto(newNode, parentNode, index);
            this.reload(parentNode);
        }
    }

    public void deleteNode(TreePath thePath) {
        AbstractTreeNode theNode = (AbstractTreeNode)thePath.getLastPathComponent();
        if (!(theNode instanceof ContextTopNode) && !(theNode instanceof FieldTopNode)) {
            this.removeNodeFromParent(theNode);
        }
    }

    public boolean isTreeValid() {
        return ((AbstractTreeNode)this.root).isNodeValid();
    }

    public boolean moveUpOrDown(AbstractTreeNode aNode, boolean up) {
        int newIndex = -1;
        if (aNode == null) {
            return false;
        }
        DefaultMutableTreeNode theParent = (DefaultMutableTreeNode)aNode.getParent();
        if (up && theParent.getIndex(aNode) > 0) {
            newIndex = theParent.getIndex(aNode) - 1;
        } else if (!up && theParent.getIndex(aNode) < theParent.getChildCount() - 1) {
            newIndex = theParent.getIndex(aNode) + 1;
        }
        if (newIndex >= 0) {
            this.removeNodeFromParent(aNode);
            this.insertNodeInto(aNode, theParent, newIndex);
            return true;
        }
        return false;
    }

    public boolean moveIntoGroup(AbstractTreeNode currentNode) {
        DefaultMutableTreeNode nextNode;
        for (nextNode = currentNode.getNextSibling(); nextNode != null && nextNode instanceof FieldNode; nextNode = nextNode.getNextNode()) {
        }
        if (nextNode != null && nextNode instanceof ContextGroupNode) {
            this.removeNodeFromParent(currentNode);
            this.insertNodeInto(currentNode, nextNode, 0);
            return true;
        }
        return false;
    }

    public boolean moveOutOfGroup(AbstractTreeNode currentNode) {
        DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)currentNode.getParent();
        if (nextNode != null && nextNode instanceof ContextGroupNode) {
            int index = nextNode.getParent().getIndex(nextNode);
            this.removeNodeFromParent(currentNode);
            this.insertNodeInto(currentNode, (MutableTreeNode)nextNode.getParent(), index);
            return true;
        }
        return false;
    }

    public ContextNode addNewContextNode(TreePath treePath) {
        this.checkContextNodeParent(treePath);
        ContextNode newNode = new ContextNode(this.myContextNameRepository);
        return this.addNodeAndReturn(newNode, treePath);
    }

    public ContextNode addNewContextNode(TreePath treePath, Element configElement) {
        this.checkContextNodeParent(treePath);
        ContextNode newNode = new ContextNode(this.myContextNameRepository, configElement.getAttributes());
        return this.addNodeAndReturn(newNode, treePath);
    }

    private void checkContextNodeParent(TreePath parentPath) {
        Object parent = parentPath.getLastPathComponent();
        if (!(parent instanceof ContextTopNode) && !(parent instanceof ContextNode)) {
            throw new IllegalArgumentException("ContextNode parent must be ContextTopNode or ContextNode.");
        }
    }

    public ContextGroupNode addNewContextGroupNode(TreePath parentPath) {
        this.checkGroupNodeParent(parentPath);
        ContextGroupNode newNode = new ContextGroupNode();
        return this.addNodeAndReturn(newNode, parentPath);
    }

    public ContextGroupNode addNewContextGroupNode(TreePath parentPath, Element configElement) {
        this.checkGroupNodeParent(parentPath);
        ContextGroupNode newNode = new ContextGroupNode(configElement.getAttributes());
        return this.addNodeAndReturn(newNode, parentPath);
    }

    private void checkGroupNodeParent(TreePath parentPath) {
        Object parent = parentPath.getLastPathComponent();
        if (!(parent instanceof ContextNode) && !(parent instanceof ContextGroupNode)) {
            throw new IllegalArgumentException("Parent must be ContextGroupNode or ContextNode.");
        }
    }

    public FieldLinkNode addNewFieldLinkNode(TreePath treePath, Element configElement) {
        this.checkLinkNodeParent(treePath);
        FieldLinkNode newNode = new FieldLinkNode(configElement.getAttributes());
        return this.addNodeAndReturn(newNode, treePath);
    }

    public FieldLinkNode addNewFieldLinkNode(TreePath treePath, AbstractTreeNode linkTarget) {
        this.checkLinkNodeParent(treePath);
        FieldLinkNode newNode = new FieldLinkNode((FieldNode)linkTarget);
        return this.addNodeAndReturn(newNode, treePath);
    }

    public FieldGroupLinkNode addNewFieldGroupLinkNode(TreePath treePath, AbstractTreeNode linkTarget) {
        this.checkLinkNodeParent(treePath);
        FieldGroupLinkNode newNode = new FieldGroupLinkNode((FieldGroupNode)linkTarget);
        return this.addNodeAndReturn(newNode, treePath);
    }

    public FieldGroupLinkNode addNewFieldGroupLinkNode(TreePath treePath, Element configElement) {
        this.checkLinkNodeParent(treePath);
        FieldGroupLinkNode newNode = new FieldGroupLinkNode(configElement);
        return this.addNodeAndReturn(newNode, treePath);
    }

    public HierarchicalFieldLinkNode addNewHierarchicalFieldLinkNode(TreePath treePath, AbstractTreeNode linkTarget) {
        this.checkLinkNodeParent(treePath);
        HierarchicalFieldLinkNode newNode = new HierarchicalFieldLinkNode((HierarchicalFieldNode)linkTarget);
        return this.addNodeAndReturn(newNode, treePath);
    }

    public HierarchicalFieldLinkNode addNewHierarchicalFieldLinkNode(TreePath treePath, Element config) {
        this.checkLinkNodeParent(treePath);
        HierarchicalFieldLinkNode newNode = new HierarchicalFieldLinkNode(config.getAttributes());
        return this.addNodeAndReturn(newNode, treePath);
    }

    private void checkLinkNodeParent(TreePath treePath) {
        Object parent = treePath.getLastPathComponent();
        if (parent instanceof ContextTopNode) {
            throw new IllegalArgumentException("Link node parent must not be ContextTopNode.");
        }
    }

    private <T extends AbstractTreeNode> T addNodeAndReturn(T newNode, TreePath parentPath) {
        this.addNode(newNode, parentPath);
        newNode.setTreeModel(this);
        return newNode;
    }

    public void setAddChildOrderEnabled(boolean enabled) {
        this.myAddChildOrderEnabled = enabled;
    }
}

