/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresMapField;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresSetField;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.PluginsTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.AbstractPluginTM;
import com.ericsson.ere.gui.editors.serviceeditor.plugins.nodes.BaseConditionTM;
import com.ericsson.ere.swing.TreeModelMonitor;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.util.Predicate;
import com.ericsson.ere.variable.UniqueStringVariable;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class FieldConditionNode
extends CommonLinkNode<BaseConditionTM> {
    private static final String NO_TARGET_NAME_YET = "";
    private static final String LABEL_CONDITION = "Condition";
    private static final String ATTR_NAME = "Name";
    private static final String ATTR_OBJECT = "Object";
    private static final String LABEL_NAME = "Name";
    private static final String TAG_CONDITION = "Condition";
    private ImageIcon myIcon = RmaDefs.getImageIcon("condition16.png");
    private FieldNode myFieldNode;

    public FieldConditionNode(FieldNode aFieldNode, CountedObjectRepository<String> conditionNameRepository) {
        super(NO_TARGET_NAME_YET);
        this.init(null, aFieldNode, conditionNameRepository);
    }

    public FieldConditionNode(NamedNodeMap attributes, FieldNode aFieldNode, CountedObjectRepository<String> conditionNameRepository) {
        super(FieldConditionNode.extractTargetName(attributes));
        this.init(attributes, aFieldNode, conditionNameRepository);
    }

    private static String extractTargetName(NamedNodeMap attributes) {
        String name = NO_TARGET_NAME_YET;
        if (attributes.getNamedItem(ATTR_OBJECT) != null) {
            name = attributes.getNamedItem(ATTR_OBJECT).getNodeValue();
        }
        return name;
    }

    private void init(NamedNodeMap attributes, FieldNode aFieldNode, CountedObjectRepository<String> conditionNameRepository) {
        this.myFieldNode = aFieldNode;
        String name = "[Unnamed]";
        if (attributes != null && attributes.getNamedItem("Name") != null) {
            name = attributes.getNamedItem("Name").getNodeValue();
        }
        UniqueStringVariable nameVar = new UniqueStringVariable("Name", name, conditionNameRepository);
        TypedDropDownVariable<TreeNode> conditionVar = new TypedDropDownVariable<TreeNode>("Condition", (T[])new TreeNode[0]);
        this.myVarList.add(nameVar);
        this.myVarList.add(conditionVar);
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        Element e = doc.createElement("Condition");
        e.setAttribute("Name", this.getName());
        e.setAttribute(ATTR_OBJECT, this.getCondition());
        return e;
    }

    @Override
    public void setTreeModel(DefaultTreeModel theModel) {
        this.updateConditionList(((FieldsDefinitionTreeModel)theModel).getPluginsModel());
        if (NO_TARGET_NAME_YET.equals(this.myTargetName)) {
            this.myTargetName = this.getCondition();
        }
        super.setTreeModel(theModel);
        new TreeModelMonitor(theModel, this).onRemove(new Runnable(){

            @Override
            public void run() {
                Variable nameVar = VarListUtil.getVariableForName(FieldConditionNode.this.myVarList, "Name");
                if (nameVar instanceof UniqueStringVariable) {
                    ((UniqueStringVariable)nameVar).detachFromRepository();
                }
            }
        }).onInsert(new Runnable(){

            @Override
            public void run() {
                Variable nameVar = VarListUtil.getVariableForName(FieldConditionNode.this.myVarList, "Name");
                if (nameVar instanceof UniqueStringVariable) {
                    ((UniqueStringVariable)nameVar).attachToRepository();
                }
            }
        });
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        return this.myIcon;
    }

    @Override
    public String getName() {
        return VarListUtil.getValueStringForName(this.myVarList, "Name");
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        super.setDataItem(reference, object);
        if ("Condition".equals(reference)) {
            BaseConditionTM newCondition = (BaseConditionTM)((Variable)object).getValueObject();
            this.switchTarget(newCondition);
        }
    }

    public String getCondition() {
        BaseConditionTM cond = this.getConditionNode();
        return cond != null ? cond.getName() : this.myTargetName;
    }

    private BaseConditionTM getConditionNode() {
        return (BaseConditionTM)VarListUtil.getValueForName(this.myVarList, "Condition");
    }

    public void updateConditionList(List<BaseConditionTM> conditionList) {
        BaseConditionTM selected = this.findCurrentCondition(conditionList);
        BaseConditionTM[] conditionArray = conditionList.toArray(new BaseConditionTM[conditionList.size()]);
        TypedDropDownVariable<BaseConditionTM> conditionVar = new TypedDropDownVariable<BaseConditionTM>("Condition", conditionArray, selected);
        VarListUtil.replaceVariableByLabel(this.myVarList, "Condition", conditionVar);
    }

    private BaseConditionTM findCurrentCondition(List<BaseConditionTM> conditionList) {
        BaseConditionTM selected = this.getConditionNode();
        if (selected == null) {
            String conditionName = this.myTargetName;
            for (BaseConditionTM cond : conditionList) {
                if (!conditionName.equals(cond.getName())) continue;
                selected = cond;
                break;
            }
        }
        if (selected == null && !conditionList.isEmpty()) {
            selected = conditionList.get(0);
        }
        return selected;
    }

    @Override
    public String toString() {
        Object target = this.getTarget();
        String targetRepr = target != null ? ((AbstractTreeNode)target).toString() : this.myTargetName;
        return this.getName() + " (" + targetRepr + ")";
    }

    @Override
    protected BaseConditionTM resolveTarget(DefaultTreeModel model, String name) {
        PluginsTreeModel pluginsModel = ((FieldsDefinitionTreeModel)model).getPluginsModel();
        return pluginsModel.findBaseCondition(name);
    }

    @Override
    protected void onTargetChange(String propertyName) {
        if ("Name".equals(propertyName) || "Alias".equals(propertyName)) {
            PluginsTreeModel pluginsModel = ((FieldsDefinitionTreeModel)this.getTreeModel()).getPluginsModel();
            this.updateConditionList(pluginsModel);
        }
    }

    private void updateConditionList(PluginsTreeModel model) {
        this.updateConditionList(this.findApplicableConditions(model));
    }

    private List<BaseConditionTM> findApplicableConditions(PluginsTreeModel model) {
        List<BaseConditionTM> conditions = model.findNodesOfType(BaseConditionTM.class);
        conditions = new ArrayList<BaseConditionTM>(CollectionUtils.filter(conditions, new BaseConditionFilter()));
        this.addCurrentCondition(model, conditions);
        Collections.sort(conditions, new BaseConditionComparator());
        return conditions;
    }

    private void addCurrentCondition(PluginsTreeModel model, List<BaseConditionTM> conditions) {
        BaseConditionTM current = this.getConditionNode();
        if (current == null) {
            String name = this.getCondition();
            current = model.findBaseCondition(name);
        }
        if (current != null && !conditions.contains(current)) {
            conditions.add(current);
        }
    }

    private class BaseConditionFilter
    implements Predicate<BaseConditionTM> {
        private BaseConditionFilter() {
        }

        @Override
        public boolean test(BaseConditionTM input) {
            return this.conditionMatchesField(input);
        }

        boolean conditionMatchesField(BaseConditionTM conditionNode) {
            Class<RequiresSetField> excludedAnnotation;
            Class complementaryAnnotation;
            Class requiredAnnotation;
            List<String> dataTypes = conditionNode.getDataTypeNames();
            String fieldType = FieldConditionNode.this.myFieldNode.getDataType();
            if (FieldConditionNode.this.myFieldNode.isValueList() || FieldConditionNode.this.myFieldNode.isValueMap()) {
                requiredAnnotation = RequiresMapField.class;
                complementaryAnnotation = RequiresNonMapField.class;
                excludedAnnotation = RequiresSetField.class;
            } else if (FieldConditionNode.this.myFieldNode.isValueSet()) {
                requiredAnnotation = RequiresSetField.class;
                complementaryAnnotation = null;
                excludedAnnotation = null;
            } else {
                requiredAnnotation = RequiresNonMapField.class;
                complementaryAnnotation = RequiresMapField.class;
                excludedAnnotation = RequiresSetField.class;
            }
            boolean match = false;
            if (dataTypes.contains("ANY") || dataTypes.contains(fieldType)) {
                Class<?> profileClass = this.getProfileClass(conditionNode);
                match = profileClass.isAnnotationPresent(requiredAnnotation);
                if (complementaryAnnotation != null) {
                    match |= !profileClass.isAnnotationPresent(complementaryAnnotation);
                }
                if (excludedAnnotation != null) {
                    match &= !profileClass.isAnnotationPresent(excludedAnnotation);
                }
            }
            return match;
        }

        private Class<?> getProfileClass(AbstractPluginTM conditionNode) {
            Class<?> clazz;
            String className = conditionNode.getProfileClassName();
            try {
                clazz = EreClassLoader.getClass(className);
            }
            catch (ClassNotFoundException ex) {
                clazz = null;
            }
            return clazz;
        }
    }

    private static class BaseConditionComparator
    implements Comparator<BaseConditionTM> {
        private BaseConditionComparator() {
        }

        @Override
        public int compare(BaseConditionTM o1, BaseConditionTM o2) {
            String d1 = o1.toString();
            String d2 = o2.toString();
            return d1.compareToIgnoreCase(d2);
        }
    }
}

