/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.ContextDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.CommonLinkNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.variable.CheckBoxListVariable;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.ElementIterator;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FieldGroupLinkNode
extends CommonLinkNode<FieldGroupNode> {
    private static final String NO_NAME = "";
    private static final FieldGroupNode.GroupType[] COMPLEX_GROUP_TYPES = new FieldGroupNode.GroupType[]{FieldGroupNode.GroupType.ARRAY_GROUP, FieldGroupNode.GroupType.MAP_GROUP};
    private static final String LABEL_TYPE = "Type";
    private static final String LABEL_NAME = "Name";
    private static final String LABEL_OTHER_FIELDS = "Optional fields";
    private static final String LABEL_KEY_FIELDS = "Key fields";
    private static ImageIcon ICON = RmaDefs.getImageIcon("folder_link16.png");
    private List<String> mySelectedFields;

    public FieldGroupLinkNode(FieldGroupNode target) {
        super(target);
        this.initVariables(target.getName(), target.getGroupType());
    }

    public FieldGroupLinkNode(Element config) {
        super(NO_NAME);
        String name = config.getAttribute(LABEL_NAME);
        String type = config.getAttribute(LABEL_TYPE);
        this.mySelectedFields = this.readSelectedFields(config);
        if (this.mySelectedFields.isEmpty()) {
            throw new IllegalArgumentException("Invalid XML: Group link must contain at least one selected field.");
        }
        this.initVariables(name, FieldGroupNode.GroupType.lookup(type));
    }

    private List<String> readSelectedFields(Element config) {
        NodeList fields = config.getElementsByTagName("Field");
        ArrayList<String> names = new ArrayList<String>();
        for (Element fieldElement : new ElementIterator(fields)) {
            names.add(fieldElement.getAttribute(LABEL_NAME));
        }
        return names;
    }

    private void initVariables(String name, FieldGroupNode.GroupType groupType) {
        StringVariable nameVar = new StringVariable(LABEL_NAME, name);
        TypedDropDownVariable<FieldGroupNode.GroupType> typeVar = new TypedDropDownVariable<FieldGroupNode.GroupType>(LABEL_TYPE, COMPLEX_GROUP_TYPES, groupType);
        ((Variable)typeVar).setAllowEdit(false);
        this.myVarList.add(nameVar);
        this.myVarList.add(typeVar);
        this.updateFieldListVariables();
    }

    @Override
    public void setTreeModel(DefaultTreeModel model) {
        super.setTreeModel(model);
        FieldsDefinitionTreeModel fieldsModel = ((ContextDefinitionTreeModel)model).getFieldsModel();
        fieldsModel.addTreeModelListener(new GroupFieldTracker());
        this.updateFieldListVariables();
    }

    private Variable createKeyFieldsVariable(List<AbstractTreeNode> keyFieldChildren) {
        AbstractTreeNode[] items = keyFieldChildren.toArray(new AbstractTreeNode[keyFieldChildren.size()]);
        CheckBoxListVariable<AbstractTreeNode> keyFieldsVar = new CheckBoxListVariable<AbstractTreeNode>(LABEL_KEY_FIELDS, items, items, new FieldGroupNode.NodeNameLabeler(), true, true);
        ((Variable)keyFieldsVar).setAllowEdit(false);
        return keyFieldsVar;
    }

    private Variable createOtherFieldsVariable(FieldGroupNode target, List<AbstractTreeNode> keyFieldChildren, FieldGroupNode.GroupType groupType) {
        ArrayList<TreeNode> otherFields = new ArrayList<TreeNode>(Collections.list(target.children()));
        otherFields.removeAll(keyFieldChildren);
        AbstractTreeNode[] otherItems = otherFields.toArray(new AbstractTreeNode[otherFields.size()]);
        boolean mustHaveSelection = groupType == FieldGroupNode.GroupType.ARRAY_GROUP;
        CheckBoxListVariable<AbstractTreeNode> otherFieldsVar = new CheckBoxListVariable<AbstractTreeNode>(LABEL_OTHER_FIELDS, otherItems, null, new FieldGroupNode.NodeNameLabeler(), true, mustHaveSelection);
        return otherFieldsVar;
    }

    @Override
    protected FieldGroupNode resolveTarget(DefaultTreeModel model, String name) {
        assert (this.mySelectedFields != null);
        FieldsDefinitionTreeModel fieldsModel = ((ContextDefinitionTreeModel)model).getFieldsModel();
        AbstractTreeNode firstField = fieldsModel.findField(this.mySelectedFields.get(0));
        return (FieldGroupNode)firstField.getParent();
    }

    @Override
    protected void onTargetChange(String propertyName) {
        if (LABEL_TYPE.equals(propertyName)) {
            VarListUtil.getVariableForName(this.myVarList, LABEL_TYPE).setValue((Object)((FieldGroupNode)this.getTarget()).getGroupType());
            this.updateFieldListVariables();
        } else if (LABEL_KEY_FIELDS.equals(propertyName) || "___varlistvalid".equals(propertyName)) {
            this.updateFieldListVariables();
        }
    }

    private void updateFieldListVariables() {
        FieldGroupNode target = (FieldGroupNode)this.getTarget();
        if (target != null) {
            String otherSelected = VarListUtil.getValueStringForName(this.myVarList, LABEL_OTHER_FIELDS);
            VarListUtil.removeVariablesByLabel((List<Variable>)this.myVarList, LABEL_KEY_FIELDS, LABEL_OTHER_FIELDS);
            if (target.isComplexGroup()) {
                Variable keyFieldsVar;
                List<AbstractTreeNode> keyFieldChildren;
                FieldGroupNode.GroupType groupType = target.getGroupType();
                if (groupType == FieldGroupNode.GroupType.MAP_GROUP) {
                    keyFieldChildren = target.getKeyFieldChildren();
                    keyFieldsVar = this.createKeyFieldsVariable(keyFieldChildren);
                } else {
                    keyFieldChildren = Collections.emptyList();
                    keyFieldsVar = null;
                }
                Variable otherFieldsVar = this.createOtherFieldsVariable(target, keyFieldChildren, groupType);
                if (keyFieldsVar != null) {
                    this.myVarList.add(keyFieldsVar);
                }
                this.myVarList.add(otherFieldsVar);
                if (this.mySelectedFields != null) {
                    String fieldsString = StringUtil.join(this.mySelectedFields.toArray(), ";");
                    otherFieldsVar.setValue(fieldsString);
                    this.mySelectedFields = null;
                } else if (otherSelected != null) {
                    otherFieldsVar.setValue(otherSelected);
                }
            }
            this.updateNode();
        }
    }

    @Override
    protected ImageIcon getNodeIcon(boolean expanded) {
        return ICON;
    }

    @Override
    public String getName() {
        return VarListUtil.getVariableForName(this.myVarList, LABEL_NAME).getValueString();
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        String[] fields;
        Element e = doc.createElement("Group");
        e.setAttribute(LABEL_NAME, this.getName());
        e.setAttribute(LABEL_TYPE, ((FieldGroupNode)this.getTarget()).getGroupType().toString());
        for (String field : fields = this.getAllSelectedFieldNames()) {
            Element fieldElement = doc.createElement("Field");
            fieldElement.setAttribute(LABEL_NAME, field);
            e.appendChild(fieldElement);
        }
        return e;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(" (selected fields: ");
        Object[] selected = this.getAllSelectedFieldNames();
        if (selected.length == 0) {
            builder.append("none");
        } else {
            builder.append(StringUtil.join(selected, ", "));
        }
        builder.append(")");
        return builder.toString();
    }

    private String[] getAllSelectedFieldNames() {
        Variable var = VarListUtil.getVariableForName(this.myVarList, LABEL_KEY_FIELDS);
        ArrayList<String> names = new ArrayList<String>(this.getFieldNames(var));
        var = VarListUtil.getVariableForName(this.myVarList, LABEL_OTHER_FIELDS);
        names.addAll(this.getFieldNames(var));
        return names.toArray(new String[names.size()]);
    }

    private List<String> getFieldNames(Variable var) {
        String[] fields;
        List<String> names = Collections.emptyList();
        if (!(var == null || (fields = StringUtil.splitSemiColonSeparatedString(var.getValueString())).length == 1 && NO_NAME.equals(fields[0]))) {
            names = Arrays.asList(fields);
        }
        return names;
    }

    private void updateNode() {
        DefaultTreeModel model = this.getTreeModel();
        if (model != null) {
            model.nodeChanged(this);
        }
    }

    private class GroupFieldTracker
    implements TreeModelListener {
        private GroupFieldTracker() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.handleInsertionOrRemoval(e);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            this.handleInsertionOrRemoval(e);
        }

        private void handleInsertionOrRemoval(TreeModelEvent e) {
            Object[] path = e.getPath();
            Object parent = path[path.length - 1];
            if (parent == FieldGroupLinkNode.this.getTarget()) {
                FieldGroupLinkNode.this.updateFieldListVariables();
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            Object[] path = e.getPath();
            AbstractTreeNode root = (AbstractTreeNode)path[path.length - 1];
            if (root.isNodeDescendant((DefaultMutableTreeNode)FieldGroupLinkNode.this.getTarget())) {
                FieldGroupLinkNode.this.updateFieldListVariables();
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            Object[] path = e.getPath();
            AbstractTreeNode root = (AbstractTreeNode)path[path.length - 1];
            if (root == FieldGroupLinkNode.this.getTarget()) {
                boolean selectedDidChange = false;
                List<String> selected = Arrays.asList(FieldGroupLinkNode.this.getAllSelectedFieldNames());
                for (Object child : e.getChildren()) {
                    if (!selected.contains(((AbstractTreeNode)child).getName())) continue;
                    selectedDidChange = true;
                    break;
                }
                if (selectedDidChange) {
                    FieldGroupLinkNode.this.updateNode();
                }
            }
        }
    }
}

