/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldConfig;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNodeHelper;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.CustomEditorInputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestriction;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.fieldutils.InputRestrictionType;
import com.ericsson.ere.swing.TreeModelMonitor;
import com.ericsson.ere.util.CountedObjectRepository;
import com.ericsson.ere.util.Transformer;
import com.ericsson.ere.variable.DefaultVariableProducer;
import com.ericsson.ere.variable.UniqueStringVariable;
import com.ericsson.ere.variable.VariableProducer;
import com.ericsson.vareditor.document.ClassNameDocument;
import ericsson.ere.datatype.Amount;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.factory.LazyEvaluatedEREDateClassFactory;
import ericsson.ere.datatype.factory.LazyEvaluatedERETimeClassFactory;
import ericsson.ere.datatype.interfaces.ValueClassFactory;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.documents.RegularExpressionMatcherDocument;
import ericsson.vareditor.documents.StringDocument;
import ericsson.vareditor.variable.AmountVariable;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.BackgroundCustomizableInfoVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.RangeObject;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class FieldNode
extends AbstractTreeNode {
    public static final String FIELD_SETTINGS_TAG = "FieldSettings";
    public static final String ALLOW_NEGATIVE_INPUT_TAG = "AllowNegativeInput";
    public static final String AMOUNT_FACTORY_CLASS_TAG = "AmountFactoryClass";
    public static final String ATTR_NAME = "Name";
    public static final String TAG_FIELD = "Field";
    private static final String LABEL_NAME = "Name";
    private static final String LABEL_TAG_NUMBER = "Tag number";
    private static final String LABEL_AUTOMAP_CONDITION = "Show in plugins";
    private static final String LABEL_COMMENT = "Comment";
    private static final String LABEL_VALUE_COLLECTION = "Collection";
    private static final String LABEL_DATA_TYPE = "Data type";
    private static final String LABEL_PARAMETER_TYPE = "Parameter type";
    private static final String LABEL_MANDATORY = "Mandatory";
    private static final String LABEL_DEFAULT = "Default";
    private static final String LABEL_INPUT_RESTRICTION = "Input restriction";
    private static final String LABEL_EDITOR_CLASS = "Editor class";
    private static final String LABEL_VALUE_CLASS = "Value class";
    private static final String LABEL_VALUE_CLASS_FACTORY = "Value class factory";
    private static final String LABEL_WARNING = "WARNING";
    private static final String LABEL_AMOUNT_FACTORY = "Amount Factory";
    private static final String LABEL_ALLOW_NEGATIVE = "Allow negative balance";
    private static final String LABEL_BEGINNING_OF_TIME = "Beginning of time";
    private static final String LABEL_END_OF_TIME = "End of time";
    private static final String LABEL_TOOLTIP = "Tooltip";
    private static final String LABEL_KEY = "Key";
    private static final Variable.InfoKey<Object> INPUTRESTRICTION_DATA_VARIABLE_MARKER = new Variable.InfoKey();
    private static final Variable.InfoKey<Boolean> AFFECTS_DEFAULT_VARIABLE = new Variable.InfoKey();
    private static final String MSG_DECIMAL_DATA_TYPE_DEPRECATED_FMT = "Data type '%s' is deprecated. Use RatingDecimal or Double instead.";
    private static final ImageIcon DFLT_ICON = RmaDefs.getImageIcon("cube_blue.png");
    private static final ImageIcon KEY_ICON = RmaDefs.getImageIcon("cube_blue_key.png");
    private DefaultTreeModel myModel;
    private DataType myCurrentDataType;
    private final FieldGroupNode.GroupType myWrappingGroupType;
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();
    private CountedObjectRepository<String> myNameRepository;
    private AbstractTreeNode myParent;

    public FieldNode(AbstractTreeNode parent, CountedObjectRepository<String> nameRepository, FieldGroupNode.GroupType groupType) {
        this(parent, nameRepository, new FieldConfig(groupType), groupType);
    }

    public FieldNode(CountedObjectRepository<String> nameRepository, FieldGroupNode.GroupType groupType) {
        this(null, nameRepository, new FieldConfig(groupType), groupType);
    }

    public FieldNode(AbstractTreeNode parent, CountedObjectRepository<String> nameRepository, NamedNodeMap attributes, NodeList additionalNodes, FieldGroupNode.GroupType groupType) {
        this(parent, nameRepository, new FieldConfig(attributes, additionalNodes, groupType), groupType);
    }

    public FieldNode(CountedObjectRepository<String> nameRepository, NamedNodeMap attributes, NodeList additionalNodes, FieldGroupNode.GroupType groupType) {
        this(null, nameRepository, new FieldConfig(attributes, additionalNodes, groupType), groupType);
    }

    private FieldNode(AbstractTreeNode parent, CountedObjectRepository<String> nameRepository, FieldConfig config, FieldGroupNode.GroupType groupType) {
        this.myParent = parent;
        this.myNameRepository = nameRepository;
        this.myWrappingGroupType = groupType;
        this.myCurrentDataType = config.getDataType();
        VariableHandler vc = this.createVariableHandler(config.getDataType());
        this.populateVariableList(vc.createVariables(config));
    }

    private void populateVariableList(List<Variable> variables) {
        this.updateAllowEdit(variables);
        UniqueStringVariable usv = (UniqueStringVariable)VarListUtil.getVariableForName(this.myVarList, "Name");
        if (usv != null) {
            usv.detachFromRepository();
        }
        try {
            this.disableValidityChangeEvents();
            this.myVarList.clear();
            this.myVarList.addAll(variables);
        }
        finally {
            this.enableValidityChangeEvents();
        }
    }

    public void setDialogFactory(DialogFactoryInterface factory) {
        if (factory != null) {
            this.myDialogFactory = factory;
        }
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        this.performPreSaveCleanup();
        Element temp = doc.createElement("dummy");
        FieldConfig config = this.createFieldConfigFromCurrentSettings();
        config.appendXML(temp);
        return (Element)temp.getFirstChild();
    }

    InputRestriction<?> createInputRestriction(Variable inputRestrictionVariable, Variable dataVariable, DataType dt) {
        InputRestriction<?> ret = null;
        if (inputRestrictionVariable != null) {
            Object valueObject;
            InputRestrictionType type = (InputRestrictionType)((Object)inputRestrictionVariable.getValueObject());
            Object[] objectArray = valueObject = dataVariable != null ? dataVariable.getValueObject() : null;
            if (valueObject == null) {
                switch (type) {
                    case ENUMERATION: {
                        valueObject = FieldNodeHelper.createEmptyTypedTwoDimensionalArray(dt);
                        break;
                    }
                    case RANGE: {
                        Number min = dt.getMinimumValue();
                        Number max = dt.getMaximumValue();
                        min = min != null ? (Number)min : (Number)((Number)dt.createDefaultInstance());
                        max = max != null ? (Number)max : (Number)((Number)dt.createDefaultInstance());
                        valueObject = new RangeObject(dt.isIntegerNumeric(), min.toString(), max.toString());
                        break;
                    }
                    case NO_DATA: {
                        valueObject = "";
                        break;
                    }
                }
            }
            ret = type.createInputRestriction(valueObject, dt);
        }
        return ret;
    }

    private boolean isVirtualField() {
        String paramType = VarListUtil.getStringValueForName(this.myVarList, LABEL_PARAMETER_TYPE);
        return "VIRTUAL".equals(paramType);
    }

    @Override
    public void setDataItem(Object reference, Object object) {
        super.setDataItem(reference, object);
        String key = (String)reference;
        Variable variable = (Variable)object;
        assert (this.myVarList.contains(object)) : "FieldNode got an event from an unknown variable.";
        if (LABEL_DATA_TYPE.equals(key)) {
            DataType dt = DataType.lookup(variable.getValueString());
            if (this.myCurrentDataType != dt) {
                if (!this.shouldChangeDataType()) {
                    variable.setValue(this.myCurrentDataType.getTypeName());
                    return;
                }
                this.removeChildren();
                this.myCurrentDataType = dt;
            } else {
                return;
            }
        }
        if (this.isListChangingVariable(key)) {
            FieldNodeHelper.removeVariablesAfterLabel(this.myVarList, key);
            FieldConfig config = this.createFieldConfigFromCurrentSettings();
            VariableHandler vc = this.createVariableHandler(config.getDataType());
            this.populateVariableList(vc.createVariables(config));
        } else if (variable.getInfo(AFFECTS_DEFAULT_VARIABLE) == Boolean.TRUE) {
            Variable defaultVariable = VarListUtil.getVariableForName(this.myVarList, LABEL_DEFAULT);
            VariableHandler vc = this.createVariableHandler(this.getTypedDataType());
            vc.updateDefaultVariable(defaultVariable, this.createFieldConfigFromCurrentSettings());
        } else if (LABEL_PARAMETER_TYPE.equals(key)) {
            this.changeParameterType();
        }
    }

    private boolean isListChangingVariable(String label) {
        return LABEL_DATA_TYPE.equals(label) || LABEL_VALUE_COLLECTION.equals(label) || LABEL_INPUT_RESTRICTION.equals(label) || LABEL_KEY.equals(label);
    }

    private FieldConfig createFieldConfigFromCurrentSettings() {
        VariableHandler vc = this.createVariableHandler(this.getTypedDataType());
        return vc.createFieldConfig(this.myVarList);
    }

    private void changeParameterType() {
        if (this.isVirtualField()) {
            this.setValueIfExists(LABEL_MANDATORY, true);
        }
        if (this.updateAllowEdit(this.myVarList)) {
            this.updateTableModel();
        }
    }

    private boolean shouldChangeDataType() {
        boolean doChange = true;
        if (this.getChildCount() > 0) {
            doChange = this.myDialogFactory.getQuestionDialogCustomButtons(null, "Change data type", "This field has at least one condition that\nwill be deleted if the data type is changed.\n\nDo you want to continue changing the data type?", "Yes", "No");
        }
        return doChange;
    }

    private void removeChildren() {
        if (this.myModel != null) {
            while (this.getChildCount() > 0) {
                this.myModel.removeNodeFromParent((MutableTreeNode)this.getChildAt(0));
            }
        }
    }

    private void setValueIfExists(String label, Object value) {
        Variable var = VarListUtil.getVariableForName(this.myVarList, label);
        if (var != null) {
            var.setValue(value);
        }
    }

    private void performPreSaveCleanup() {
        DataType dataType = this.getTypedDataType();
        if (dataType == DataType.DATE) {
            Variable variable = VarListUtil.getVariableForName(this.myVarList, LABEL_DEFAULT);
            if (variable != null && variable instanceof ArrayVariable) {
                this.cleanUpArrayVariable((ArrayVariable)variable);
            }
            if ((variable = VarListUtil.getVariableForName(this.myVarList, "Enumeration")) != null && variable instanceof ArrayVariable) {
                this.cleanUpArrayVariable((ArrayVariable)variable);
            }
        }
    }

    private void cleanUpArrayVariable(ArrayVariable variable) {
        final boolean botNotAllowed = StringUtil.isEmptyString(this.getBeginningOfTimeLabel());
        final boolean eotNotAllowed = StringUtil.isEmptyString(this.getEndOfTimeLabel());
        FieldNodeHelper.updateArrayVariableValues(variable, new Transformer<Object, Object>(){

            @Override
            public Object transform(Object value) {
                boolean remove = botNotAllowed && value == EREDate.BEGINNING_OF_TIME || eotNotAllowed && value == EREDate.END_OF_TIME;
                return remove ? null : value;
            }
        });
    }

    @Override
    public void setTreeModel(DefaultTreeModel theModel) {
        super.setTreeModel(theModel);
        this.myModel = theModel;
        new TreeModelMonitor(theModel, this).onRemove(new Runnable(){

            @Override
            public void run() {
                UniqueStringVariable usv = (UniqueStringVariable)VarListUtil.getVariableForName(FieldNode.this.myVarList, "Name");
                usv.detachFromRepository();
            }
        }).onInsert(new Runnable(){

            @Override
            public void run() {
                UniqueStringVariable usv = (UniqueStringVariable)VarListUtil.getVariableForName(FieldNode.this.myVarList, "Name");
                usv.attachToRepository();
            }
        });
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        FieldConfig.ComplexType type;
        ImageIcon icon = DFLT_ICON;
        if (this.myParent instanceof HierarchicalFieldNode && (type = ((HierarchicalFieldNode)this.myParent).getComplexType()) == FieldConfig.ComplexType.MAP && this.isKey()) {
            icon = KEY_ICON;
        }
        return icon;
    }

    @Override
    public String getName() {
        return VarListUtil.getStringValueForName(this.myVarList, "Name");
    }

    String getParameterType() {
        return VarListUtil.getStringValueForName(this.myVarList, LABEL_PARAMETER_TYPE);
    }

    public String getDataType() {
        return this.myCurrentDataType.getTypeName();
    }

    private DataType getTypedDataType() {
        return this.myCurrentDataType;
    }

    public boolean isStrictArray() {
        return this.myWrappingGroupType == FieldGroupNode.GroupType.ARRAY_GROUP;
    }

    private boolean updateAllowEdit(List<Variable> variables) {
        VariableHandler vc = this.createVariableHandler(this.getTypedDataType());
        return vc.updateAllowEdit(variables);
    }

    @Override
    public String toString() {
        String collectionTypeString = "";
        FieldConfig.ComplexType collectionType = this.getCollectionType(this.myVarList);
        if (collectionType != null && collectionType != FieldConfig.ComplexType.NONE) {
            collectionTypeString = ", " + collectionType.name();
        }
        return this.getName() + " (" + this.getDataType() + collectionTypeString + ")";
    }

    public boolean isValueList() {
        return FieldConfig.ComplexType.ARRAY == this.getCollectionType(this.myVarList);
    }

    private FieldConfig.ComplexType getCollectionType(List<Variable> varList) {
        return (FieldConfig.ComplexType)((Object)VarListUtil.getValueForName(varList, LABEL_VALUE_COLLECTION));
    }

    public boolean isKey() {
        return this.isKey(this.myVarList);
    }

    public void setKey(boolean key) {
        Variable keyVar = VarListUtil.getVariableForName(this.myVarList, LABEL_KEY);
        if (keyVar != null) {
            keyVar.setValue(key);
        }
    }

    private boolean isKey(List<Variable> varList) {
        boolean key = false;
        if (this.myParent instanceof HierarchicalFieldNode) {
            Boolean isKey = VarListUtil.getBooleanValueForName(varList, LABEL_KEY);
            key = isKey != null && isKey != false;
        }
        return key;
    }

    public boolean isValueMap() {
        return FieldConfig.ComplexType.MAP == VarListUtil.getValueForName(this.myVarList, LABEL_VALUE_COLLECTION);
    }

    public boolean isValueSet() {
        return FieldConfig.ComplexType.SET == VarListUtil.getValueForName(this.myVarList, LABEL_VALUE_COLLECTION);
    }

    public boolean isComplexType() {
        return this.isValueList() || this.isValueMap();
    }

    void setupArrayVariable(ArrayVariable arrayVariable, DataType dataType) {
        arrayVariable.setVariableProducer(new VariableProducerDecorator(new DefaultVariableProducer(null)));
        arrayVariable.setObjectLabeler(new ObjectLabelerDecorator(new ArrayVariable.DefaultObjectLabeler(dataType)));
    }

    String getBeginningOfTimeLabel() {
        return VarListUtil.getStringValueForName(this.myVarList, LABEL_BEGINNING_OF_TIME);
    }

    String getEndOfTimeLabel() {
        return VarListUtil.getStringValueForName(this.myVarList, LABEL_END_OF_TIME);
    }

    private VariableHandler createVariableHandler(DataType dataType) {
        VariableHandler vc;
        switch (dataType) {
            case OBJECT: {
                vc = new ObjectVariableHandler();
                break;
            }
            case AMOUNT: {
                vc = new AmountVariableHandler();
                break;
            }
            case DATE: 
            case TIME: {
                vc = new DateVariableHandler();
                break;
            }
            case MONETARYUNITS: 
            case DECIMAL: {
                vc = new DeprecatedDataTypeVariableHandler();
                break;
            }
            default: {
                vc = new VariableHandler();
            }
        }
        return vc;
    }

    private static class InputRestrictionTypeItemLabeler
    implements TypedDropDownVariable.ItemLabeler<InputRestrictionType> {
        private InputRestrictionTypeItemLabeler() {
        }

        @Override
        public String getDisplayStringFor(InputRestrictionType object, int index) {
            return object.name().replace("_", " ");
        }
    }

    private class DeprecatedDataTypeVariableHandler
    extends VariableHandler {
        private DeprecatedDataTypeVariableHandler() {
        }

        @Override
        public List<Variable> createVariables(FieldConfig config) {
            List<Variable> vars = super.createVariables(config);
            String msg = String.format(FieldNode.MSG_DECIMAL_DATA_TYPE_DEPRECATED_FMT, config.getDataType().getTypeName());
            vars.add(0, new BackgroundCustomizableInfoVariable(FieldNode.LABEL_WARNING, msg, Color.YELLOW));
            return vars;
        }
    }

    private class DateVariableHandler
    extends VariableHandler {
        private DateVariableHandler() {
        }

        @Override
        protected List<Variable> createTypeSpecificVariables(FieldConfig config) {
            StringVariable v1 = new StringVariable(FieldNode.LABEL_BEGINNING_OF_TIME, config.getBeginningOfTimeLabel(), new StringDocument(1000L));
            StringVariable v2 = new StringVariable(FieldNode.LABEL_END_OF_TIME, config.getEndOfTimeLabel(), new StringDocument(1000L));
            ((Variable)v1).addInfo(AFFECTS_DEFAULT_VARIABLE, true);
            ((Variable)v2).addInfo(AFFECTS_DEFAULT_VARIABLE, true);
            return Arrays.asList(v1, v2);
        }

        @Override
        protected Variable createPlainDefaultVariable(FieldConfig config) {
            Variable v = super.createPlainDefaultVariable(config);
            assert (v instanceof DateAndTimeVariable);
            ((DateAndTimeVariable)v).setBeginningOfTimeText(config.getBeginningOfTimeLabel());
            ((DateAndTimeVariable)v).setEndOfTimeText(config.getEndOfTimeLabel());
            return v;
        }

        @Override
        public void updateDefaultVariable(Variable variable, FieldConfig config) {
            if (variable instanceof DateAndTimeVariable) {
                ((DateAndTimeVariable)variable).setBeginningOfTimeText(config.getBeginningOfTimeLabel());
                ((DateAndTimeVariable)variable).setEndOfTimeText(config.getEndOfTimeLabel());
            }
        }

        @Override
        public FieldConfig createFieldConfig(List<Variable> varList) {
            FieldConfig config = super.createFieldConfig(varList);
            config.setBeginningOfTimeLabel(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_BEGINNING_OF_TIME));
            config.setEndOfTimeLabel(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_END_OF_TIME));
            InputRestrictionType type = config.getInputRestriction().getType();
            if (type == InputRestrictionType.RELATIVE_DATE) {
                config.setValueClassFactory(LazyEvaluatedEREDateClassFactory.class.getName());
            }
            if (type == InputRestrictionType.RELATIVE_TIME) {
                config.setValueClassFactory(LazyEvaluatedERETimeClassFactory.class.getName());
            }
            return config;
        }
    }

    private class AmountVariableHandler
    extends VariableHandler {
        private AmountVariableHandler() {
        }

        @Override
        public boolean updateAllowEdit(List<Variable> variables) {
            boolean didUpdate = super.updateAllowEdit(variables);
            if (FieldNode.this.myWrappingGroupType.isComplex()) {
                didUpdate |= this.setAllowEdit(VarListUtil.getVariableForName(variables, FieldNode.LABEL_ALLOW_NEGATIVE), false);
            }
            return didUpdate;
        }

        @Override
        protected List<Variable> createTypeSpecificVariables(FieldConfig config) {
            BoolVariable v1 = new BoolVariable(FieldNode.LABEL_ALLOW_NEGATIVE, config.allowsNegativeAmountBalance());
            StringVariable v2 = new StringVariable(FieldNode.LABEL_AMOUNT_FACTORY, config.getAmountFactory());
            ((Variable)v1).addInfo(AFFECTS_DEFAULT_VARIABLE, true);
            return Arrays.asList(v1, v2);
        }

        @Override
        protected Variable createPlainDefaultVariable(FieldConfig config) {
            Variable v = super.createPlainDefaultVariable(config);
            assert (v instanceof AmountVariable);
            ((AmountVariable)v).setAllowNegative(config.allowsNegativeAmountBalance());
            return v;
        }

        @Override
        public void updateDefaultVariable(Variable variable, FieldConfig config) {
            final boolean allowNegative = config.allowsNegativeAmountBalance();
            if (variable instanceof AmountVariable) {
                String oldValue = variable.getValueString();
                String newValue = oldValue.substring(0, 3) + " 0.0";
                variable.setValue(newValue);
                ((AmountVariable)variable).setAllowNegative(allowNegative);
            } else if (variable instanceof ArrayVariable) {
                FieldNodeHelper.updateArrayVariableValues((ArrayVariable)variable, new Transformer<Object, Object>(){

                    @Override
                    public Object transform(Object input) {
                        Amount amount = (Amount)input;
                        if (amount.isLessThanZero() && !allowNegative) {
                            amount = amount.deduct(amount);
                        }
                        return amount;
                    }
                });
            }
        }

        @Override
        public FieldConfig createFieldConfig(List<Variable> varList) {
            FieldConfig config = super.createFieldConfig(varList);
            config.setAllowsNegativeAmountBalance(VarListUtil.getBooleanValueForName(varList, FieldNode.LABEL_ALLOW_NEGATIVE));
            config.setAmountFactory(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_AMOUNT_FACTORY));
            return config;
        }
    }

    private class ObjectVariableHandler
    extends VariableHandler {
        private ObjectVariableHandler() {
        }

        @Override
        protected boolean supportsInputRestriction(FieldConfig config) {
            return false;
        }

        @Override
        protected List<Variable> createTypeSpecificVariables(FieldConfig config) {
            InputRestriction<?> is = config.getInputRestriction();
            assert (is instanceof CustomEditorInputRestriction);
            String editorClass = (String)is.getValueObject();
            StringVariable v1 = new StringVariable(FieldNode.LABEL_EDITOR_CLASS, editorClass, new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andRequireSuperTypes(SimulationEditor.class, XMLInitializable.class).andDisallowEmptyName().andRequireEmptyConstructor()));
            StringVariable v2 = new StringVariable(FieldNode.LABEL_VALUE_CLASS, config.getValueClass(), new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andDisallowEmptyName().andAllowAbstractClass()));
            StringVariable v3 = new StringVariable(FieldNode.LABEL_VALUE_CLASS_FACTORY, config.getValueClassFactory(), new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andRequireSuperTypes(ValueClassFactory.class, new Class[0]).andRequireEmptyConstructor().andDisallowEmptyName()));
            return Arrays.asList(v1, v2, v3);
        }

        @Override
        public FieldConfig createFieldConfig(List<Variable> varList) {
            FieldConfig config = super.createFieldConfig(varList);
            Variable v = VarListUtil.getVariableForName(varList, FieldNode.LABEL_EDITOR_CLASS);
            CustomEditorInputRestriction is = v != null ? new CustomEditorInputRestriction(v.getValueString()) : null;
            config.setInputRestriction(is);
            config.setValueClass(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_VALUE_CLASS));
            config.setValueClassFactory(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_VALUE_CLASS_FACTORY));
            return config;
        }
    }

    private class VariableHandler {
        private VariableHandler() {
        }

        public boolean updateAllowEdit(List<Variable> variables) {
            FieldConfig.ComplexType parentCollectionType;
            boolean didUpdate = false;
            String parameterType = VarListUtil.getStringValueForName(variables, FieldNode.LABEL_PARAMETER_TYPE);
            for (Variable v : variables) {
                didUpdate |= this.setAllowEdit(v, this.isEnabledForParameterType(parameterType, v.getLabel()));
            }
            if (FieldNode.this.myWrappingGroupType.isComplex()) {
                didUpdate |= this.setAllowEdit(VarListUtil.getVariableForName(variables, FieldNode.LABEL_VALUE_COLLECTION), false);
                didUpdate |= this.setAllowEdit(VarListUtil.getVariableForName(variables, FieldNode.LABEL_AUTOMAP_CONDITION), false);
            }
            if (FieldNode.this.myParent instanceof HierarchicalFieldNode && (parentCollectionType = ((HierarchicalFieldNode)FieldNode.this.myParent).getComplexType()) == FieldConfig.ComplexType.MAP) {
                if (FieldNode.this.getCollectionType(variables) != FieldConfig.ComplexType.NONE) {
                    didUpdate |= this.setAllowEdit(VarListUtil.getVariableForName(variables, FieldNode.LABEL_KEY), false);
                }
                if (FieldNode.this.isKey(variables)) {
                    didUpdate |= this.setAllowEdit(VarListUtil.getVariableForName(variables, FieldNode.LABEL_VALUE_COLLECTION), false);
                }
            }
            return didUpdate;
        }

        protected boolean setAllowEdit(Variable var, boolean allowEdit) {
            boolean oldValue = var.isAllowEdit();
            var.setAllowEdit(allowEdit);
            return oldValue != allowEdit;
        }

        private boolean isEnabledForParameterType(String parameterType, String label) {
            if ("VIRTUAL".equals(parameterType)) {
                return !FieldNode.LABEL_MANDATORY.equals(label);
            }
            return true;
        }

        public void updateDefaultVariable(Variable defaultVariable, FieldConfig config) {
        }

        public List<Variable> createVariables(FieldConfig config) {
            String tooltip;
            HierarchicalFieldNode hierarchyParent;
            ArrayList<Variable> vars = new ArrayList<Variable>();
            UniqueStringVariable nameVar = new UniqueStringVariable("Name", config.getName(), FieldNode.this.myNameRepository, new RegularExpressionMatcherDocument("[^<>'&;/%\\:\"]*", false));
            vars.add(nameVar);
            vars.add(new IntegerVariable(FieldNode.LABEL_TAG_NUMBER, config.getTagNumber(), Integer.MIN_VALUE, Integer.MAX_VALUE, true));
            vars.add(new MultilineStringVariable(FieldNode.LABEL_COMMENT, config.getComment()));
            vars.add(this.createDataTypeVariable(config.getDataType()));
            vars.add(this.createParameterTypeVariable(config.getParameterType()));
            vars.add(new BoolVariable(FieldNode.LABEL_MANDATORY, config.isMandatory()));
            vars.add(new BoolVariable(FieldNode.LABEL_AUTOMAP_CONDITION, config.shouldShowInPlugins()));
            vars.addAll(this.createTypeSpecificVariables(config));
            vars.add(new DropDownVariable(FieldNode.LABEL_VALUE_COLLECTION, (Object)config.getComplexType(), (Object[])FieldConfig.ComplexType.values()));
            if (this.supportsDefaultValue(config)) {
                vars.add(this.createDefaultVariable(config));
            }
            if (this.supportsInputRestriction(config)) {
                vars.addAll(this.createInputRestrictionVariables(config));
            }
            if (FieldNode.this.myParent instanceof HierarchicalFieldNode && (hierarchyParent = (HierarchicalFieldNode)FieldNode.this.myParent).getComplexType() == FieldConfig.ComplexType.MAP) {
                vars.add(new BoolVariable(FieldNode.LABEL_KEY, config.isKey()));
            }
            vars.add(new StringVariable(FieldNode.LABEL_TOOLTIP, (tooltip = config.getTooltip()) != null ? tooltip : ""));
            return vars;
        }

        public FieldConfig createFieldConfig(List<Variable> varList) {
            DataType dataType = DataType.lookup(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_DATA_TYPE));
            FieldConfig config = new FieldConfig(FieldNode.this.myWrappingGroupType);
            config.setName(VarListUtil.getStringValueForName(varList, "Name"));
            config.setTagNumber(VarListUtil.getValueStringForName(varList, FieldNode.LABEL_TAG_NUMBER));
            config.setComment(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_COMMENT));
            config.setDataType(dataType);
            config.setParameterType(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_PARAMETER_TYPE));
            config.setMandatory(VarListUtil.getBooleanValueForName(varList, FieldNode.LABEL_MANDATORY));
            config.setShouldShowInPlugins(VarListUtil.getBooleanValueForName(varList, FieldNode.LABEL_AUTOMAP_CONDITION));
            config.setKey(FieldNode.this.isKey(varList));
            config.setComplexType((FieldConfig.ComplexType)((Object)VarListUtil.getValueForName(varList, FieldNode.LABEL_VALUE_COLLECTION)));
            config.setDefaultValue(this.getDefaultValue(varList));
            Variable inputRestrictionVariable = VarListUtil.getVariableForName(varList, FieldNode.LABEL_INPUT_RESTRICTION);
            Variable dataVariable = this.findInputRestrictionDataVariable(varList);
            config.setInputRestriction(FieldNode.this.createInputRestriction(inputRestrictionVariable, dataVariable, dataType));
            config.setTooltip(VarListUtil.getStringValueForName(varList, FieldNode.LABEL_TOOLTIP));
            return config;
        }

        private Variable findInputRestrictionDataVariable(List<Variable> varList) {
            Variable v = null;
            for (Variable candidate : varList) {
                if (candidate.getInfo(INPUTRESTRICTION_DATA_VARIABLE_MARKER) == null) continue;
                v = candidate;
                break;
            }
            return v;
        }

        private Object[] getDefaultValue(List<Variable> varList) {
            Object[] objectArray;
            Object value = VarListUtil.getValueForName(varList, FieldNode.LABEL_DEFAULT);
            if (value == null || value instanceof Object[]) {
                objectArray = (Object[])value;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            }
            return objectArray;
        }

        protected boolean supportsDefaultValue(FieldConfig config) {
            boolean support = true;
            if (config.getComplexType() == FieldConfig.ComplexType.MAP && FieldNode.this.myWrappingGroupType == FieldGroupNode.GroupType.GROUP) {
                support = false;
            }
            if (config.getComplexType() == FieldConfig.ComplexType.SET) {
                support = false;
            }
            return support;
        }

        protected List<Variable> createTypeSpecificVariables(FieldConfig config) {
            return Collections.emptyList();
        }

        protected boolean supportsInputRestriction(FieldConfig config) {
            boolean support = true;
            if (config.getComplexType() != FieldConfig.ComplexType.NONE && FieldNode.this.myWrappingGroupType == FieldGroupNode.GroupType.GROUP) {
                support = false;
            }
            return support;
        }

        private Variable createParameterTypeVariable(String parameterType) {
            return new DropDownVariable(FieldNode.LABEL_PARAMETER_TYPE, (Object)parameterType, (Object[])new String[]{"IN", "OUT", "VARIABLE", "VALIDATION", "VIRTUAL", "WORKING"});
        }

        private List<Variable> createInputRestrictionVariables(FieldConfig config) {
            List<Variable> vars;
            DataType dataType = config.getDataType();
            InputRestrictionType[] restrictionsArray = this.getSupportedInputRestrictions(dataType);
            InputRestriction<?> is = config.getInputRestriction();
            TypedDropDownVariable<InputRestrictionType> v1 = new TypedDropDownVariable<InputRestrictionType>(FieldNode.LABEL_INPUT_RESTRICTION, restrictionsArray, is.getType(), new InputRestrictionTypeItemLabeler());
            Variable v2 = is.createVariable();
            if (v2 == null) {
                vars = Collections.singletonList(v1);
            } else {
                v2.addInfo(INPUTRESTRICTION_DATA_VARIABLE_MARKER, new Object());
                vars = Arrays.asList(v1, v2);
            }
            return vars;
        }

        private InputRestrictionType[] getSupportedInputRestrictions(DataType dataType) {
            boolean supportsBitPattern = BitPatternEditor.isDataTypeSupported(dataType);
            boolean supportsRange = dataType.isNumeric() && dataType != DataType.DOUBLE && dataType != DataType.DECIMAL && dataType != DataType.MONETARYUNITS;
            boolean supportsRelativeDate = dataType == DataType.DATE;
            boolean supportsRelativeTime = dataType == DataType.TIME;
            boolean supportsEnum = dataType != DataType.OBJECT;
            ArrayList<InputRestrictionType> restrictions = new ArrayList<InputRestrictionType>();
            restrictions.add(InputRestrictionType.NO_DATA);
            this.addConditionally(restrictions, InputRestrictionType.RANGE, supportsRange);
            this.addConditionally(restrictions, InputRestrictionType.ENUMERATION, supportsEnum);
            this.addConditionally(restrictions, InputRestrictionType.BIT_PATTERN, supportsBitPattern);
            this.addConditionally(restrictions, InputRestrictionType.RELATIVE_DATE, supportsRelativeDate);
            this.addConditionally(restrictions, InputRestrictionType.RELATIVE_TIME, supportsRelativeTime);
            InputRestrictionType[] restrictionsArray = restrictions.toArray(new InputRestrictionType[restrictions.size()]);
            return restrictionsArray;
        }

        private <T> void addConditionally(List<T> list, T item, boolean add) {
            if (add) {
                list.add(item);
            }
        }

        protected Variable createDefaultVariable(FieldConfig config) {
            boolean isArray = config.getComplexType() == FieldConfig.ComplexType.ARRAY;
            Variable var = isArray && FieldNode.this.myWrappingGroupType == FieldGroupNode.GroupType.GROUP ? this.createArrayDefaultVariable(config) : this.createPlainDefaultVariable(config);
            return var;
        }

        protected Variable createArrayDefaultVariable(FieldConfig config) {
            DataType dataType = config.getDataType();
            Object[] values = config.hasDefaultValue() ? config.getDefaultValue() : dataType.createArray();
            ArrayVariable var = new ArrayVariable(FieldNode.LABEL_DEFAULT, values, (ValueResolver)dataType);
            FieldNode.this.setupArrayVariable(var, dataType);
            return var;
        }

        protected Variable createPlainDefaultVariable(FieldConfig config) {
            DataType dt = config.getDataType();
            Object value = config.hasDefaultValue() ? config.getDefaultValue()[0] : dt.createDefaultInstance();
            return VariableFactory.getVariableOfDataType(dt.getTypeName(), FieldNode.LABEL_DEFAULT, null, null, null, value);
        }

        private Variable createDataTypeVariable(DataType defaultType) {
            ArrayList<String> names = new ArrayList<String>();
            for (DataType type : DataType.values()) {
                names.add(type.getTypeName());
            }
            Collections.sort(names);
            return new DropDownVariable(FieldNode.LABEL_DATA_TYPE, (Object)defaultType.getTypeName(), (Object[])names.toArray(new String[names.size()]));
        }
    }

    private class ObjectLabelerDecorator
    implements ArrayVariable.ObjectLabeler {
        private ArrayVariable.ObjectLabeler myInnerLabeler;

        public ObjectLabelerDecorator(ArrayVariable.ObjectLabeler labeler) {
            this.myInnerLabeler = labeler;
        }

        @Override
        public String getDisplayStringForObject(Object o) {
            String botLabel;
            if (o == EREDate.BEGINNING_OF_TIME) {
                String botLabel2 = FieldNode.this.getBeginningOfTimeLabel();
                if (!StringUtil.isEmptyString(botLabel2)) {
                    return botLabel2;
                }
            } else if (o == EREDate.END_OF_TIME && !StringUtil.isEmptyString(botLabel = FieldNode.this.getEndOfTimeLabel())) {
                return botLabel;
            }
            return this.myInnerLabeler.getDisplayStringForObject(o);
        }
    }

    private class VariableProducerDecorator
    implements VariableProducer {
        VariableProducer myProducer;

        public VariableProducerDecorator(VariableProducer producer) {
            this.myProducer = producer;
        }

        @Override
        public Variable produceVariable(FieldDefinition field) {
            return this.myProducer.produceVariable(field);
        }

        @Override
        public Variable produceVariable(DataType dataType, Object value) {
            Variable theVar = this.myProducer.produceVariable(dataType, value);
            if (theVar instanceof DateAndTimeVariable && ((DateAndTimeVariable)theVar).isDateContent()) {
                ((DateAndTimeVariable)theVar).setBeginningOfTimeText(FieldNode.this.getBeginningOfTimeLabel());
                ((DateAndTimeVariable)theVar).setEndOfTimeText(FieldNode.this.getEndOfTimeLabel());
            } else if (theVar instanceof AmountVariable) {
                boolean allowNegative = VarListUtil.getBooleanValueForName(FieldNode.this.myVarList, FieldNode.LABEL_ALLOW_NEGATIVE);
                ((AmountVariable)theVar).setAllowNegative(allowNegative);
            }
            return theVar;
        }

        @Override
        public Variable produceVariable(String groupName, List<FieldDefinition> fields) {
            return this.myProducer.produceVariable(groupName, fields);
        }
    }
}

