/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes;

import com.ericsson.ere.dataset.DataSetFactory;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.simulator.SimulationFactory;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeMigrator;
import com.ericsson.ere.selectiontree.mdu.filter.MultiDataUpdateFilterFactory;
import com.ericsson.vareditor.document.ClassNameDocument;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.NodeListWrapper;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.StringDocument;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FieldTopNode
extends AbstractTreeNode {
    private static final String LBL_XML_MIGRATOR = "XML Migrator";
    private static final String LBL_MDU_FILTER_FACTORY = "MDU Filter Factory";
    private static final String LBL_SIM_FACTORY = "Simulation Factory";
    private static final String LBL_DATASET_FACTORY = "DataSet Factory";
    private static final String LBL_COMMENT = "Comment";
    private static final String LBL_DESCRIPTION = "Description";
    private static final String LBL_SAVED = "Saved";
    private static final String LBL_CREATED = "Created";
    private static final String LBL_SERVICE = "Service";
    public static final String LBL_SEPARATOR = "Separator";
    private static final String TAG_SERVICE_DEFINITION = "ServiceDefinition";
    private static final String TAG_CREATED_DATE = "CreatedDate";
    private static final String TAG_SAVED_DATE = "SavedDate";
    private static final String TAG_DESCRIPTION = "Description";
    private static final String TAG_DATASET_FACTORY = "DataSetFactory";
    private static final String TAG_SIMULATION_FACTORY = "SimulationFactory";
    private static final String TAG_FILTER_FACTORY = "MDUFilterFactory";
    private static final String TAG_MIGRATOR = "Migrator";
    private static final String ATT_SERVICE = "Service";
    private static final String ATT_DATE = "date";
    private static final String ATT_CLASS = "class";
    public static final String ATT_SEPARATOR = "Separator";
    public static final String DEFAULT_SEPARATOR = ".";
    private static final ImageIcon ICON = RmaDefs.getImageIcon("navigator_service.png");
    private boolean myIsMDUTurnedOn;

    private boolean isMDUTurnedOn(ServiceProxy proxy) {
        if (proxy == null) {
            return false;
        }
        FunctionContext context = FunctionContext.build().withProxy(proxy).get();
        FunctionState state = FunctionManagerImpl.getInstance().getStateForFunction(FunctionToken.MULTI_DATA_UPDATE, context);
        return state.getState() == FunctionState.State.ON;
    }

    public FieldTopNode(ServiceProxy proxy, Element node) {
        this.myIsMDUTurnedOn = this.isMDUTurnedOn(proxy);
        StringVariable service = new StringVariable("Service", "");
        DateAndTimeVariable createdDate = new DateAndTimeVariable(LBL_CREATED, DateAndTimeVariable.Content.DATE_TIME);
        DateAndTimeVariable savedDate = new DateAndTimeVariable(LBL_SAVED, DateAndTimeVariable.Content.DATE_TIME);
        this.myVarList.add(service);
        this.myVarList.add(createdDate);
        this.myVarList.add(savedDate);
        this.myVarList.add(new MultilineStringVariable("Description", ""));
        this.myVarList.add(new MultilineStringVariable(LBL_COMMENT, ""));
        this.myVarList.add(new StringVariable(LBL_DATASET_FACTORY, "", new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andDisallowEmptyName().andRequireEmptyConstructor().andRequireSuperTypes(DataSetFactory.class, new Class[0]))));
        this.myVarList.add(new StringVariable(LBL_SIM_FACTORY, "", new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andDisallowEmptyName().andRequireEmptyConstructor().andRequireSuperTypes(SimulationFactory.class, new Class[0]))));
        if (this.myIsMDUTurnedOn) {
            this.myVarList.add(new StringVariable(LBL_MDU_FILTER_FACTORY, "", new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andRequireEmptyConstructor().andRequireSuperTypes(MultiDataUpdateFilterFactory.class, new Class[0]))));
        }
        this.myVarList.add(new StringVariable(LBL_XML_MIGRATOR, "", new ClassNameDocument(ClassNameDocument.ClassRules.defaultRules().andRequireEmptyConstructor().andRequireSuperTypes(SelectionTreeNodeMigrator.class, new Class[0]))));
        String separator = DEFAULT_SEPARATOR;
        if (XMLUtil.getFirstElementNamed("Fields", node) != null) {
            separator = XMLUtil.getAttributeFromElement(XMLUtil.getFirstElementNamed("Fields", node), "Separator", DEFAULT_SEPARATOR);
        }
        this.myVarList.add(new StringVariable("Separator", separator, new StringDocument(false)));
        this.init(node);
        ((Variable)service).setAllowEdit(false);
        ((Variable)createdDate).setAllowEdit(false);
        ((Variable)savedDate).setAllowEdit(false);
    }

    public String getSeparator() {
        return VarListUtil.getStringValueForName(this.myVarList, "Separator");
    }

    public void setSeparator(String aSeparator) {
        VarListUtil.getVariableForName(this.myVarList, "Separator").setValue(aSeparator);
    }

    private void init(Node aNode) {
        NodeList childNodes = aNode.getChildNodes();
        this.setVariableValue("Service", TAG_SERVICE_DEFINITION, NodeListWrapper.wrapNode(aNode), "Service", null);
        this.setVariableValue(LBL_CREATED, TAG_CREATED_DATE, childNodes, ATT_DATE, null);
        this.setVariableValue(LBL_SAVED, TAG_SAVED_DATE, childNodes, ATT_DATE, DataType.TIME);
        this.setVariableValue("Description", "Description", childNodes, null, null);
        this.setVariableValue(LBL_DATASET_FACTORY, TAG_DATASET_FACTORY, childNodes, ATT_CLASS, null);
        this.setVariableValue(LBL_SIM_FACTORY, TAG_SIMULATION_FACTORY, childNodes, ATT_CLASS, null);
        this.setVariableValue(LBL_XML_MIGRATOR, TAG_MIGRATOR, childNodes, ATT_CLASS, null);
        if (this.myIsMDUTurnedOn) {
            this.setVariableValue(LBL_MDU_FILTER_FACTORY, TAG_FILTER_FACTORY, childNodes, ATT_CLASS, null);
        }
        StringBuilder b = new StringBuilder();
        for (Node commentNode : new NodeListIterable(childNodes, 8)) {
            if (b.length() > 0) {
                b.append("\n");
            }
            b.append(commentNode.getNodeValue());
        }
        VarListUtil.getVariableForName(this.myVarList, LBL_COMMENT).setValue(b.toString());
    }

    private Object parseValue(String s, DataType dt) {
        Object value = dt.parseValue(s);
        return value != null ? value : dt.createDefaultInstance();
    }

    private void setVariableValue(String label, String tag, NodeList nl, String attr, DataType dataType) {
        Element e = XMLUtil.getNamedElement(tag, nl);
        if (e != null) {
            String value = attr != null ? e.getAttribute(attr) : e.getTextContent();
            Variable v = VarListUtil.getVariableForName(this.myVarList, label);
            if (dataType != null) {
                Object obj = this.parseValue(value, dataType);
                v.setValue(obj);
            } else {
                v.setValue(value);
            }
        }
    }

    public void setSavedDate(Time aTime) {
        if (aTime != null) {
            VarListUtil.getVariableForName(this.myVarList, LBL_SAVED).setValue(aTime);
        }
    }

    @Override
    protected Element createConfigurationElement(Document doc) {
        String xmlMigrator;
        Element e = doc.createElement(TAG_SERVICE_DEFINITION);
        e.setAttribute("Service", this.getVariableString("Service"));
        e.appendChild(this.createElementWithAttribute(doc, TAG_CREATED_DATE, ATT_DATE, this.getVariableString(LBL_CREATED)));
        e.appendChild(this.createElementWithAttribute(doc, TAG_SAVED_DATE, ATT_DATE, this.getVariableString(LBL_SAVED)));
        Element desc = doc.createElement("Description");
        desc.setTextContent(this.getVariableString("Description"));
        e.appendChild(desc);
        e.appendChild(this.createElementWithAttribute(doc, TAG_DATASET_FACTORY, ATT_CLASS, this.getVariableString(LBL_DATASET_FACTORY)));
        e.appendChild(this.createElementWithAttribute(doc, TAG_SIMULATION_FACTORY, ATT_CLASS, this.getVariableString(LBL_SIM_FACTORY)));
        String filterFactory = this.getVariableString(LBL_MDU_FILTER_FACTORY);
        if (this.myIsMDUTurnedOn && !StringUtil.isEmptyString(filterFactory)) {
            e.appendChild(this.createElementWithAttribute(doc, TAG_FILTER_FACTORY, ATT_CLASS, filterFactory));
        }
        if (!StringUtil.isEmptyString(xmlMigrator = this.getVariableString(LBL_XML_MIGRATOR))) {
            e.appendChild(this.createElementWithAttribute(doc, TAG_MIGRATOR, ATT_CLASS, xmlMigrator));
        }
        e.appendChild(doc.createComment(this.getVariableString(LBL_COMMENT)));
        return e;
    }

    private String getVariableString(String label) {
        return VarListUtil.getValueStringForName(this.myVarList, label);
    }

    private Node createElementWithAttribute(Document doc, String tagName, String attrName, String attrValue) {
        Element e = doc.createElement(tagName);
        e.setAttribute(attrName, attrValue);
        return e;
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        return ICON;
    }

    @Override
    public String getName() {
        return this.getVariableString("Service");
    }

    @Override
    public String toString() {
        return "Service (" + this.getVariableString("Service") + ")";
    }
}

